/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.opencastproject.metadata.api.CatalogService;
import org.opencastproject.metadata.mpeg7.Mpeg7Catalog;
import org.opencastproject.metadata.mpeg7.Mpeg7CatalogImpl;
import org.opencastproject.util.XmlSafeParser;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={Mpeg7CatalogService.class, CatalogService.class}, property={"service.description=Mpeg7 Catalog Service"})
public class Mpeg7CatalogService
implements CatalogService<Mpeg7Catalog> {
    public InputStream serialize(Mpeg7Catalog catalog) throws IOException {
        try {
            Transformer tf = XmlSafeParser.newTransformerFactory().newTransformer();
            DOMSource xmlSource = new DOMSource(catalog.toXml());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            tf.transform(xmlSource, new StreamResult((OutputStream)out));
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Mpeg7Catalog load(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Stream must not be null");
        }
        return new Mpeg7CatalogImpl(in);
    }

    public Mpeg7Catalog newInstance() {
        return new Mpeg7CatalogImpl();
    }
}

