/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencastproject.metadata.mpeg7.FreeTextAnnotation;
import org.opencastproject.metadata.mpeg7.FreeTextAnnotationImpl;
import org.opencastproject.metadata.mpeg7.KeywordAnnotation;
import org.opencastproject.metadata.mpeg7.KeywordAnnotationImpl;
import org.opencastproject.metadata.mpeg7.TextAnnotation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextAnnotationImpl
implements TextAnnotation {
    private static DecimalFormatSymbols standardSymbols = new DecimalFormatSymbols(Locale.US);
    protected float confidence = -1.0f;
    protected float relevance = -1.0f;
    protected String language = null;
    protected List<KeywordAnnotation> keywordAnnotations = null;
    protected List<FreeTextAnnotation> freeTextAnnotations = null;

    public TextAnnotationImpl(float confidence, float relevance, String language) {
        this.confidence = confidence;
        this.relevance = relevance;
        this.language = language;
        this.keywordAnnotations = new ArrayList<KeywordAnnotation>();
        this.freeTextAnnotations = new ArrayList<FreeTextAnnotation>();
    }

    public void addKeyword(String keyword) {
        this.addKeywordAnnotation(new KeywordAnnotationImpl(keyword));
    }

    public void addKeyword(String keyword, KeywordAnnotation.Type type) {
        this.addKeywordAnnotation(new KeywordAnnotationImpl(keyword, type));
    }

    @Override
    public void addKeywordAnnotation(KeywordAnnotation keywordAnnotation) {
        this.keywordAnnotations.add(keywordAnnotation);
    }

    public void addFreeText(String text) {
        this.addFreeTextAnnotation(new FreeTextAnnotationImpl(text));
    }

    @Override
    public void addFreeTextAnnotation(FreeTextAnnotation freeTextAnnotation) {
        this.freeTextAnnotations.add(freeTextAnnotation);
    }

    @Override
    public float getConfidence() {
        return this.confidence;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public float getRelevance() {
        return this.relevance;
    }

    @Override
    public Iterator<KeywordAnnotation> keywordAnnotations() {
        return this.keywordAnnotations.iterator();
    }

    @Override
    public Iterator<FreeTextAnnotation> freeTextAnnotations() {
        return this.freeTextAnnotations.iterator();
    }

    public Node toXml(Document document) {
        DecimalFormat format = new DecimalFormat("0.0");
        format.setDecimalFormatSymbols(standardSymbols);
        Element node = document.createElement("TextAnnotation");
        if ((double)this.confidence >= 0.0) {
            node.setAttribute("confidence", format.format(this.confidence));
        }
        if ((double)this.relevance >= 0.0) {
            node.setAttribute("relevance", format.format(this.relevance));
        }
        if (this.language != null) {
            node.setAttribute("xml:lang", this.language);
        }
        if (this.keywordAnnotations.size() > 0) {
            Element kwAnnotationNode = document.createElement("KeywordAnnotation");
            for (KeywordAnnotation annotation : this.keywordAnnotations) {
                kwAnnotationNode.appendChild(annotation.toXml(document));
            }
            node.appendChild(kwAnnotationNode);
        }
        for (FreeTextAnnotation annotation : this.freeTextAnnotations) {
            node.appendChild(annotation.toXml(document));
        }
        return node;
    }

    static {
        standardSymbols.setDecimalSeparator('.');
    }
}

