/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.opencastproject.metadata.mpeg7.Audio;
import org.opencastproject.metadata.mpeg7.AudioVisual;
import org.opencastproject.metadata.mpeg7.MediaLocator;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.Mpeg7Catalog;
import org.opencastproject.metadata.mpeg7.Mpeg7Parser;
import org.opencastproject.metadata.mpeg7.MultimediaContent;
import org.opencastproject.metadata.mpeg7.MultimediaContentImpl;
import org.opencastproject.metadata.mpeg7.MultimediaContentType;
import org.opencastproject.metadata.mpeg7.MultimediaContentTypeImpl;
import org.opencastproject.metadata.mpeg7.Video;
import org.opencastproject.util.XmlSafeParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Mpeg7CatalogImpl
implements Mpeg7Catalog {
    private static final long serialVersionUID = 5521535164920498997L;
    private HashMap<MultimediaContent.Type, MultimediaContentImpl<? extends MultimediaContentType>> multimediaContent = new HashMap();
    public static final String NS = "mpeg7";

    public Mpeg7CatalogImpl() {
    }

    public Mpeg7CatalogImpl(InputStream in) {
        this();
        this.loadCatalogData(in);
    }

    private void loadCatalogData(InputStream in) throws IllegalStateException {
        Mpeg7Parser parser = new Mpeg7Parser(this);
        try {
            parser.parse(in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load mpeg-7 catalog data:" + e.getMessage(), e);
        }
    }

    public static Mpeg7CatalogImpl newInstance() {
        Mpeg7CatalogImpl mpeg7 = new Mpeg7CatalogImpl();
        return mpeg7;
    }

    @Override
    public Iterator<MultimediaContent<? extends MultimediaContentType>> multimediaContent() {
        ArrayList<MultimediaContent> result = new ArrayList<MultimediaContent>();
        for (MultimediaContent multimediaContent : this.multimediaContent.values()) {
            result.add(multimediaContent);
        }
        return result.iterator();
    }

    @Override
    public MultimediaContent<? extends MultimediaContentType> getMultimediaContent(MultimediaContent.Type type) {
        return this.multimediaContent.get((Object)type);
    }

    @Override
    public Document toXml() throws ParserConfigurationException, TransformerException, IOException {
        Document doc = this.createDocument();
        Element root = doc.getDocumentElement();
        Element descriptionNode = doc.createElement("Description");
        descriptionNode.setAttribute("xsi:type", "ContentEntityType");
        root.appendChild(descriptionNode);
        for (MultimediaContent multimediaContent : this.multimediaContent.values()) {
            descriptionNode.appendChild(multimediaContent.toXml(doc));
        }
        return doc;
    }

    private Document createDocument() throws ParserConfigurationException {
        Document doc = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder().newDocument();
        Element rootElement = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Mpeg7");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mpeg7", "urn:mpeg7:schema:2001");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        doc.appendChild(rootElement);
        return doc;
    }

    @Override
    public Audio addAudioContent(String id, MediaTime time, MediaLocator locator) {
        MultimediaContentImpl content = (MultimediaContentImpl)this.getMultimediaContent(MultimediaContent.Type.AudioType);
        if (content == null) {
            content = new MultimediaContentImpl(MultimediaContent.Type.AudioType);
            this.multimediaContent.put(MultimediaContent.Type.AudioType, content);
        }
        MultimediaContentTypeImpl audio = new MultimediaContentTypeImpl(MultimediaContentType.Type.Audio, id);
        audio.setMediaTime(time);
        audio.setMediaLocator(locator);
        content.add(audio);
        return audio;
    }

    @Override
    public Audio removeAudioContent(String id) {
        MultimediaContentType element = this.removeContentElement(id, MultimediaContent.Type.AudioType);
        if (element != null) {
            return (Audio)element;
        }
        return null;
    }

    @Override
    public boolean hasAudioContent() {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.AudioType);
        return content != null && content.size() > 0;
    }

    @Override
    public Iterator<Audio> audioContent() {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.AudioType);
        if (content != null) {
            return content.elements();
        }
        return null;
    }

    @Override
    public Video addVideoContent(String id, MediaTime time, MediaLocator locator) {
        MultimediaContentImpl content = (MultimediaContentImpl)this.getMultimediaContent(MultimediaContent.Type.VideoType);
        if (content == null) {
            content = new MultimediaContentImpl(MultimediaContent.Type.VideoType);
            this.multimediaContent.put(MultimediaContent.Type.VideoType, content);
        }
        MultimediaContentTypeImpl video = new MultimediaContentTypeImpl(MultimediaContentType.Type.Video, id);
        content.add(video);
        video.setMediaTime(time);
        video.setMediaLocator(locator);
        return video;
    }

    @Override
    public Video removeVideoContent(String id) {
        MultimediaContentType element = this.removeContentElement(id, MultimediaContent.Type.VideoType);
        if (element != null) {
            return (Video)element;
        }
        return null;
    }

    @Override
    public boolean hasVideoContent() {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.VideoType);
        return content != null && content.size() > 0;
    }

    @Override
    public Iterator<Video> videoContent() {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.VideoType);
        if (content != null) {
            return content.elements();
        }
        return null;
    }

    @Override
    public AudioVisual addAudioVisualContent(String id, MediaTime time, MediaLocator locator) {
        MultimediaContentImpl content = (MultimediaContentImpl)this.getMultimediaContent(MultimediaContent.Type.AudioVisualType);
        if (content == null) {
            content = new MultimediaContentImpl(MultimediaContent.Type.AudioVisualType);
            this.multimediaContent.put(MultimediaContent.Type.AudioVisualType, content);
        }
        MultimediaContentTypeImpl audioVisual = new MultimediaContentTypeImpl(MultimediaContentType.Type.AudioVisual, id);
        audioVisual.setMediaTime(time);
        audioVisual.setMediaLocator(locator);
        content.add(audioVisual);
        return audioVisual;
    }

    @Override
    public AudioVisual removeAudioVisualContent(String id) {
        MultimediaContentType element = this.removeContentElement(id, MultimediaContent.Type.AudioVisualType);
        if (element != null) {
            return (AudioVisual)element;
        }
        return null;
    }

    @Override
    public boolean hasAudioVisualContent() {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.AudioVisualType);
        return content != null && content.size() > 0;
    }

    @Override
    public Iterator<AudioVisual> audiovisualContent() {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.AudioVisualType);
        if (content != null) {
            return content.elements();
        }
        return null;
    }

    @Override
    public Audio getAudioById(String id) {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.AudioType);
        if (content == null) {
            return null;
        }
        return (Audio)content.getElementById(id);
    }

    @Override
    public AudioVisual getAudioVisualById(String id) {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.AudioVisualType);
        if (content == null) {
            return null;
        }
        return (AudioVisual)content.getElementById(id);
    }

    @Override
    public Video getVideoById(String id) {
        MultimediaContent<? extends MultimediaContentType> content = this.getMultimediaContent(MultimediaContent.Type.VideoType);
        if (content == null) {
            return null;
        }
        return (Video)content.getElementById(id);
    }

    private MultimediaContentType removeContentElement(String id, MultimediaContent.Type type) {
        MultimediaContentImpl<? extends MultimediaContentType> content = this.multimediaContent.get((Object)type);
        if (content != null) {
            return content.remove(id);
        }
        return null;
    }

    @Override
    public Mpeg7Catalog clone() {
        Mpeg7CatalogImpl clone = new Mpeg7CatalogImpl();
        clone.multimediaContent = (HashMap)this.multimediaContent.clone();
        return clone;
    }
}

