/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.lti;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=LTI Servlet"})
@HttpWhiteboardServletName(value="/lti")
@HttpWhiteboardServletPattern(value={"/lti/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class LtiServlet
extends HttpServlet {
    private static final String LTI_CUSTOM_PREFIX = "custom_";
    private static final String LTI_CUSTOM_TOOL = "custom_tool";
    private static final String LTI_CUSTOM_TEST = "custom_test";
    private static final Logger logger = LoggerFactory.getLogger(LtiServlet.class);
    private static final long serialVersionUID = 6138043870346176520L;
    public static final String SESSION_ATTRIBUTE_KEY = "org.opencastproject.lti.LtiServlet";
    private static final String TOOLS_URL = "/ltitools";
    public static final String LTI_MESSAGE_TYPE = "lti_message_type";
    public static final String LTI_VERSION = "lti_version";
    public static final String RESOURCE_LINK_ID = "resource_link_id";
    public static final String RESOURCE_LINK_TITLE = "resource_link_title";
    public static final String RESOURCE_LINK_DESCRIPTION = "resource_link_description";
    public static final String USER_ID = "user_id";
    public static final String USER_IMAGE = "user_image";
    public static final String ROLES = "roles";
    public static final String GIVEN_NAME = "lis_person_name_given";
    public static final String FAMILY_NAME = "lis_person_name_family";
    public static final String FULL_NAME = "lis_person_name_full";
    public static final String EMAIL = "lis_person_contact_email_primary";
    public static final String CONTEXT_ID = "context_id";
    public static final String CONTEXT_TYPE = "context_type";
    public static final String CONTEXT_TITLE = "context_title";
    public static final String CONTEXT_LABEL = "context_label";
    public static final String LOCALE = "launch_presentation_locale";
    public static final String TARGET = "launch_presentation_document_target";
    public static final String WIDTH = "launch_presentation_width";
    public static final String HEIGHT = "launch_presentation_height";
    public static final String RETURN_URL = "launch_presentation_return_url";
    public static final String CONSUMER_GUID = "tool_consumer_instance_guid";
    public static final String CONSUMER_NAME = "tool_consumer_instance_name";
    public static final String CONSUMER_DESCRIPTION = "tool_consumer_instance_description";
    public static final String CONSUMER_URL = "tool_consumer_instance_url";
    public static final String CONSUMER_CONTACT = "tool_consumer_instance_contact_email";
    public static final String COURSE_OFFERING = "lis_course_offering_sourcedid";
    public static final String COURSE_SECTION = "lis_course_section_sourcedid";
    public static final SortedSet<String> LTI_CONSTANTS = new TreeSet<String>();

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UriBuilder builder;
        HttpSession session = req.getSession(false);
        session.setAttribute(SESSION_ATTRIBUTE_KEY, this.getLtiValuesAsMap(req));
        try {
            String customTool = URLDecoder.decode(StringUtils.trimToEmpty((String)req.getParameter(LTI_CUSTOM_TOOL)), StandardCharsets.UTF_8.displayName());
            customTool = customTool.replaceAll("/?ltitools/(?<tool>[^/]*)/index.html\\??", "/ltitools/index.html?subtool=${tool}&");
            URI toolUri = new URI(customTool);
            if (toolUri.getPath().isEmpty()) {
                throw new URISyntaxException(toolUri.toString(), "Provided 'custom_tool' has an empty path");
            }
            builder = !toolUri.isOpaque() && !toolUri.getPath().startsWith("/") ? UriBuilder.fromUri((URI)new URI(null, null, "/" + toolUri.getPath(), toolUri.getQuery(), toolUri.getFragment())) : UriBuilder.fromUri((URI)toolUri).scheme(null).host(null).userInfo(null).port(-1);
        }
        catch (URISyntaxException ex) {
            logger.debug("The 'custom_tool' parameter was invalid: '{}'. Reverting to default: '{}'", (Object)Arrays.toString(req.getParameterValues(LTI_CUSTOM_TOOL)), (Object)TOOLS_URL);
            builder = UriBuilder.fromPath((String)TOOLS_URL);
        }
        for (String key : req.getParameterMap().keySet()) {
            logger.debug("Found query parameter '{}'", (Object)key);
            if (!key.startsWith(LTI_CUSTOM_PREFIX) || LTI_CUSTOM_TOOL.equals(key)) continue;
            String paramValue = req.getParameter(key);
            String paramName = key.substring(LTI_CUSTOM_PREFIX.length());
            builder.queryParam(paramName, new Object[]{paramValue});
        }
        String localeParamValue = req.getParameter(LOCALE);
        if (StringUtils.isNotBlank((CharSequence)localeParamValue)) {
            builder.queryParam("lng", new Object[]{localeParamValue});
        }
        String redirectUrl = builder.build(new Object[0]).toString();
        resp.setHeader("Set-Cookie", "JSESSIONID=" + session.getId() + ";Path=/");
        if (Boolean.valueOf(StringUtils.trimToEmpty((String)req.getParameter(LTI_CUSTOM_TEST))).booleanValue()) {
            resp.setContentType("text/html");
            resp.getWriter().write("<html><body>Welcome to Opencast LTI; you are going to " + redirectUrl + "<br>");
            resp.getWriter().write("<a href=\"" + redirectUrl + "\">continue...</a></body></html>");
        } else {
            resp.sendRedirect(redirectUrl);
        }
    }

    protected Map<String, String> getLtiValuesAsMap(HttpServletRequest req) {
        HashMap<String, String> ltiValues = new HashMap<String, String>();
        for (String key : LTI_CONSTANTS) {
            String value = StringUtils.trimToNull((String)req.getParameter(key));
            if (value == null) continue;
            ltiValues.put(key, value);
        }
        return ltiValues;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        if (session == null) {
            resp.sendError(404);
        } else {
            HashMap<String, String> ltiAttributes = (HashMap<String, String>)session.getAttribute(SESSION_ATTRIBUTE_KEY);
            if (ltiAttributes == null) {
                ltiAttributes = new HashMap<String, String>();
                ltiAttributes.put(ROLES, "Instructor");
            }
            resp.setContentType("application/json");
            JSONObject.writeJSONString(ltiAttributes, (Writer)resp.getWriter());
        }
    }

    static {
        LTI_CONSTANTS.add(LTI_MESSAGE_TYPE);
        LTI_CONSTANTS.add(LTI_VERSION);
        LTI_CONSTANTS.add(RESOURCE_LINK_ID);
        LTI_CONSTANTS.add(RESOURCE_LINK_TITLE);
        LTI_CONSTANTS.add(RESOURCE_LINK_DESCRIPTION);
        LTI_CONSTANTS.add(USER_ID);
        LTI_CONSTANTS.add(USER_IMAGE);
        LTI_CONSTANTS.add(ROLES);
        LTI_CONSTANTS.add(GIVEN_NAME);
        LTI_CONSTANTS.add(FAMILY_NAME);
        LTI_CONSTANTS.add(FULL_NAME);
        LTI_CONSTANTS.add(EMAIL);
        LTI_CONSTANTS.add(CONTEXT_ID);
        LTI_CONSTANTS.add(CONTEXT_TYPE);
        LTI_CONSTANTS.add(CONTEXT_TITLE);
        LTI_CONSTANTS.add(CONTEXT_LABEL);
        LTI_CONSTANTS.add(LOCALE);
        LTI_CONSTANTS.add(TARGET);
        LTI_CONSTANTS.add(WIDTH);
        LTI_CONSTANTS.add(HEIGHT);
        LTI_CONSTANTS.add(RETURN_URL);
        LTI_CONSTANTS.add(CONSUMER_GUID);
        LTI_CONSTANTS.add(CONSUMER_NAME);
        LTI_CONSTANTS.add(CONSUMER_DESCRIPTION);
        LTI_CONSTANTS.add(CONSUMER_URL);
        LTI_CONSTANTS.add(CONSUMER_CONTACT);
        LTI_CONSTANTS.add(COURSE_OFFERING);
        LTI_CONSTANTS.add(COURSE_SECTION);
    }
}

