/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.lti;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.opencastproject.lti.service.api.LtiFileUpload;
import org.opencastproject.lti.service.api.LtiService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="/lti-service-gui")
@RestService(name="ltirestserviceguiendpoint", title="LTI Service", notes={}, abstractText="Provides operations to LTI clients")
@Component(immediate=true, service={LtiServiceGuiEndpoint.class}, property={"service.description=LTI Service GUI", "opencast.service.type=org.opencastproject.lti.service.remote", "opencast.service.path=/lti-service-gui"})
@JaxrsResource
public class LtiServiceGuiEndpoint {
    private LtiService service;

    @Reference
    public void setService(LtiService service) {
        this.service = service;
    }

    @GET
    @Path(value="/new/metadata")
    @Produces(value={"application/json"})
    public Response getNewEventMetadata() {
        return Response.ok((Object)this.service.getNewEventMetadata(), (String)"application/json").build();
    }

    @GET
    @Path(value="/{eventId}/metadata")
    @Produces(value={"application/json"})
    public Response getEventMetadata(@PathParam(value="eventId") String eventId) {
        try {
            return Response.ok((Object)this.service.getEventMetadata(eventId), (String)"application/json").build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @POST
    @Path(value="/{eventId}/metadata")
    @Produces(value={"application/json"})
    public Response setEventMetadata(@PathParam(value="eventId") String eventId, @FormParam(value="metadataJson") String metadataJson) {
        try {
            this.service.setEventMetadataJson(eventId, metadataJson);
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @POST
    @Path(value="/{eventId}/copy")
    @Produces(value={"application/json"})
    public Response copyEventToSeries(@PathParam(value="eventId") String eventId, @QueryParam(value="target_series") String targetSeries) {
        this.service.copyEventToSeries(eventId, targetSeries);
        return Response.ok().build();
    }

    @GET
    @Path(value="/jobs")
    @Produces(value={"application/json"})
    public Response listJobs(@QueryParam(value="seriesId") String seriesId) {
        List results = this.service.listJobs(seriesId).stream().map(e -> {
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("title", e.getTitle());
            eventMap.put("status", e.getStatus());
            return eventMap;
        }).collect(Collectors.toList());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new Gson().toJson(results, List.class)).build();
    }

    @POST
    @Path(value="/")
    @Consumes(value={"multipart/form-data"})
    @RestQuery(name="uploadevent", description="Creates an event in a multipart request.", returnDescription="", restParameters={@RestParameter(name="presenter", description="Presenter movie track", isRequired=false, type=RestParameter.Type.FILE), @RestParameter(name="license", description="License chosen", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="seriesName", description="Series name", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="isPartOf", description="Series ID", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="processing", description="Processing instructions task configuration", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="A new event is created and its identifier is returned in the Location header.", responseCode=201), @RestResponse(description="The event could not be created due to a scheduling conflict.", responseCode=409), @RestResponse(description="The request is invalid or inconsistent..", responseCode=400)})
    public Response createNewEvent(@HeaderParam(value="Accept") String acceptHeader, @Context HttpServletRequest request) {
        String seriesId = "";
        try {
            String captions = null;
            String captionFormat = null;
            String captionLanguage = null;
            String metadata = null;
            String eventId = null;
            FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                if ("eventId".equals(fieldName)) {
                    eventId = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("captions".equals(fieldName)) {
                    captions = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("captionFormat".equals(fieldName)) {
                    captionFormat = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("captionLanguage".equals(fieldName)) {
                    captionLanguage = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("seriesId".equals(fieldName)) {
                    String fieldValue = Streams.asString((InputStream)item.openStream());
                    if (fieldValue.isEmpty()) continue;
                    seriesId = fieldValue;
                    continue;
                }
                this.service.upsertEvent(new LtiFileUpload(item.openStream(), item.getName()), captions, captionFormat, captionLanguage, eventId, seriesId, metadata);
                return Response.ok().build();
            }
            this.service.upsertEvent(null, captions, captionFormat, captionLanguage, eventId, seriesId, metadata);
            return Response.ok().build();
        }
        catch (IOException | FileUploadException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"error while uploading").build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @DELETE
    @Path(value="{eventId}")
    @RestQuery(name="deleteevent", description="Deletes an event.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The event has been deleted.", responseCode=204), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response deleteEvent(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="eventId") String id) {
        this.service.delete(id);
        return Response.noContent().build();
    }
}

