/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.lti.service.impl;

import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.SimpleSerializer;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.util.Workflows;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.impl.util.EventUtils;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.lti.service.api.LtiFileUpload;
import org.opencastproject.lti.service.api.LtiJob;
import org.opencastproject.lti.service.api.LtiService;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataJson;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowListener;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.WorkflowUtil;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={LtiService.class}, property={"service.description=LTI Service"})
public class LtiServiceImpl
implements LtiService {
    private static final Logger logger = LoggerFactory.getLogger(LtiServiceImpl.class);
    private static final Gson gson = new Gson();
    private static final String NEW_MP_ID_KEY = "newMpId";
    private IndexService indexService;
    private IngestService ingestService;
    private SecurityService securityService;
    private WorkflowService workflowService;
    private AssetManager assetManager;
    private Workspace workspace;
    private ElasticsearchIndex searchIndex;
    private AuthorizationService authorizationService;
    private SeriesService seriesService;
    private String workflow;
    private String workflowConfiguration;
    private String retractWorkflowId;
    private String copyWorkflowId;
    private final List<EventCatalogUIAdapter> catalogUIAdapters = new ArrayList<EventCatalogUIAdapter>();
    private boolean listAllJobsInSeries;

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setSearchIndex(ElasticsearchIndex searchIndex) {
        this.searchIndex = searchIndex;
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    public void setIngestService(IngestService ingestService) {
        this.ingestService = ingestService;
    }

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeCatalogUIAdapter")
    public void addCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        this.catalogUIAdapters.add(catalogUIAdapter);
    }

    public void removeCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        this.catalogUIAdapters.remove(catalogUIAdapter);
    }

    @Activate
    public void activate(ComponentContext cc) {
        this.workflowService.addWorkflowListener(new WorkflowListener(){

            public void stateChanged(WorkflowInstance workflow) {
                if (!workflow.getTemplate().equals(LtiServiceImpl.this.copyWorkflowId)) {
                    return;
                }
                if (workflow.getState().equals((Object)WorkflowInstance.WorkflowState.SUCCEEDED)) {
                    String publishWorkflowName = "publish";
                    logger.info("workflow '{}' succeeded for media package '{}', starting workflow '{}'", new Object[]{workflow.getTemplate(), workflow.getMediaPackage().getIdentifier(), "publish"});
                    try {
                        WorkflowDefinition wfd = LtiServiceImpl.this.workflowService.getWorkflowDefinitionById("publish");
                        Workflows workflows = new Workflows(LtiServiceImpl.this.assetManager, LtiServiceImpl.this.workflowService);
                        ConfiguredWorkflow newWorkflow = ConfiguredWorkflow.workflow((WorkflowDefinition)wfd);
                        String targetMpId = workflow.getConfiguration(LtiServiceImpl.NEW_MP_ID_KEY);
                        List workflowInstances = workflows.applyWorkflowToLatestVersion(Collections.singleton(targetMpId), newWorkflow);
                        if (workflowInstances.isEmpty()) {
                            throw new RuntimeException(String.format("couldn't start workflow '%s' for event %s", "publish", targetMpId));
                        }
                    }
                    catch (WorkflowDatabaseException e) {
                        logger.error(String.format("couldn't instantiate workflow '%s'", "publish"), (Throwable)e);
                    }
                    catch (NotFoundException e) {
                        logger.error(String.format("couldn't find media package while starting workflow workflow '%s'", "publish"), (Throwable)e);
                    }
                }
            }
        });
        this.updated(cc.getProperties());
    }

    @Modified
    public void modified(ComponentContext cc) {
        this.updated(cc.getProperties());
    }

    public List<LtiJob> listJobs(String seriesId) {
        User user = this.securityService.getUser();
        EventSearchQuery query = new EventSearchQuery(this.securityService.getOrganization().getId(), user).withSeriesId(StringUtils.trimToNull((String)seriesId));
        if (!this.listAllJobsInSeries) {
            query.withCreator(user.getName());
        }
        try {
            SearchResult results = this.searchIndex.getByQuery(query);
            ZonedDateTime startOfDay = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
            return Arrays.stream(results.getItems()).map(SearchResultItem::getSource).filter(e -> ZonedDateTime.parse(e.getCreated()).compareTo(startOfDay) > 0).map(e -> new LtiJob(e.getTitle(), e.getDisplayableStatus(this.workflowService.getWorkflowStateMappings()))).collect(Collectors.toList());
        }
        catch (SearchIndexException e2) {
            throw new RuntimeException("search index exception", e2);
        }
    }

    public void upsertEvent(LtiFileUpload file, String captions, String captionFormat, String captionLanguage, String eventId, String seriesId, String metadataJson) throws UnauthorizedException, NotFoundException {
        if (eventId != null) {
            this.updateEvent(eventId, metadataJson);
            return;
        }
        if (this.workflow == null || this.workflowConfiguration == null) {
            throw new RuntimeException("No workflow configured, cannot upload");
        }
        try {
            MediaPackage mediaPackage = this.ingestService.createMediaPackage();
            if (mediaPackage == null) {
                throw new RuntimeException("Unable to create media package for event");
            }
            if (captions != null) {
                MediaPackageElementFlavor captionsFlavor = new MediaPackageElementFlavor("captions", "source");
                MediaPackageElementBuilder elementBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
                MediaPackageElement captionsMediaPackage = elementBuilder.newElement(MediaPackageElement.Type.Track, captionsFlavor);
                if (!"vtt".equals(captionFormat)) {
                    throw new IllegalArgumentException("Subtitle format must be vtt, but was " + captionFormat);
                }
                captionsMediaPackage.setMimeType(MimeType.mimeType((String)"text", (String)captionFormat));
                captionsMediaPackage.addTag("lang:" + captionLanguage);
                mediaPackage.add(captionsMediaPackage);
                URI captionsUri = this.workspace.put(mediaPackage.getIdentifier().toString(), captionsMediaPackage.getIdentifier(), "captions." + captionFormat, (InputStream)new ByteArrayInputStream(captions.getBytes(StandardCharsets.UTF_8)));
                captionsMediaPackage.setURI(captionsUri);
            }
            EventCatalogUIAdapter adapter = this.getEventCatalogUIAdapter();
            DublinCoreMetadataCollection collection = adapter.getRawFields();
            JSONArray metadataJsonArray = (JSONArray)new JSONParser().parse(metadataJson);
            JSONArray collectionJsonArray = MetadataJson.extractSingleCollectionfromListJson((JSONArray)metadataJsonArray);
            MetadataJson.fillCollectionFromJson((DublinCoreMetadataCollection)collection, (Object)collectionJsonArray);
            this.replaceField(collection, "isPartOf", seriesId);
            adapter.storeFields(mediaPackage, collection);
            AccessControlList accessControlList = null;
            if (StringUtils.isNotBlank((CharSequence)seriesId)) {
                accessControlList = this.seriesService.getSeriesAccessControl(seriesId);
            }
            if (accessControlList == null || accessControlList.getEntries().isEmpty()) {
                accessControlList = new AccessControlList(new AccessControlEntry[]{new AccessControlEntry("ROLE_ADMIN", "write", true), new AccessControlEntry("ROLE_ADMIN", "read", true), new AccessControlEntry("ROLE_USER", "read", true)});
            }
            this.authorizationService.setAcl(mediaPackage, AclScope.Episode, accessControlList);
            mediaPackage = this.ingestService.addTrack(file.getStream(), file.getSourceName(), MediaPackageElements.PRESENTER_SOURCE, mediaPackage);
            Map configuration = (Map)gson.fromJson(this.workflowConfiguration, Map.class);
            configuration.put("workflowDefinitionId", this.workflow);
            this.ingestService.ingest(mediaPackage, this.workflow, configuration);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to create event", e);
        }
    }

    private static Map<String, String> createCopyWorkflowConfig(String seriesId, String newMpId) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("numberOfEvents", "1");
        result.put("noSuffix", "true");
        result.put("setSeriesId", seriesId);
        result.put(NEW_MP_ID_KEY, newMpId);
        return result;
    }

    public void copyEventToSeries(String eventId, String seriesId) {
        String workflowId = this.copyWorkflowId;
        try {
            WorkflowDefinition wfd = this.workflowService.getWorkflowDefinitionById(workflowId);
            Workflows workflows = new Workflows(this.assetManager, this.workflowService);
            ConfiguredWorkflow workflow = ConfiguredWorkflow.workflow((WorkflowDefinition)wfd, LtiServiceImpl.createCopyWorkflowConfig(seriesId, UUID.randomUUID().toString()));
            List workflowInstances = workflows.applyWorkflowToLatestVersion(Collections.singleton(eventId), workflow);
            if (workflowInstances.isEmpty()) {
                throw new RuntimeException(String.format("Couldn't start workflow '%s' for event %s", workflowId, eventId));
            }
        }
        catch (NotFoundException | WorkflowDatabaseException e) {
            logger.error("Unable to get workflow definition {}", (Object)workflowId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private EventCatalogUIAdapter getEventCatalogUIAdapter() {
        MediaPackageElementFlavor flavor = new MediaPackageElementFlavor("dublincore", "episode");
        EventCatalogUIAdapter adapter = this.catalogUIAdapters.stream().filter(e -> e.getFlavor().equals((Object)flavor)).findAny().orElseThrow(() -> new RuntimeException("no adapter found"));
        return adapter;
    }

    private void updateEvent(String eventId, String metadata) throws NotFoundException, UnauthorizedException {
        EventCatalogUIAdapter adapter = this.getEventCatalogUIAdapter();
        DublinCoreMetadataCollection collection = adapter.getRawFields();
        try {
            MetadataList metadataList = new MetadataList();
            metadataList.add(adapter, collection);
            MetadataJson.fillListFromJson((MetadataList)metadataList, (JSONArray)((JSONArray)new JSONParser().parse(metadata)));
            this.indexService.updateEventMetadata(eventId, metadataList, this.searchIndex);
            this.republishMetadata(eventId);
        }
        catch (ParseException | SearchIndexException | IndexServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private void republishMetadata(String eventId) {
        String workflowId = "republish-metadata";
        try {
            WorkflowDefinition wfd = this.workflowService.getWorkflowDefinitionById("republish-metadata");
            Workflows workflows = new Workflows(this.assetManager, this.workflowService);
            ConfiguredWorkflow workflow = ConfiguredWorkflow.workflow((WorkflowDefinition)wfd, Collections.emptyMap());
            if (workflows.applyWorkflowToLatestVersion(Collections.singleton(eventId), workflow).isEmpty()) {
                throw new RuntimeException(String.format("couldn't start workflow '%s' for event %s", "republish-metadata", eventId));
            }
        }
        catch (NotFoundException | WorkflowDatabaseException e) {
            logger.error("Unable to get workflow definition {}", (Object)"republish-metadata", (Object)e);
            throw new RuntimeException(e);
        }
    }

    public String getEventMetadata(String eventId) throws NotFoundException, UnauthorizedException {
        DublinCoreMetadataCollection metadataCollection;
        MediaPackage mediaPackage;
        Opt optEvent;
        try {
            optEvent = this.indexService.getEvent(eventId, this.searchIndex);
        }
        catch (SearchIndexException e) {
            throw new RuntimeException(e);
        }
        if (optEvent.isNone()) {
            throw new NotFoundException("cannot find event with id '" + eventId + "'");
        }
        Event event = (Event)optEvent.get();
        MetadataList metadataList = new MetadataList();
        List catalogUIAdapters = this.indexService.getEventCatalogUIAdapters();
        catalogUIAdapters.remove(this.indexService.getCommonEventCatalogUIAdapter());
        try {
            mediaPackage = this.indexService.getEventMediapackage(event);
        }
        catch (IndexServiceException e) {
            if (e.getCause() instanceof NotFoundException) {
                throw new NotFoundException("Cannot retrieve metadata for event with id '" + eventId + "'");
            }
            if (e.getCause() instanceof UnauthorizedException) {
                throw new UnauthorizedException("Not authorized to access event with id '" + eventId + "'");
            }
            throw new RuntimeException(e);
        }
        for (EventCatalogUIAdapter catalogUIAdapter : catalogUIAdapters) {
            metadataList.add(catalogUIAdapter, catalogUIAdapter.getFields(mediaPackage));
        }
        try {
            metadataCollection = EventUtils.getEventMetadata((Event)event, (EventCatalogUIAdapter)this.indexService.getCommonEventCatalogUIAdapter());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        metadataList.add(this.indexService.getCommonEventCatalogUIAdapter(), metadataCollection);
        String wfState = event.getWorkflowState();
        if (wfState != null && WorkflowUtil.isActive((WorkflowInstance.WorkflowState)WorkflowInstance.WorkflowState.valueOf((String)wfState))) {
            metadataList.setLocked(MetadataList.Locked.WORKFLOW_RUNNING);
        }
        return new SimpleSerializer().toJson(MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
    }

    public String getNewEventMetadata() {
        MetadataList metadataList = this.indexService.getMetadataListWithAllEventCatalogUIAdapters();
        DublinCoreMetadataCollection collection = metadataList.getMetadataByAdapter(this.indexService.getCommonEventCatalogUIAdapter());
        if (collection != null) {
            if (collection.getOutputFields().containsKey(DublinCore.PROPERTY_CREATED.getLocalName())) {
                collection.removeField((MetadataField)collection.getOutputFields().get(DublinCore.PROPERTY_CREATED.getLocalName()));
            }
            if (collection.getOutputFields().containsKey("duration")) {
                collection.removeField((MetadataField)collection.getOutputFields().get("duration"));
            }
            if (collection.getOutputFields().containsKey(DublinCore.PROPERTY_IDENTIFIER.getLocalName())) {
                collection.removeField((MetadataField)collection.getOutputFields().get(DublinCore.PROPERTY_IDENTIFIER.getLocalName()));
            }
            if (collection.getOutputFields().containsKey(DublinCore.PROPERTY_SOURCE.getLocalName())) {
                collection.removeField((MetadataField)collection.getOutputFields().get(DublinCore.PROPERTY_SOURCE.getLocalName()));
            }
            if (collection.getOutputFields().containsKey("startDate")) {
                collection.removeField((MetadataField)collection.getOutputFields().get("startDate"));
            }
            if (collection.getOutputFields().containsKey("startTime")) {
                collection.removeField((MetadataField)collection.getOutputFields().get("startTime"));
            }
            if (collection.getOutputFields().containsKey("location")) {
                collection.removeField((MetadataField)collection.getOutputFields().get("location"));
            }
            if (collection.getOutputFields().containsKey(DublinCore.PROPERTY_PUBLISHER.getLocalName())) {
                String loggedInUser;
                MetadataField publisher = (MetadataField)collection.getOutputFields().get(DublinCore.PROPERTY_PUBLISHER.getLocalName());
                Map users = publisher.getCollection() == null ? new HashMap() : publisher.getCollection();
                if (!users.containsKey(loggedInUser = this.securityService.getUser().getName())) {
                    users.put(loggedInUser, loggedInUser);
                }
                publisher.setValue((Object)loggedInUser);
            }
            metadataList.add(this.indexService.getCommonEventCatalogUIAdapter(), collection);
        }
        return new SimpleSerializer().toJson(MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
    }

    public void setEventMetadataJson(String eventId, String metadataJson) throws NotFoundException, UnauthorizedException {
        try {
            this.indexService.updateAllEventMetadata(eventId, metadataJson, this.searchIndex);
        }
        catch (SearchIndexException | IndexServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private void replaceField(DublinCoreMetadataCollection collection, String fieldName, String fieldValue) {
        MetadataField field = (MetadataField)collection.getOutputFields().get(fieldName);
        collection.removeField(field);
        collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)fieldValue));
    }

    public void delete(String id) {
        try {
            Opt event = this.indexService.getEvent(id, this.searchIndex);
            if (event.isNone()) {
                throw new RuntimeException("Event '" + id + "' not found");
            }
            IndexService.EventRemovalResult eventRemovalResult = this.indexService.removeEvent((Event)event.get(), this.retractWorkflowId);
            if (eventRemovalResult == IndexService.EventRemovalResult.GENERAL_FAILURE) {
                throw new RuntimeException("Error deleting event: " + String.valueOf(eventRemovalResult));
            }
        }
        catch (SearchIndexException | UnauthorizedException | NotFoundException | WorkflowDatabaseException e) {
            throw new RuntimeException("Error deleting event", e);
        }
    }

    private void updated(Dictionary<String, ?> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("No configuration specified for events endpoint");
        }
        String workflowStr = (String)properties.get("workflow");
        if (workflowStr == null) {
            throw new IllegalArgumentException("Configuration is missing 'workflow' parameter");
        }
        String workflowConfigurationStr = (String)properties.get("workflow-configuration");
        if (workflowConfigurationStr == null) {
            throw new IllegalArgumentException("Configuration is missing 'workflow-configuration' parameter");
        }
        try {
            gson.fromJson(workflowConfigurationStr, Map.class);
            this.workflowConfiguration = workflowConfigurationStr;
            this.workflow = workflowStr;
            this.retractWorkflowId = Objects.toString(properties.get("retract-workflow-id"), "retract");
            this.copyWorkflowId = Objects.toString(properties.get("copy-workflow-id"), "copy-event-to-series");
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("Invalid JSON specified for workflow configuration");
        }
        String listAllJobsInSeriesStr = Objects.toString(properties.get("list-all-jobs-in-series"), "false");
        this.listAllJobsInSeries = Boolean.parseBoolean(listAllJobsInSeriesStr);
    }
}

