/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.lti.service.endpoint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.opencastproject.lti.service.api.LtiFileUpload;
import org.opencastproject.lti.service.api.LtiJob;
import org.opencastproject.lti.service.api.LtiService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Path(value="/")
@RestService(name="ltirestservice", title="LTI Service", notes={}, abstractText="Provides operations to LTI clients")
@Component(immediate=true, service={LtiServiceRestEndpoint.class}, property={"service.description=LTI Service", "opencast.service.type=org.opencastproject.lti.service", "opencast.service.path=/lti-service"})
public class LtiServiceRestEndpoint {
    private static final Gson gson = new Gson();
    private LtiService service;

    @Reference
    public void setService(LtiService service) {
        this.service = service;
    }

    @GET
    @Path(value="/jobs")
    @Produces(value={"application/json"})
    @RestQuery(name="listjobs", description="List recent jobs for a specific series.", returnDescription="", restParameters={@RestParameter(name="seriesId", description="The id of the series you want jobs for", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The list of jobs", responseCode=200)})
    public Response listJobs(@QueryParam(value="seriesId") String seriesId) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)gson.toJson((Object)this.service.listJobs(seriesId), new TypeToken<List<LtiJob>>(){}.getType())).build();
    }

    @POST
    @Path(value="/")
    @Consumes(value={"multipart/form-data"})
    @RestQuery(name="createevent", description="Creates an event by sending metadata in a multipart request.", returnDescription="", restParameters={@RestParameter(name="metadata", description="Event metadata", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="presenter", description="Presenter movie track", isRequired=true, type=RestParameter.Type.FILE), @RestParameter(name="captions", description="Caption file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="captionFormat", description="Caption file format", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="captionLanguage", description="Caption language", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="isPartOf", description="Series id of the event", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="eventId", description="ID of the event to update (if it's an update)", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="A new event is created or the event is updated", responseCode=200), @RestResponse(description="No authorization to create or update events", responseCode=401), @RestResponse(description="The event to be updated wasn't found", responseCode=404)})
    public Response createNewEvent(@HeaderParam(value="Accept") String acceptHeader, @Context HttpServletRequest request) {
        String seriesId = "";
        try {
            String captions = null;
            String captionFormat = null;
            String captionLanguage = null;
            String eventId = null;
            String metadataJson = null;
            FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                if ("isPartOf".equals(fieldName)) {
                    String fieldValue = Streams.asString((InputStream)item.openStream());
                    if (fieldValue.isEmpty()) continue;
                    seriesId = fieldValue;
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadataJson = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("captions".equals(fieldName)) {
                    captions = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("captionFormat".equals(fieldName)) {
                    captionFormat = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("captionLanguage".equals(fieldName)) {
                    captionLanguage = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                if ("eventId".equals(fieldName)) {
                    eventId = Streams.asString((InputStream)item.openStream());
                    continue;
                }
                InputStream stream = item.openStream();
                String streamName = item.getName();
                this.service.upsertEvent(new LtiFileUpload(stream, streamName), captions, captionFormat, captionLanguage, eventId, seriesId, metadataJson);
                return Response.ok().build();
            }
            if (eventId == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No file given").build();
            }
            this.service.upsertEvent(null, captions, captionFormat, captionLanguage, eventId, seriesId, metadataJson);
            return Response.ok().build();
        }
        catch (IOException | FileUploadException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"error while uploading").build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @POST
    @Path(value="{eventId}/copy")
    @RestQuery(name="copyeventtoseries", description="Copy an event to a different series", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event (id) to copy", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="seriesId", description="The series (id) to copy into", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The event has been copied.", responseCode=204), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response copyEventToSeries(@PathParam(value="eventId") String eventId, @QueryParam(value="seriesId") String seriesId) {
        this.service.copyEventToSeries(eventId, seriesId);
        return Response.noContent().build();
    }

    @POST
    @Path(value="{eventId}/metadata")
    @Produces(value={"application/json"})
    @RestQuery(name="seteventmetadata", description="Set the metadata of an existing event", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="metadataJson", description="Event metadata", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The event's metadata has been set", responseCode=200), @RestResponse(description="The event doesn't exist", responseCode=404), @RestResponse(description="The event cannot be accessed", responseCode=401)})
    public Response setEventMetadataJson(@PathParam(value="eventId") String eventId, @FormParam(value="metadataJson") String metadataJson) {
        try {
            this.service.setEventMetadataJson(eventId, metadataJson);
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @GET
    @Path(value="new/metadata")
    @Produces(value={"application/json"})
    @RestQuery(name="getneweventmetadata", description="Get the metadata of a new event", returnDescription="The metadata of a new event", responses={@RestResponse(description="A new event's metadata", responseCode=200)})
    public Response getNewEventMetadata() {
        return Response.ok((Object)this.service.getNewEventMetadata(), (String)"application/json").build();
    }

    @GET
    @Path(value="{eventId}/metadata")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventmetadata", description="Get the metadata of an existing event", returnDescription="The metadata of an existing event", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Metadata is available and will be returned", responseCode=200), @RestResponse(description="The event doesn't exist", responseCode=404), @RestResponse(description="The event cannot be accessed", responseCode=401)})
    public Response getEventMetadata(@PathParam(value="eventId") String eventId) {
        try {
            return Response.ok((Object)this.service.getEventMetadata(eventId), (String)"application/json").build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @DELETE
    @Path(value="{eventId}")
    @RestQuery(name="deleteevent", description="Deletes an event.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The event has been deleted.", responseCode=204), @RestResponse(description="The specified event does not exist.", responseCode=404)})
    public Response deleteEvent(@PathParam(value="eventId") String id) {
        this.service.delete(id);
        return Response.noContent().build();
    }
}

