/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.logging;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.XmlWorkflowParser;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Logging Workflow Operation Handler", "workflow.operation=log"}, immediate=true, service={WorkflowOperationHandler.class})
public class LoggingWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoggingWorkflowOperationHandler.class);

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        String filename;
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String directoryPath = StringUtils.trimToNull((String)operation.getConfiguration("directory"));
        File directory = null;
        if (directoryPath != null) {
            directory = new File(directoryPath);
            try {
                FileUtils.forceMkdir((File)directory);
            }
            catch (IOException e) {
                throw new WorkflowOperationException(String.format("Failed to create output directory '%s'", directoryPath), (Throwable)e);
            }
        }
        boolean logMediaPackageJSON = BooleanUtils.toBoolean((String)operation.getConfiguration("mediapackage-json"));
        boolean logMediaPackageXML = BooleanUtils.toBoolean((String)operation.getConfiguration("mediapackage-xml"));
        boolean logWorkflowInstance = BooleanUtils.toBoolean((String)operation.getConfiguration("workflowinstance-xml"));
        if (!(logMediaPackageJSON || logMediaPackageXML || logWorkflowInstance)) {
            logMediaPackageJSON = true;
        }
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        if (logMediaPackageJSON) {
            filename = String.format("workflow-%d-%d-mediapackage-%s.json", workflowInstance.getId(), operation.getId(), mediaPackage.getIdentifier());
            this.saveOrLog(MediaPackageParser.getAsJSON((MediaPackage)mediaPackage), directory, filename);
        }
        if (logMediaPackageXML) {
            filename = String.format("workflow-%d-%d-mediapackage-%s.xml", workflowInstance.getId(), operation.getId(), mediaPackage.getIdentifier());
            this.saveOrLog(MediaPackageParser.getAsXml((MediaPackage)mediaPackage), directory, filename);
        }
        if (logWorkflowInstance) {
            filename = String.format("workflow-%d-%d.xml", workflowInstance.getId(), operation.getId());
            try {
                this.saveOrLog(XmlWorkflowParser.toXml((WorkflowInstance)workflowInstance), directory, filename);
            }
            catch (WorkflowParsingException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private void saveOrLog(String data, File directory, String filename) throws WorkflowOperationException {
        if (directory != null) {
            File file = new File(directory, filename);
            try {
                logger.info("Logging current workflow state to to {}", (Object)file.getAbsolutePath());
                FileUtils.writeStringToFile((File)file, (String)data, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
        } else {
            logger.info("({}):\n{}", (Object)filename, (Object)data);
        }
    }
}

