/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.codec.Hex;

public final class SystemTokenRememberMeUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemTokenRememberMeUtils.class);
    private static final String DEFAULT_COOKIE_KEY = "opencast";

    private SystemTokenRememberMeUtils() {
    }

    public static String augmentKey(String key) {
        if (!DEFAULT_COOKIE_KEY.equals(key)) {
            logger.debug("The default cookie key '{}' is not in use. The given key won't be augmented.", (Object)DEFAULT_COOKIE_KEY);
            return key;
        }
        StringBuilder keyBuilder = new StringBuilder(Objects.toString(key, ""));
        try {
            keyBuilder.append(InetAddress.getLocalHost());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        for (String procFile : Arrays.asList("/proc/version", "/proc/partitions")) {
            try (FileInputStream fileInputStream = new FileInputStream(new File(procFile));){
                keyBuilder.append(IOUtils.toString((InputStream)fileInputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {}
        }
        key = keyBuilder.toString();
        if (key.isEmpty()) {
            logger.warn("Could not generate semi-persistent remember-me key. Will generate a non-persistent random one.");
            key = Double.toString(Math.random());
        }
        logger.debug("Remember me key before hashing: {}", (Object)key);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            key = new String(Hex.encode((byte[])digest.digest(key.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("No SHA-512 algorithm available!");
        }
        logger.debug("Calculated remember me key: {}", (Object)key);
        return key;
    }
}

