/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.opencastproject.kernel.security.SecurityFilter;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

@Component(immediate=true, service={ArtifactInstaller.class}, property={"service.description=Security Configuration Scanner"})
public class SpringSecurityConfigurationArtifactInstaller
implements ArtifactInstaller {
    protected static final Logger logger = LoggerFactory.getLogger(SpringSecurityConfigurationArtifactInstaller.class);
    protected BundleContext bundleContext = null;
    protected SecurityFilter securityFilter = null;
    protected Map<String, OsgiBundleXmlApplicationContext> appContexts = null;

    @Reference
    public void setSecurityFilter(SecurityFilter securityFilter) {
        this.securityFilter = securityFilter;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.bundleContext = cc.getBundleContext();
        this.appContexts = new HashMap<String, OsgiBundleXmlApplicationContext>();
    }

    public boolean canHandle(File artifact) {
        return "security".equals(artifact.getParentFile().getName()) && artifact.getName().endsWith(".xml");
    }

    public void install(File artifact) throws Exception {
        String orgId = FilenameUtils.getBaseName((String)artifact.getName());
        OsgiBundleXmlApplicationContext orgAppContext = this.appContexts.get(orgId);
        if (orgAppContext != null) {
            this.securityFilter.removeFilter(orgId);
            orgAppContext.close();
        }
        OsgiBundleXmlApplicationContext springContext = new OsgiBundleXmlApplicationContext(new String[]{"file:" + artifact.getAbsolutePath()});
        springContext.setBundleContext(this.bundleContext);
        logger.info("registered {} for {}", (Object)springContext, (Object)orgId);
        try {
            springContext.refresh();
        }
        catch (Exception e) {
            logger.error("Unable to refresh spring security configuration file {}", (Object)artifact, (Object)e);
            return;
        }
        this.appContexts.put(orgId, springContext);
        this.securityFilter.addFilter(orgId, (Filter)springContext.getBean("springSecurityFilterChain"));
    }

    public void uninstall(File artifact) throws Exception {
        String orgId = FilenameUtils.getBaseName((String)artifact.getName());
        OsgiBundleXmlApplicationContext appContext = this.appContexts.get(orgId);
        if (appContext != null) {
            this.securityFilter.removeFilter(orgId);
            this.appContexts.remove(orgId);
            appContext.close();
        }
    }

    public void update(File artifact) throws Exception {
        this.install(artifact);
    }
}

