/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class, SecurityFilter.class}, property={"service.description=Security Filter"})
@ServiceRanking(value=970)
@HttpWhiteboardFilterName(value="SecurityFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public final class SecurityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecurityFilter.class);
    private final Map<String, Filter> orgSecurityFilters = new HashMap<String, Filter>();
    protected FilterConfig filterConfig;
    private SecurityService securityService;

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
    }

    public void addFilter(String orgId, Filter filter) {
        this.removeFilter(orgId);
        try {
            filter.init(this.filterConfig);
            this.orgSecurityFilters.put(orgId, filter);
        }
        catch (ServletException e) {
            logger.error("Unable to initialize {}", (Object)filter);
        }
    }

    public void removeFilter(String orgId) {
        Filter filter = this.orgSecurityFilters.remove(orgId);
        if (filter != null) {
            filter.destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Organization org = this.securityService.getOrganization();
        if (org == null) {
            ((HttpServletResponse)response).sendError(404);
            return;
        }
        Filter filter = this.orgSecurityFilters.get(org.getId());
        if (filter == null) {
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        filter.doFilter(request, response, chain);
    }
}

