/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.kernel.security.OrganizationFilter;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityConstants;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, scope=ServiceScope.PROTOTYPE, property={"service.description=Remote User and Organization Filter"})
@ServiceRanking(value=8)
@HttpWhiteboardFilterName(value="RemoteUserAndOrganizationFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class RemoteUserAndOrganizationFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationFilter.class);
    protected SecurityService securityService = null;
    protected OrganizationDirectoryService organizationDirectory = null;
    protected UserDirectoryService userDirectory = null;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Organization originalOrganization = this.securityService.getOrganization();
        User originalUser = this.securityService.getUser();
        Organization requestedOrganization = originalOrganization;
        User requestedUser = originalUser;
        try {
            String rolesHeader;
            String organizationHeader = httpRequest.getHeader("X-Opencast-Matterhorn-Organization");
            if (StringUtils.isNotBlank((CharSequence)organizationHeader)) {
                if (!originalUser.hasRole("ROLE_ADMIN")) {
                    logger.warn("An unauthorized request is trying to switch from organization '{}' to '{}'", (Object)originalOrganization.getId(), (Object)organizationHeader);
                    ((HttpServletResponse)response).sendError(403);
                    return;
                }
                try {
                    requestedOrganization = this.organizationDirectory.getOrganization(organizationHeader);
                    this.securityService.setOrganization(requestedOrganization);
                    logger.trace("Switching to organization '{}' from request header {}", (Object)requestedOrganization.getId(), (Object)"X-Opencast-Matterhorn-Organization");
                }
                catch (NotFoundException e) {
                    logger.warn("Non-existing organization '{}' specified in request header {}", (Object)organizationHeader, (Object)"X-Opencast-Matterhorn-Organization");
                    ((HttpServletResponse)response).sendError(403);
                    this.securityService.setOrganization(originalOrganization);
                    this.securityService.setUser(originalUser);
                    return;
                }
            } else {
                logger.trace("Request organization remains '{}'", (Object)originalOrganization.getId());
            }
            String userHeader = httpRequest.getHeader("X-Opencast-Matterhorn-User");
            if (StringUtils.isBlank((CharSequence)userHeader)) {
                userHeader = httpRequest.getHeader("X-RUN-AS-USER");
            }
            if (StringUtils.isNotBlank((CharSequence)userHeader)) {
                if (!originalUser.hasRole("ROLE_SUDO")) {
                    logger.warn("An unauthorized request is trying to switch from user '{}' to '{}'", (Object)originalUser.getUsername(), (Object)userHeader);
                    ((HttpServletResponse)response).sendError(403);
                    return;
                }
                if ("anonymous".equals(userHeader)) {
                    requestedUser = SecurityUtil.createAnonymousUser((Organization)requestedOrganization);
                    logger.trace("Request user is switched to '{}'", (Object)requestedUser.getUsername());
                } else {
                    requestedUser = this.userDirectory.loadUser(userHeader);
                    if (requestedUser == null) {
                        logger.warn("Unable to switch to non-existing user '{}' as specified in request header {}", (Object)userHeader, (Object)"X-Opencast-Matterhorn-User");
                        ((HttpServletResponse)response).sendError(403);
                        return;
                    }
                    if (!originalUser.hasRole("ROLE_ADMIN")) {
                        for (String systemRole : SecurityConstants.GLOBAL_SYSTEM_ROLES) {
                            if (!requestedUser.hasRole(systemRole)) continue;
                            logger.warn("An unauthorized request is trying to switch to an admin user, from '{}' to '{}'", (Object)originalUser.getUsername(), (Object)userHeader);
                            ((HttpServletResponse)response).sendError(403);
                            return;
                        }
                        String organizationAdminRole = requestedOrganization.getAdminRole();
                        if (!originalUser.hasRole(organizationAdminRole) && requestedUser.hasRole(organizationAdminRole)) {
                            logger.warn("An unauthorized request is trying to switch to an admin user, from '{}' to '{}'", (Object)originalUser.getUsername(), (Object)userHeader);
                            ((HttpServletResponse)response).sendError(403);
                            return;
                        }
                    }
                }
                logger.trace("Switching from user '{}' to user '{}' from request header '{}'", new Object[]{originalUser.getUsername(), requestedUser.getUsername(), "X-Opencast-Matterhorn-User"});
                this.securityService.setUser(requestedUser);
            }
            if (StringUtils.isBlank((CharSequence)(rolesHeader = httpRequest.getHeader("X-Opencast-Matterhorn-Roles")))) {
                rolesHeader = httpRequest.getHeader("X-RUN-WITH-ROLES");
            }
            if (StringUtils.isNotBlank((CharSequence)rolesHeader)) {
                if (!originalUser.hasRole("ROLE_SUDO")) {
                    logger.warn("An unauthorized request is trying to switch roles from '{}' to '{}'", (Object)requestedUser.getRoles(), (Object)rolesHeader);
                    ((HttpServletResponse)response).sendError(403);
                    return;
                }
                List<String> requestedRoles = Arrays.asList(StringUtils.split((String)rolesHeader, (String)","));
                if (!originalUser.hasRole("ROLE_ADMIN")) {
                    for (String systemRole : SecurityConstants.GLOBAL_SYSTEM_ROLES) {
                        if (!requestedRoles.contains(systemRole)) continue;
                        logger.warn("An unauthorized request by user '{}' is trying to gain admin role '{}'", (Object)originalUser.getUsername(), (Object)systemRole);
                        ((HttpServletResponse)response).sendError(403);
                        return;
                    }
                    String organizationAdminRole = requestedOrganization.getAdminRole();
                    if (!originalUser.hasRole(organizationAdminRole) && requestedRoles.contains(organizationAdminRole)) {
                        logger.warn("An unauthorized request by user '{}' is trying to gain admin role '{}'", (Object)originalUser.getUsername(), (Object)organizationAdminRole);
                        ((HttpServletResponse)response).sendError(403);
                        return;
                    }
                }
                if (StringUtils.isBlank((CharSequence)userHeader)) {
                    requestedUser = SecurityUtil.createAnonymousUser((Organization)requestedOrganization);
                }
                HashSet<JaxbRole> jaxbRoles = new HashSet<JaxbRole>();
                for (String role : requestedRoles) {
                    jaxbRoles.add(RemoteUserAndOrganizationFilter.toJaxbRole(role, requestedOrganization));
                }
                requestedUser = new JaxbUser(requestedUser.getUsername(), requestedUser.getPassword(), requestedUser.getName(), requestedUser.getEmail(), requestedUser.getProvider(), JaxbOrganization.fromOrganization((Organization)requestedUser.getOrganization()), jaxbRoles);
                logger.trace("Request roles '{}' are amended to user '{}'", (Object)rolesHeader, (Object)requestedUser.getUsername());
                this.securityService.setUser(requestedUser);
            }
            logger.trace("Executing the filter chain with user '{}@{}'", (Object)requestedUser.getUsername(), (Object)requestedOrganization.getId());
            chain.doFilter((ServletRequest)httpRequest, response);
        }
        finally {
            this.securityService.setOrganization(originalOrganization);
            this.securityService.setUser(originalUser);
        }
    }

    public void destroy() {
    }

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectory = organizationDirectory;
    }

    @Reference
    void setUserDirectoryService(UserDirectoryService userDirectory) {
        this.userDirectory = userDirectory;
    }

    private static JaxbRole toJaxbRole(String role, Organization organization) {
        return new JaxbRole(role, JaxbOrganization.fromOrganization((Organization)organization));
    }
}

