/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbOrganizationList;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="/org")
@RestService(name="organization", title="Organizations", notes={""}, abstractText="Displays the organizations served by this system")
@Component(property={"service.description=Organization listing REST endpoint", "opencast.service.type=org.opencastproject.organization", "opencast.service.path=/org", "opencast.service.jobproducer=false"}, immediate=true, service={OrganizationEndpoint.class})
@JaxrsResource
public class OrganizationEndpoint {
    protected OrganizationDirectoryService orgDirectoryService = null;

    @GET
    @Path(value="all.xml")
    @Produces(value={"text/xml"})
    @RestQuery(name="orgsasxml", description="Lists the organizations as xml", returnDescription="The list of org as xml", responses={@RestResponse(responseCode=200, description="Organizations returned")})
    public JaxbOrganizationList getOrganizationsAsXml() {
        JaxbOrganizationList organizationList = new JaxbOrganizationList();
        for (Organization org : this.orgDirectoryService.getOrganizations()) {
            organizationList.add(org);
        }
        return organizationList;
    }

    @GET
    @Path(value="all.json")
    @Produces(value={"application/json"})
    @RestQuery(name="orgsasjson", description="Lists the organizations as a json array", returnDescription="The list of org as a json array", responses={@RestResponse(responseCode=200, description="Organizations returned")})
    public JaxbOrganizationList getOrganizationsAsJson() {
        return this.getOrganizationsAsXml();
    }

    @GET
    @Path(value="{id}.xml")
    @Produces(value={"text/xml"})
    @RestQuery(name="orgasxml", description="Gets an organizations as xml", returnDescription="The org as xml", pathParameters={@RestParameter(name="id", type=RestParameter.Type.STRING, description="The job identifier", isRequired=true)}, responses={@RestResponse(responseCode=200, description="Organization returned"), @RestResponse(responseCode=404, description="No organization with this identifier found")})
    public JaxbOrganization getOrganizationAsXml(@PathParam(value="id") String id) {
        try {
            return JaxbOrganization.fromOrganization((Organization)this.orgDirectoryService.getOrganization(id));
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="{id}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="orgasjson", description="Gets an organizations as json", returnDescription="The org as json", pathParameters={@RestParameter(name="id", type=RestParameter.Type.STRING, description="The job identifier", isRequired=true)}, responses={@RestResponse(responseCode=200, description="Organization returned"), @RestResponse(responseCode=404, description="No organization with this identifier found")})
    public JaxbOrganization getOrganizationAsJson(@PathParam(value="id") String id) {
        return this.getOrganizationAsXml(id);
    }

    @Reference
    public void setOrgDirectoryService(OrganizationDirectoryService orgDirectoryService) {
        this.orgDirectoryService = orgDirectoryService;
    }
}

