/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.mail;

import java.util.Date;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSmtpService {
    private static final Logger logger = LoggerFactory.getLogger(BaseSmtpService.class);
    protected static final String OPT_MAIL_PREFIX = "mail.";
    protected static final String OPT_MAIL_TRANSPORT = "mail.transport.protocol";
    protected static final String OPT_MAIL_HOST_SUFFIX = ".host";
    protected static final String OPT_MAIL_PORT_SUFFIX = ".port";
    protected static final String OPT_MAIL_TLS_ENABLE_SUFFIX = ".starttls.enable";
    protected static final String OPT_MAIL_AUTH_SUFFIX = ".auth";
    protected static final String OPT_MAIL_USER = "mail.user";
    protected static final String OPT_MAIL_PASSWORD = "mail.password";
    protected static final String OPT_MAIL_FROM = "mail.from";
    protected static final String OPT_MAIL_DEBUG = "mail.debug";
    private static final String DEFAULT_MAIL_TRANSPORT = "smtp";
    private static final int DEFAULT_MAIL_PORT = 25;
    protected String mailTransport = "smtp";
    private boolean productionMode = true;
    private String host = null;
    private int port = 25;
    private String user = null;
    private String password = null;
    private boolean debug = false;
    private boolean ssl = false;
    private String sender = null;
    private Properties mailProperties = new Properties();
    private Session defaultMailSession = null;

    public void setProductionMode(boolean mode) {
        this.productionMode = mode;
    }

    public boolean isProductionMode() {
        return this.productionMode;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setMailTransport(String mailTransport) {
        this.mailTransport = mailTransport;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void configure() {
        this.mailProperties.clear();
        this.defaultMailSession = null;
        if (!DEFAULT_MAIL_TRANSPORT.equals(this.mailTransport) && !"smtps".equals(this.mailTransport)) {
            if (this.mailTransport != null) {
                logger.warn("'{}' procotol not supported. Reverting to default: '{}'", (Object)this.mailTransport, (Object)DEFAULT_MAIL_TRANSPORT);
            }
            logger.debug("Mail transport protocol defaults to '{}'", (Object)DEFAULT_MAIL_TRANSPORT);
            this.mailProperties.put(OPT_MAIL_TRANSPORT, DEFAULT_MAIL_TRANSPORT);
        } else {
            logger.debug("Mail transport protocol is '{}'", (Object)this.mailTransport);
            this.mailProperties.put(OPT_MAIL_TRANSPORT, this.mailTransport);
        }
        this.mailProperties.put(OPT_MAIL_PREFIX + this.mailTransport + OPT_MAIL_HOST_SUFFIX, this.host);
        logger.debug("Mail host is {}", (Object)this.host);
        this.mailProperties.put(OPT_MAIL_PREFIX + this.mailTransport + OPT_MAIL_PORT_SUFFIX, (Object)this.port);
        logger.debug("Mail server port is '{}'", (Object)this.port);
        String propName = OPT_MAIL_PREFIX + this.mailTransport + OPT_MAIL_AUTH_SUFFIX;
        if (StringUtils.isNotBlank((CharSequence)this.user)) {
            this.mailProperties.put(OPT_MAIL_USER, this.user);
            this.mailProperties.put(propName, Boolean.toString(true));
            logger.debug("Mail user is '{}'", (Object)this.user);
        } else {
            this.mailProperties.put(propName, Boolean.toString(false));
            logger.debug("Sending mails to {} without authentication", (Object)this.host);
        }
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            this.mailProperties.put(OPT_MAIL_PASSWORD, this.password);
            logger.debug("Mail password set");
        }
        if (StringUtils.isNotBlank((CharSequence)this.sender)) {
            this.mailProperties.put(OPT_MAIL_FROM, this.sender);
            logger.debug("Mail sender is '{}'", (Object)this.sender);
        } else {
            logger.debug("Mail sender defaults not set");
        }
        this.mailProperties.put(OPT_MAIL_PREFIX + this.mailTransport + OPT_MAIL_TLS_ENABLE_SUFFIX, (Object)this.ssl);
        if (this.ssl) {
            logger.debug("TLS over SMTP is enabled");
        } else {
            logger.debug("TLS over SMTP is disabled");
        }
        this.mailProperties.put(OPT_MAIL_DEBUG, Boolean.toString(this.debug));
        logger.debug("Mail debugging is {}", (Object)(this.debug ? "enabled" : "disabled"));
        logger.info("Mail service configured with {}", (Object)this.host);
        Properties props = this.getSession().getProperties();
        for (String key : props.stringPropertyNames()) {
            logger.info("{}: {}", (Object)key, (Object)props.getProperty(key));
        }
    }

    public Session getSession() {
        if (this.defaultMailSession == null) {
            this.defaultMailSession = Session.getInstance((Properties)this.mailProperties);
        }
        return this.defaultMailSession;
    }

    public MimeMessage createMessage() {
        return new MimeMessage(this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MimeMessage message) throws MessagingException {
        message.setSentDate(new Date());
        if (!this.productionMode) {
            logger.debug("Skipping sending of message {} due to test mode", (Object)message);
            return;
        }
        Transport t = this.getSession().getTransport(this.mailTransport);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Session.class.getClassLoader());
            if (this.user != null) {
                t.connect(this.user, this.password);
            } else {
                t.connect();
            }
            t.sendMessage((Message)message, message.getAllRecipients());
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
            t.close();
        }
    }

    protected static enum Mode {
        production,
        test;

    }
}

