/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.opencastproject.kernel.security.SystemTokenRememberMeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;

public class SystemTokenBasedRememberMeService
extends TokenBasedRememberMeServices {
    private Logger logger = LoggerFactory.getLogger(SystemTokenBasedRememberMeService.class);

    @Deprecated
    public SystemTokenBasedRememberMeService() {
    }

    public SystemTokenBasedRememberMeService(String key, UserDetailsService userDetailsService) {
        super(SystemTokenRememberMeUtils.augmentKey(key), userDetailsService);
    }

    public void setKey(String key) {
        super.setKey(SystemTokenRememberMeUtils.augmentKey(key));
    }

    protected String makeTokenSignature(long tokenExpiryTime, String username, String password) {
        MessageDigest digest;
        String data = username + ":" + tokenExpiryTime + ":" + password + ":" + this.getKey();
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No SHA-512 algorithm available!");
        }
        return new String(Hex.encode((byte[])digest.digest(data.getBytes())));
    }
}

