/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.kernel.security.persistence.OrganizationDatabase;
import org.opencastproject.kernel.security.persistence.OrganizationDatabaseException;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryListener;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Tuple;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.pid=org.opencastproject.organization", "service.description=Organization Directory Service"}, immediate=true, service={OrganizationDirectoryService.class, ManagedServiceFactory.class})
public class OrganizationDirectoryServiceImpl
implements OrganizationDirectoryService,
ManagedServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationDirectoryServiceImpl.class);
    public static final String PID = "org.opencastproject.organization";
    public static final String ORG_PROPERTY_PREFIX = "prop.";
    public static final String ORG_ID_KEY = "id";
    public static final String ORG_NAME_KEY = "name";
    public static final String ORG_SERVER_PREFIX = "prop.org.opencastproject.host.";
    public static final String DEFAULT_SERVER_HOST = "localhost";
    public static final int DEFAULT_SERVER_PORT = 8080;
    public static final String ORG_ADMIN_ROLE_KEY = "admin_role";
    public static final String ORG_ANONYMOUS_ROLE_KEY = "anonymous_role";
    protected ConfigurationAdmin configAdmin = null;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private OrganizationDatabase persistence = null;
    private final List<OrganizationDirectoryListener> listeners = new ArrayList<OrganizationDirectoryListener>();
    private OrgCache cache;

    @Reference
    public void setOrgPersistence(OrganizationDatabase setOrgPersistence) {
        this.persistence = setOrgPersistence;
        this.cache = new OrgCache(60000L, this.persistence);
    }

    @Reference
    public void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public Organization getOrganization(String id) throws NotFoundException {
        Organization org = this.cache.get(id);
        if (org == null) {
            throw new NotFoundException();
        }
        return org;
    }

    public Organization getOrganization(URL url) throws NotFoundException {
        Organization org = this.cache.get(url);
        if (org == null) {
            throw new NotFoundException();
        }
        return org;
    }

    public List<Organization> getOrganizations() {
        return this.cache.getAll();
    }

    public void addOrganization(Organization organization) {
        boolean contains = this.persistence.containsOrganization(organization.getId());
        if (contains) {
            throw new IllegalStateException("Can not add an organization with id '" + organization.getId() + "' since an organization with that identifier has already been registered");
        }
        this.persistence.storeOrganization(organization);
        this.cache.invalidate();
        this.fireOrganizationRegistered(organization);
    }

    public String getName() {
        return PID;
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        logger.debug("Updating organization pid='{}'", (Object)pid);
        String id = (String)properties.get(ORG_ID_KEY);
        String name = (String)properties.get(ORG_NAME_KEY);
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ConfigurationException(ORG_ID_KEY, "id must be set");
        }
        String adminRole = (String)properties.get(ORG_ADMIN_ROLE_KEY);
        String anonRole = (String)properties.get(ORG_ANONYMOUS_ROLE_KEY);
        HashMap<String, String> orgProperties = new HashMap<String, String>();
        HashMap<String, Integer> servers = new HashMap<String, Integer>();
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            String string;
            String key = (String)e.nextElement();
            if (!key.startsWith(ORG_PROPERTY_PREFIX)) continue;
            if (key.startsWith(ORG_SERVER_PREFIX) && (string = StringUtils.trimToNull((String)((String)properties.get(key)))) != null) {
                try {
                    Tuple hostPort = SecurityUtil.hostAndPort((URL)new URL(string));
                    servers.put((String)hostPort.getA(), (Integer)hostPort.getB());
                }
                catch (MalformedURLException malformedURLException) {
                    logger.error("{} is not a URL", (Object)string);
                }
            }
            orgProperties.put(key.substring(ORG_PROPERTY_PREFIX.length()), (String)properties.get(key));
        }
        if (servers.isEmpty()) {
            logger.debug("No server URL configured for organization {}, setting default {}:{}", new Object[]{name, DEFAULT_SERVER_HOST, 8080});
            servers.put(DEFAULT_SERVER_HOST, 8080);
        }
        try {
            JpaOrganization org;
            try {
                org = (JpaOrganization)this.persistence.getOrganization(id);
                org.setName(name);
                for (Map.Entry entry : servers.entrySet()) {
                    org.addServer((String)entry.getKey(), (Integer)entry.getValue());
                }
                org.setAdminRole(adminRole);
                org.setAnonymousRole(anonRole);
                org.setProperties(orgProperties);
                logger.info("Updating organization '{}'", (Object)id);
                this.persistence.storeOrganization((Organization)org);
                this.fireOrganizationUpdated((Organization)org);
            }
            catch (NotFoundException e2) {
                org = new JpaOrganization(id, name, servers, adminRole, anonRole, orgProperties);
                logger.info("Creating organization '{}'", (Object)id);
                this.persistence.storeOrganization((Organization)org);
                this.fireOrganizationRegistered((Organization)org);
            }
            this.cache.invalidate();
        }
        catch (OrganizationDatabaseException e2) {
            logger.error("Unable to register organization '{}': {}", (Object)id, (Object)e2);
        }
    }

    public void deleted(String pid) {
        try {
            Organization organization = this.getOrganization(pid);
            this.persistence.deleteOrganization(pid);
            this.cache.invalidate();
            this.fireOrganizationUnregistered(organization);
        }
        catch (NotFoundException e) {
            logger.warn("Can't delete organization with id {}, organization not found.", (Object)pid);
        }
    }

    public void addOrganizationDirectoryListener(OrganizationDirectoryListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeOrganizationDirectoryListener(OrganizationDirectoryListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireOrganizationRegistered(Organization organization) {
        this.executor.submit(() -> {
            for (OrganizationDirectoryListener listener : this.listeners) {
                logger.debug("Notifying {} about newly registered organization '{}'", (Object)listener, (Object)organization);
                listener.organizationRegistered(organization);
            }
        });
    }

    private void fireOrganizationUnregistered(Organization organization) {
        this.executor.submit(() -> {
            for (OrganizationDirectoryListener listener : this.listeners) {
                logger.debug("Notifying {} about unregistered organization '{}'", (Object)listener, (Object)organization);
                listener.organizationUnregistered(organization);
            }
        });
    }

    private void fireOrganizationUpdated(Organization organization) {
        this.executor.submit(() -> {
            for (OrganizationDirectoryListener listener : this.listeners) {
                logger.debug("Notifying {} about updated organization '{}'", (Object)listener, (Object)organization);
                listener.organizationUpdated(organization);
            }
        });
    }

    private static final class OrgCache {
        private final Object lock = new Object();
        private final Map<Tuple<String, Integer>, Organization> byHost = Collections.map((Tuple[])new Tuple[0]);
        private final Map<String, Organization> byId = Collections.map((Tuple[])new Tuple[0]);
        private final long refreshInterval;
        private long lastRefresh;
        private final OrganizationDatabase persistence;

        OrgCache(long refreshInterval, OrganizationDatabase persistence) {
            this.refreshInterval = refreshInterval;
            this.persistence = persistence;
            this.invalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Organization get(URL url) {
            Object object = this.lock;
            synchronized (object) {
                this.refresh();
                return this.byHost.get(SecurityUtil.hostAndPort((URL)url));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Organization get(String id) {
            Object object = this.lock;
            synchronized (object) {
                this.refresh();
                return this.byId.get(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Organization> getAll() {
            Object object = this.lock;
            synchronized (object) {
                this.refresh();
                return Collections.toList(this.byId.values());
            }
        }

        public void invalidate() {
            this.lastRefresh = System.currentTimeMillis() - 2L * this.refreshInterval;
        }

        private void refresh() {
            long now = System.currentTimeMillis();
            if (now - this.lastRefresh > this.refreshInterval) {
                this.byId.clear();
                this.byHost.clear();
                for (Organization org : this.persistence.getOrganizations()) {
                    this.byId.put(org.getId(), org);
                    for (Map.Entry server : org.getServers().entrySet()) {
                        this.byHost.put((Tuple<String, Integer>)Tuple.tuple((Object)((String)server.getKey()), (Object)((Integer)server.getValue())), org);
                    }
                }
                this.lastRefresh = now;
            }
        }
    }
}

