/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.http;

import java.io.IOException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.UnknownFileTypeException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ServletContextHelper.class}, scope=ServiceScope.BUNDLE, property={"service.description=Opencast HttpContent"})
@HttpWhiteboardContext(path="/", name="opencast")
public class SharedHttpContext
extends ServletContextHelper {
    private static final Logger logger = LoggerFactory.getLogger(SharedHttpContext.class);
    protected BundleContext bundleContext = null;

    @Activate
    public void activate(ComponentContext cc) {
        this.bundleContext = cc.getBundleContext();
        logger.debug("Shared http context activated with bundle context {}", (Object)this.bundleContext);
    }

    @Deactivate
    public void deactivate() {
        this.bundleContext = null;
        logger.debug("Shared http context deactivated");
    }

    public String getMimeType(String name) {
        try {
            return MimeTypes.fromString((String)name).toString();
        }
        catch (UnknownFileTypeException e) {
            return null;
        }
    }

    public URL getResource(String path) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            ServiceReference[] filterRefs = this.bundleContext.getAllServiceReferences(Filter.class.getName(), null);
            return filterRefs != null && filterRefs.length > 0;
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

