/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.bundleinfo;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.Queries;
import org.opencastproject.kernel.bundleinfo.BundleInfo;
import org.opencastproject.kernel.bundleinfo.BundleInfoImpl;
import org.opencastproject.util.data.Option;

@Entity(name="BundleInfo")
@Table(name="oc_bundleinfo", uniqueConstraints={@UniqueConstraint(columnNames={"host", "bundle_name", "bundle_version"})})
@NamedQueries(value={@NamedQuery(name="BundleInfo.findAll", query="select a from BundleInfo a order by a.host, a.bundleSymbolicName"), @NamedQuery(name="BundleInfo.deleteAll", query="delete from BundleInfo"), @NamedQuery(name="BundleInfo.deleteByHost", query="delete from BundleInfo where host = :host"), @NamedQuery(name="BundleInfo.delete", query="delete from BundleInfo where host = :host and bundleId = :bundleId")})
public class BundleInfoJpa {
    @Id
    @Column(name="id")
    @GeneratedValue
    protected long id;
    @Column(name="host", length=128, nullable=false)
    protected String host;
    @Column(name="bundle_name", length=128, nullable=false)
    protected String bundleSymbolicName;
    @Column(name="bundle_id", length=128, nullable=false)
    protected long bundleId;
    @Column(name="bundle_version", length=128, nullable=false)
    protected String bundleVersion;
    @Column(name="build_number", length=128, nullable=true)
    protected String buildNumber;
    @Column(name="db_schema_version", length=128, nullable=true)
    protected String dbSchemaVersion;
    public static final Function<EntityManager, List<BundleInfoJpa>> findAll = Queries.namedQuery.findAll("BundleInfo.findAll", BundleInfoJpa.class, new Object[0]);
    public static final Function<EntityManager, Integer> deleteAll = Queries.namedQuery.update("BundleInfo.deleteAll", new Object[0]);

    public static BundleInfoJpa create(BundleInfo a) {
        BundleInfoJpa dto = new BundleInfoJpa();
        dto.host = a.getHost();
        dto.bundleSymbolicName = a.getBundleSymbolicName();
        dto.bundleId = a.getBundleId();
        dto.bundleVersion = a.getBundleVersion();
        Iterator iterator = a.getBuildNumber().iterator();
        while (iterator.hasNext()) {
            String x;
            dto.buildNumber = x = (String)iterator.next();
        }
        return dto;
    }

    public BundleInfo toBundleInfo() {
        return BundleInfoImpl.bundleInfo(this.host, this.bundleSymbolicName, this.bundleId, this.bundleVersion, (Option<String>)Option.option((Object)this.buildNumber), (Option<String>)Option.option((Object)this.dbSchemaVersion));
    }

    public static Function<EntityManager, List<BundleInfoJpa>> findAll(String ... prefixes) {
        return em -> {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(BundleInfoJpa.class);
            Root r = q.from(BundleInfoJpa.class);
            q.select((Selection)r);
            Path symbolicNamePath = r.get("bundleSymbolicName");
            Predicate[] likes = (Predicate[])Stream.of(prefixes).map(arg_0 -> BundleInfoJpa.lambda$findAll$0(cb, (Expression)symbolicNamePath, arg_0)).toArray(Predicate[]::new);
            q.where((Expression)cb.or(likes));
            q.orderBy(new Order[]{cb.asc((Expression)r.get("host")), cb.asc((Expression)symbolicNamePath)});
            return em.createQuery(q).getResultList();
        };
    }

    public static Function<EntityManager, Integer> deleteByHost(String host) {
        return Queries.namedQuery.update("BundleInfo.deleteByHost", new Object[]{Pair.of((Object)"host", (Object)host)});
    }

    public static Function<EntityManager, Integer> delete(String host, long bundleId) {
        return Queries.namedQuery.update("BundleInfo.delete", new Object[]{Pair.of((Object)"host", (Object)host), Pair.of((Object)"bundleId", (Object)bundleId)});
    }

    private static /* synthetic */ Predicate lambda$findAll$0(CriteriaBuilder cb, Expression symbolicNamePath, String prefix) {
        return cb.like(symbolicNamePath, prefix + "%");
    }
}

