/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.bundleinfo;

import org.opencastproject.kernel.bundleinfo.BundleInfo;
import org.opencastproject.kernel.bundleinfo.BundleVersion;
import org.opencastproject.util.data.Option;

public class BundleInfoImpl
implements BundleInfo {
    private final String host;
    private final String bundleSymbolicName;
    private final long bundleId;
    private final String bundleVersion;
    private final Option<String> buildNumber;
    private final Option<String> dbSchemaVersion;
    private final BundleVersion version;

    public BundleInfoImpl(String host, String bundleSymbolicName, long bundleId, String bundleVersion, Option<String> buildNumber, Option<String> dbSchemaVersion) {
        this.host = host;
        this.bundleSymbolicName = bundleSymbolicName;
        this.bundleId = bundleId;
        this.bundleVersion = bundleVersion;
        this.buildNumber = buildNumber;
        this.dbSchemaVersion = dbSchemaVersion;
        this.version = new BundleVersion(bundleVersion, buildNumber);
    }

    public static BundleInfo bundleInfo(String host, String bundleSymbolicName, long bundleId, String bundleVersion, Option<String> buildNumber) {
        return new BundleInfoImpl(host, bundleSymbolicName, bundleId, bundleVersion, buildNumber, (Option<String>)Option.none((Object)""));
    }

    public static BundleInfo bundleInfo(String host, String bundleSymbolicName, long bundleId, String bundleVersion, Option<String> buildNumber, Option<String> dbSchemaVersion) {
        return new BundleInfoImpl(host, bundleSymbolicName, bundleId, bundleVersion, buildNumber, dbSchemaVersion);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    @Override
    public long getBundleId() {
        return this.bundleId;
    }

    @Override
    public String getBundleVersion() {
        return this.bundleVersion;
    }

    @Override
    public Option<String> getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public BundleVersion getVersion() {
        return this.version;
    }
}

