/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.inspection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.opencastproject.inspection.api.MediaInspectionException;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageReferenceImpl;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.UnsupportedElementException;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreCatalogService;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Compose Workflow Operation Handler", "workflow.operation=inspect"})
public class InspectWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(InspectWorkflowOperationHandler.class);
    private static final String OPT_OVERWRITE = "overwrite";
    private static final String OPT_ACCEPT_NO_MEDIA = "accept-no-media";
    private static final String OPT_ACCURATE_FRAME_COUNT = "accurate-frame-count";
    private MediaInspectionService inspectionService = null;
    private DublinCoreCatalogService dcService;
    private Workspace workspace;

    @Reference
    public void setDublincoreService(DublinCoreCatalogService dcService) {
        this.dcService = dcService;
    }

    @Reference
    protected void setInspectionService(MediaInspectionService inspectionService) {
        this.inspectionService = inspectionService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = (MediaPackage)workflowInstance.getMediaPackage().clone();
        long totalTimeInQueue = 0L;
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        boolean rewrite = "true".equalsIgnoreCase(operation.getConfiguration(OPT_OVERWRITE));
        boolean acceptNoMedia = "true".equalsIgnoreCase(operation.getConfiguration(OPT_ACCEPT_NO_MEDIA));
        HashMap<String, String> options = new HashMap<String, String>();
        if ("true".equalsIgnoreCase(operation.getConfiguration(OPT_ACCURATE_FRAME_COUNT))) {
            logger.info("Using accurate frame count for inspection media package {}", (Object)mediaPackage);
            options.put(OPT_ACCURATE_FRAME_COUNT, Boolean.TRUE.toString());
        }
        if (mediaPackage.getTracks().length == 0) {
            logger.warn("Recording {} contains no media", (Object)mediaPackage);
            if (!acceptNoMedia) {
                throw new WorkflowOperationException("Mediapackage " + mediaPackage + " contains no media");
            }
        }
        for (Track track : mediaPackage.getTracks()) {
            Track inspectedTrack;
            logger.info("Inspecting track '{}' of {}", (Object)track.getIdentifier(), (Object)mediaPackage);
            Job inspectJob = null;
            try {
                inspectJob = this.inspectionService.enrich((MediaPackageElement)track, rewrite, options);
                if (!this.waitForStatus(new Job[]{inspectJob}).isSuccess()) {
                    throw new WorkflowOperationException("Track " + track + " could not be inspected");
                }
            }
            catch (MediaInspectionException e) {
                throw new WorkflowOperationException("Error inspecting media package", (Throwable)e);
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException("Error parsing media package", (Throwable)e);
            }
            long timeInQueue = inspectJob.getQueueTime() == null ? 0L : inspectJob.getQueueTime();
            totalTimeInQueue += timeInQueue;
            try {
                inspectedTrack = (Track)MediaPackageElementParser.getFromXml((String)inspectJob.getPayload());
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException("Unable to parse track from job " + inspectJob.getId(), (Throwable)e);
            }
            if (inspectedTrack == null) {
                throw new WorkflowOperationException("Track " + track + " could not be inspected");
            }
            if (inspectedTrack.getStreams().length == 0) {
                throw new WorkflowOperationException(String.format("Track %s does not contain any streams", track));
            }
            try {
                mediaPackage.remove(track);
                mediaPackage.add(inspectedTrack);
            }
            catch (UnsupportedElementException e) {
                logger.error("Error adding {} to media package", (Object)inspectedTrack, (Object)e);
            }
        }
        try {
            this.updateDublinCore(mediaPackage);
        }
        catch (Exception e) {
            logger.warn("Unable to update dublin core data: {}", (Object)e.getMessage(), (Object)e);
            throw new WorkflowOperationException(e.getMessage());
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
    }

    protected void updateDublinCore(MediaPackage mediaPackage) throws Exception {
        Catalog[] dcCatalogs = mediaPackage.getCatalogs(MediaPackageElements.EPISODE, MediaPackageReferenceImpl.ANY_MEDIAPACKAGE);
        if (dcCatalogs.length > 0) {
            DublinCoreCatalog dublinCore = this.loadDublinCoreCatalog(dcCatalogs[0]);
            if (mediaPackage.getDuration() != null && !dublinCore.hasValue(DublinCore.PROPERTY_EXTENT)) {
                DublinCoreValue extent = EncodingSchemeUtils.encodeDuration((long)mediaPackage.getDuration());
                dublinCore.set(DublinCore.PROPERTY_EXTENT, extent);
                logger.debug("Setting dc:extent to '{}'", (Object)extent.getValue());
            }
            if (mediaPackage.getDate() != null && !dublinCore.hasValue(DublinCore.PROPERTY_CREATED)) {
                DublinCoreValue date = EncodingSchemeUtils.encodeDate((Date)mediaPackage.getDate(), (Precision)Precision.Minute);
                dublinCore.set(DublinCore.PROPERTY_CREATED, date);
                logger.debug("Setting dc:date to '{}'", (Object)date.getValue());
            }
            if (mediaPackage.getDuration() != null && dublinCore.hasValue(DublinCore.PROPERTY_CREATED) && !dublinCore.hasValue(DublinCore.PROPERTY_TEMPORAL)) {
                Date created = EncodingSchemeUtils.decodeDate((String)dublinCore.getFirst(DublinCore.PROPERTY_CREATED));
                if (created != null) {
                    Date end = Date.from(created.toInstant().plus((long)mediaPackage.getDuration(), ChronoUnit.MILLIS));
                    DublinCoreValue temporal = EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(created, end), (Precision)Precision.Second);
                    dublinCore.set(DublinCore.PROPERTY_TEMPORAL, temporal);
                    logger.debug("Setting dc:temporal to '{}'", (Object)temporal.getValue());
                } else {
                    logger.warn("Unable to parse dc:created value '{}'; mediapackage '{}'", (Object)dublinCore.getFirst(DublinCore.PROPERTY_CREATED), (Object)mediaPackage.getIdentifier());
                }
            }
            InputStream in = this.dcService.serialize(dublinCore);
            String mpId = mediaPackage.getIdentifier().toString();
            String elementId = dcCatalogs[0].getIdentifier();
            this.workspace.put(mpId, elementId, FilenameUtils.getName((String)dcCatalogs[0].getURI().getPath()), in);
            dcCatalogs[0].setURI(this.workspace.getURI(mpId, elementId));
        }
    }

    protected DublinCoreCatalog loadDublinCoreCatalog(Catalog catalog) throws IOException {
        DublinCoreCatalog dublinCoreCatalog;
        FileInputStream in = null;
        try {
            File f = this.workspace.get(catalog.getURI());
            in = new FileInputStream(f);
            dublinCoreCatalog = this.dcService.load((InputStream)in);
        }
        catch (NotFoundException e) {
            try {
                throw new IOException("Unable to open catalog " + catalog, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return dublinCoreCatalog;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

