/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingest.endpoint;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.opencastproject.authorization.xacml.XACMLUtils;
import org.opencastproject.ingest.api.IngestException;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.identifier.Id;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreCatalogService;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.scheduler.api.SchedulerConflictException;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.AccessControlParsingException;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Function0;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.workflow.api.JaxbWorkflowInstance;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.XmlWorkflowParser;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ingest")
@RestService(name="ingestservice", title="Ingest Service", abstractText="This service creates and augments Opencast media packages that include media tracks, metadata catalogs and attachments.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={IngestRestService.class}, property={"service.description=Ingest REST Endpoint", "opencast.service.type=org.opencastproject.ingest", "opencast.service.path=/ingest", "opencast.service.jobproducer=true"})
@JaxrsResource
public class IngestRestService
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(IngestRestService.class);
    protected static final String DEFAULT_WORKFLOW_DEFINITION = "org.opencastproject.workflow.default.definition";
    protected static final String MAX_INGESTS_KEY = "org.opencastproject.ingest.max.concurrent";
    protected static final String WORKFLOW_INSTANCE_ID_PARAM = "workflowInstanceId";
    protected static final String WORKFLOW_DEFINITION_ID_PARAM = "workflowDefinitionId";
    private String defaultWorkflowDefinitionId = null;
    private TrustedHttpClient httpClient;
    private static final List<String> dcterms = Arrays.asList("abstract", "accessRights", "accrualMethod", "accrualPeriodicity", "accrualPolicy", "alternative", "audience", "available", "bibliographicCitation", "conformsTo", "contributor", "coverage", "created", "creator", "date", "dateAccepted", "dateCopyrighted", "dateSubmitted", "description", "educationLevel", "extent", "format", "hasFormat", "hasPart", "hasVersion", "identifier", "instructionalMethod", "isFormatOf", "isPartOf", "isReferencedBy", "isReplacedBy", "isRequiredBy", "issued", "isVersionOf", "language", "license", "mediator", "medium", "modified", "provenance", "publisher", "references", "relation", "replaces", "requires", "rights", "rightsHolder", "source", "spatial", "subject", "tableOfContents", "temporal", "title", "type", "valid");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final MediaPackageBuilderFactory MP_FACTORY = MediaPackageBuilderFactory.newInstance();
    private IngestService ingestService = null;
    private ServiceRegistry serviceRegistry = null;
    private DublinCoreCatalogService dublinCoreService;
    private int ingestLimit = -1;
    private final Cache<String, Date> startCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();

    protected synchronized int getIngestLimit() {
        return this.ingestLimit;
    }

    private synchronized void setIngestLimit(int ingestLimit) {
        this.ingestLimit = ingestLimit;
    }

    protected synchronized boolean isIngestLimitEnabled() {
        return this.ingestLimit >= 0;
    }

    @Activate
    public void activate(ComponentContext cc) {
        if (cc != null) {
            this.defaultWorkflowDefinitionId = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(DEFAULT_WORKFLOW_DEFINITION));
            if (this.defaultWorkflowDefinitionId == null) {
                this.defaultWorkflowDefinitionId = "schedule-and-upload";
            }
            if (cc.getBundleContext().getProperty(MAX_INGESTS_KEY) != null) {
                try {
                    this.ingestLimit = Integer.parseInt(StringUtils.trimToNull((String)cc.getBundleContext().getProperty(MAX_INGESTS_KEY)));
                    if (this.ingestLimit == 0) {
                        this.ingestLimit = -1;
                    }
                }
                catch (NumberFormatException e) {
                    logger.warn("Max ingest property with key org.opencastproject.ingest.max.concurrent isn't defined so no ingest limit will be used.");
                    this.ingestLimit = -1;
                }
            }
        }
    }

    @PUT
    @Produces(value={"text/xml"})
    @Path(value="createMediaPackageWithID/{id}")
    @RestQuery(name="createMediaPackageWithID", description="Create an empty media package with ID /n Overrides Existing Mediapackage ", pathParameters={@RestParameter(description="The Id for the new Mediapackage", isRequired=true, name="id", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns media package", responseCode=200), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response createMediaPackage(@PathParam(value="id") String mediaPackageId) {
        try {
            MediaPackage mp = this.ingestService.createMediaPackage(mediaPackageId);
            this.startCache.put((Object)mp.getIdentifier().toString(), (Object)new Date());
            return Response.ok((Object)mp).build();
        }
        catch (Exception e) {
            logger.warn("Unable to create mediapackage", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="createMediaPackage")
    @RestQuery(name="createMediaPackage", description="Create an empty media package", restParameters={}, responses={@RestResponse(description="Returns media package", responseCode=200), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response createMediaPackage() {
        try {
            MediaPackage mp = this.ingestService.createMediaPackage();
            this.startCache.put((Object)mp.getIdentifier().toString(), (Object)new Date());
            return Response.ok((Object)mp).build();
        }
        catch (Exception e) {
            logger.warn("Unable to create empty mediapackage", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="discardMediaPackage")
    @RestQuery(name="discardMediaPackage", description="Discard a media package", restParameters={@RestParameter(description="Given media package to be destroyed", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="", responseCode=200), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response discardMediaPackage(@FormParam(value="mediaPackage") String mpx) {
        logger.debug("discardMediaPackage(MediaPackage): {}", (Object)mpx);
        try {
            MediaPackage mp = MP_FACTORY.newMediaPackageBuilder().loadFromXml(mpx);
            this.ingestService.discardMediaPackage(mp);
            return Response.ok().build();
        }
        catch (Exception e) {
            logger.warn("Unable to discard mediapackage {}", (Object)mpx, (Object)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="addTrack")
    @RestQuery(name="addTrackURL", description="Add a media track to a given media package using an URL", restParameters={@RestParameter(description="The location of the media", isRequired=true, name="url", type=RestParameter.Type.STRING), @RestParameter(description="The kind of media", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="The tags of the  media track", isRequired=false, name="tags", type=RestParameter.Type.STRING), @RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addMediaPackageTrack(@FormParam(value="url") String url, @FormParam(value="flavor") String flavor, @FormParam(value="tags") String tags, @FormParam(value="mediaPackage") String mpx) {
        logger.trace("add media package from url: {} flavor: {} tags: {} mediaPackage: {}", new Object[]{url, flavor, tags, mpx});
        try {
            MediaPackage mp = MP_FACTORY.newMediaPackageBuilder().loadFromXml(mpx);
            if (MediaPackageSupport.sanityCheck((MediaPackage)mp).isSome()) {
                return Response.serverError().status(Response.Status.BAD_REQUEST).build();
            }
            String[] tagsArray = null;
            if (tags != null) {
                tagsArray = tags.split(",");
            }
            mp = this.ingestService.addTrack(new URI(url), MediaPackageElementFlavor.parseFlavor((String)flavor), tagsArray, mp);
            return Response.ok((Object)mp).build();
        }
        catch (Exception e) {
            logger.warn("Unable to add mediapackage track", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="addTrack")
    @RestQuery(name="addTrackInputStream", description="Add a media track to a given media package using an input stream", restParameters={@RestParameter(description="The kind of media track", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="The tags of the media track", isRequired=false, name="tags", type=RestParameter.Type.STRING), @RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, bodyParameter=@RestParameter(description="The media track file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addMediaPackageTrack(@Context HttpServletRequest request) {
        logger.trace("add track as multipart-form-data");
        return this.addMediaPackageElement(request, MediaPackageElement.Type.Track);
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="addPartialTrack")
    @RestQuery(name="addPartialTrackURL", description="Add a partial media track to a given media package using an URL", restParameters={@RestParameter(description="The location of the media", isRequired=true, name="url", type=RestParameter.Type.STRING), @RestParameter(description="The kind of media", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="The start time in milliseconds", isRequired=true, name="startTime", type=RestParameter.Type.INTEGER), @RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addMediaPackagePartialTrack(@FormParam(value="url") String url, @FormParam(value="flavor") String flavor, @FormParam(value="startTime") Long startTime, @FormParam(value="mediaPackage") String mpx) {
        logger.trace("add partial track with url: {} flavor: {} startTime: {} mediaPackage: {}", new Object[]{url, flavor, startTime, mpx});
        try {
            MediaPackage mp = MP_FACTORY.newMediaPackageBuilder().loadFromXml(mpx);
            if (MediaPackageSupport.sanityCheck((MediaPackage)mp).isSome()) {
                return Response.serverError().status(Response.Status.BAD_REQUEST).build();
            }
            mp = this.ingestService.addPartialTrack(new URI(url), MediaPackageElementFlavor.parseFlavor((String)flavor), startTime.longValue(), mp);
            return Response.ok((Object)mp).build();
        }
        catch (Exception e) {
            logger.warn("Unable to add partial track", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="addPartialTrack")
    @RestQuery(name="addPartialTrackInputStream", description="Add a partial media track to a given media package using an input stream", restParameters={@RestParameter(description="The kind of media track", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="The start time in milliseconds", isRequired=true, name="startTime", type=RestParameter.Type.INTEGER), @RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, bodyParameter=@RestParameter(description="The media track file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addMediaPackagePartialTrack(@Context HttpServletRequest request) {
        logger.trace("add partial track as multipart-form-data");
        return this.addMediaPackageElement(request, MediaPackageElement.Type.Track);
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="addCatalog")
    @RestQuery(name="addCatalogURL", description="Add a metadata catalog to a given media package using an URL", restParameters={@RestParameter(description="The location of the catalog", isRequired=true, name="url", type=RestParameter.Type.STRING), @RestParameter(description="The kind of catalog", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="The tags of the catalog", isRequired=false, name="tags", type=RestParameter.Type.STRING), @RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addMediaPackageCatalog(@FormParam(value="url") String url, @FormParam(value="flavor") String flavor, @FormParam(value="tags") String tags, @FormParam(value="mediaPackage") String mpx) {
        logger.trace("add catalog with url: {} flavor: {} tags: {} mediaPackage: {}", new Object[]{url, flavor, tags, mpx});
        try {
            MediaPackage mp = MP_FACTORY.newMediaPackageBuilder().loadFromXml(mpx);
            if (MediaPackageSupport.sanityCheck((MediaPackage)mp).isSome()) {
                return Response.serverError().status(Response.Status.BAD_REQUEST).build();
            }
            String[] tagsArray = null;
            if (tags != null) {
                tagsArray = tags.split(",");
            }
            MediaPackage resultingMediaPackage = this.ingestService.addCatalog(new URI(url), MediaPackageElementFlavor.parseFlavor((String)flavor), tagsArray, mp);
            return Response.ok((Object)resultingMediaPackage).build();
        }
        catch (Exception e) {
            logger.warn("Unable to add catalog", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="addCatalog")
    @RestQuery(name="addCatalogInputStream", description="Add a metadata catalog to a given media package using an input stream", restParameters={@RestParameter(description="The kind of media catalog", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="The tags of the attachment", isRequired=false, name="tags", type=RestParameter.Type.STRING), @RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, bodyParameter=@RestParameter(description="The metadata catalog file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addMediaPackageCatalog(@Context HttpServletRequest request) {
        logger.trace("add catalog as multipart-form-data");
        return this.addMediaPackageElement(request, MediaPackageElement.Type.Catalog);
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="addAttachment")
    @RestQuery(name="addAttachmentURL", description="Add an attachment to a given media package using an URL", restParameters={@RestParameter(description="The location of the attachment", isRequired=true, name="url", type=RestParameter.Type.STRING), @RestParameter(description="The kind of attachment", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="The tags of the attachment", isRequired=false, name="tags", type=RestParameter.Type.STRING), @RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addMediaPackageAttachment(@FormParam(value="url") String url, @FormParam(value="flavor") String flavor, @FormParam(value="tags") String tags, @FormParam(value="mediaPackage") String mpx) {
        logger.trace("add attachment with url: {} flavor: {} mediaPackage: {}", new Object[]{url, flavor, mpx});
        try {
            MediaPackage mp = MP_FACTORY.newMediaPackageBuilder().loadFromXml(mpx);
            if (MediaPackageSupport.sanityCheck((MediaPackage)mp).isSome()) {
                return Response.serverError().status(Response.Status.BAD_REQUEST).build();
            }
            String[] tagsArray = null;
            if (tags != null) {
                tagsArray = tags.split(",");
            }
            mp = this.ingestService.addAttachment(new URI(url), MediaPackageElementFlavor.parseFlavor((String)flavor), tagsArray, mp);
            return Response.ok((Object)mp).build();
        }
        catch (Exception e) {
            logger.warn("Unable to add attachment", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="addAttachment")
    @RestQuery(name="addAttachmentInputStream", description="Add an attachment to a given media package using an input stream", restParameters={@RestParameter(description="The kind of attachment", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="The tags of the attachment", isRequired=false, name="tags", type=RestParameter.Type.STRING), @RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, bodyParameter=@RestParameter(description="The attachment file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addMediaPackageAttachment(@Context HttpServletRequest request) {
        logger.trace("add attachment as multipart-form-data");
        return this.addMediaPackageElement(request, MediaPackageElement.Type.Attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response addMediaPackageElement(HttpServletRequest request, MediaPackageElement.Type type) {
        Response response;
        MediaPackageElementFlavor flavor = null;
        InputStream in = null;
        try {
            String fileName = null;
            MediaPackage mp = null;
            Long startTime = null;
            String[] tags = null;
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                logger.trace("request isn't multipart-form-data");
                Response response2 = Response.serverError().status(Response.Status.BAD_REQUEST).build();
                return response2;
            }
            boolean isDone = false;
            FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    if ("flavor".equals(fieldName)) {
                        String flavorString = Streams.asString((InputStream)item.openStream(), (String)"UTF-8");
                        logger.trace("flavor: {}", (Object)flavorString);
                        if (flavorString != null) {
                            try {
                                flavor = MediaPackageElementFlavor.parseFlavor((String)flavorString);
                            }
                            catch (IllegalArgumentException e2) {
                                String error = String.format("Could not parse flavor '%s'", flavorString);
                                logger.debug(error, (Throwable)e2);
                                Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
                                IOUtils.closeQuietly((InputStream)in);
                                return response3;
                            }
                        }
                    } else if ("tags".equals(fieldName)) {
                        String tagsString = Streams.asString((InputStream)item.openStream(), (String)"UTF-8");
                        logger.trace("tags: {}", (Object)tagsString);
                        tags = tagsString.split(",");
                    } else if ("mediaPackage".equals(fieldName)) {
                        try {
                            String mediaPackageString = Streams.asString((InputStream)item.openStream(), (String)"UTF-8");
                            logger.trace("mediaPackage: {}", (Object)mediaPackageString);
                            mp = MP_FACTORY.newMediaPackageBuilder().loadFromXml(mediaPackageString);
                        }
                        catch (MediaPackageException e) {
                            logger.debug("Unable to parse the 'mediaPackage' parameter: {}", (Object)ExceptionUtils.getMessage((Throwable)e));
                            Response e2 = Response.serverError().status(Response.Status.BAD_REQUEST).build();
                            IOUtils.closeQuietly((InputStream)in);
                            return e2;
                        }
                    } else if ("startTime".equals(fieldName) && "/ingest/addPartialTrack".equals(request.getPathInfo())) {
                        String startTimeString = Streams.asString((InputStream)item.openStream(), (String)"UTF-8");
                        logger.trace("startTime: {}", (Object)startTime);
                        try {
                            startTime = Long.parseLong(startTimeString);
                        }
                        catch (Exception e) {
                            logger.debug("Unable to parse the 'startTime' parameter: {}", (Object)ExceptionUtils.getMessage((Throwable)e));
                            Response response4 = Response.serverError().status(Response.Status.BAD_REQUEST).build();
                            IOUtils.closeQuietly((InputStream)in);
                            return response4;
                        }
                    }
                } else {
                    if (flavor == null) {
                        logger.debug("A flavor has to be specified in the request prior to the content BODY");
                        Response response5 = Response.serverError().status(Response.Status.BAD_REQUEST).build();
                        IOUtils.closeQuietly((InputStream)in);
                        return response5;
                    }
                    fileName = item.getName();
                    in = item.openStream();
                    isDone = true;
                }
                if (!isDone) continue;
                break;
            }
            if (in == null || mp == null || MediaPackageSupport.sanityCheck(mp).isSome()) {
                iter = Response.serverError().status(Response.Status.BAD_REQUEST).build();
                return iter;
            }
            switch (type) {
                case Attachment: {
                    mp = this.ingestService.addAttachment(in, fileName, flavor, tags, mp);
                    break;
                }
                case Catalog: {
                    try {
                        mp = this.ingestService.addCatalog(in, fileName, flavor, tags, mp);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        logger.debug("Invalid catalog data", (Throwable)e);
                        Response response6 = Response.serverError().status(Response.Status.BAD_REQUEST).build();
                        IOUtils.closeQuietly((InputStream)in);
                        return response6;
                    }
                }
                case Track: {
                    if (startTime == null) {
                        mp = this.ingestService.addTrack(in, fileName, flavor, tags, mp);
                        break;
                    }
                    mp = this.ingestService.addPartialTrack(in, fileName, flavor, startTime.longValue(), mp);
                    break;
                }
                default: {
                    throw new IllegalStateException("Type must be one of track, catalog, or attachment");
                }
            }
            response = Response.ok((Object)MediaPackageParser.getAsXml((MediaPackage)mp)).build();
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Exception e) {
            logger.warn("Unable to add mediapackage element", (Throwable)e);
            Response response7 = Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
            return response7;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return response;
    }

    @POST
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="addMediaPackage")
    @RestQuery(name="addMediaPackage", description="<p>Create and ingest media package from media tracks with additional Dublin Core metadata. It is mandatory to set a title for the recording. This can be done with the 'title' form field or by supplying a DC catalog with a title included.  The identifier of the newly created media package will be taken from the <em>identifier</em> field or the episode DublinCore catalog (deprecated<sup>*</sup>). If no identifier is set, a new random UUIDv4 will be generated. This endpoint is not meant to be used by capture agents for scheduled recordings. Its primary use is for manual ingests with command line tools like cURL.</p> <p>Multiple tracks can be ingested by using multiple form fields. It is important to always set the flavor of the next media file <em>before</em> sending the media file itself.</p><b>(*)</b> The special treatment of the identifier field is deprecated and may be removed in future versions without further notice in favor of a random UUID generation to ensure uniqueness of identifiers. <h3>Example cURL command:</h3><p>Ingest one video file:</p><p><pre>\ncurl -i -u admin:opencast http://localhost:8080/ingest/addMediaPackage \\\n    -F creator='John Doe' -F title='Test Recording' \\\n    -F 'flavor=presentation/source' -F 'BODY=@test-recording.mp4' \n</pre></p><p>Ingest two video files:</p><p><pre>\ncurl -i -u admin:opencast http://localhost:8080/ingest/addMediaPackage \\\n    -F creator='John Doe' -F title='Test Recording' \\\n    -F 'flavor=presentation/source' -F 'BODY=@test-recording-vga.mp4' \\\n    -F 'flavor=presenter/source' -F 'BODY=@test-recording-camera.mp4' \n</pre></p>", restParameters={@RestParameter(description="The kind of media track. This has to be specified prior to each media track", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="abstract", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="accessRights", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="available", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="contributor", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="coverage", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="created", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="creator", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="date", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="description", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="extent", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="format", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="identifier", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="isPartOf", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="isReferencedBy", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="isReplacedBy", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="language", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="license", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="publisher", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="relation", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="replaces", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="rights", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="rightsHolder", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="source", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="spatial", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="subject", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="temporal", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="title", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="type", type=RestParameter.Type.STRING), @RestParameter(description="URL of episode DublinCore Catalog", isRequired=false, name="episodeDCCatalogUri", type=RestParameter.Type.STRING), @RestParameter(description="Episode DublinCore Catalog", isRequired=false, name="episodeDCCatalog", type=RestParameter.Type.STRING), @RestParameter(description="URL of series DublinCore Catalog", isRequired=false, name="seriesDCCatalogUri", type=RestParameter.Type.STRING), @RestParameter(description="Series DublinCore Catalog", isRequired=false, name="seriesDCCatalog", type=RestParameter.Type.STRING), @RestParameter(description="Access control list in XACML or JSON form", isRequired=false, name="acl", type=RestParameter.Type.STRING), @RestParameter(description="Tag of the next media file", isRequired=false, name="tag", type=RestParameter.Type.STRING), @RestParameter(description="URL of a media track file", isRequired=false, name="mediaUri", type=RestParameter.Type.STRING)}, bodyParameter=@RestParameter(description="The media track file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="Ingest successful. Returns workflow instance as xml", responseCode=200), @RestResponse(description="Ingest failed due to invalid requests.", responseCode=400), @RestResponse(description="Ingest failed. Something went wrong internally. Please have a look at the log files", responseCode=500)}, returnDescription="")
    public Response addMediaPackage(@Context HttpServletRequest request) {
        logger.trace("add mediapackage as multipart-form-data");
        return this.addMediaPackage(request, null);
    }

    @POST
    @Produces(value={"text/xml"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="addMediaPackage/{wdID}")
    @RestQuery(name="addMediaPackage", description="<p>Create and ingest media package from media tracks with additional Dublin Core metadata. It is mandatory to set a title for the recording. This can be done with the 'title' form field or by supplying a DC catalog with a title included.  The identifier of the newly created media package will be taken from the <em>identifier</em> field or the episode DublinCore catalog (deprecated<sup>*</sup>). If no identifier is set, a newa randumm UUIDv4 will be generated. This endpoint is not meant to be used by capture agents for scheduled recordings. It's primary use is for manual ingests with command line tools like cURL.</p> <p>Multiple tracks can be ingested by using multiple form fields. It's important, however, to always set the flavor of the next media file <em>before</em> sending the media file itself.</p><b>(*)</b> The special treatment of the identifier field is deprecated any may be removed in future versions without further notice in favor of a random UUID generation to ensure uniqueness of identifiers. <h3>Example cURL command:</h3><p>Ingest one video file:</p><p><pre>\ncurl -i -u admin:opencast http://localhost:8080/ingest/addMediaPackage/fast \\\n    -F creator='John Doe' -F title='Test Recording' \\\n    -F 'flavor=presentation/source' -F 'BODY=@test-recording.mp4' \n</pre></p><p>Ingest two video files:</p><p><pre>\ncurl -i -u admin:opencast http://localhost:8080/ingest/addMediaPackage/fast \\\n    -F creator='John Doe' -F title='Test Recording' \\\n    -F 'flavor=presentation/source' -F 'BODY=@test-recording-vga.mp4' \\\n    -F 'flavor=presenter/source' -F 'BODY=@test-recording-camera.mp4' \n</pre></p>", pathParameters={@RestParameter(description="Workflow definition id", isRequired=true, name="wdID", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The kind of media track. This has to be specified prior to each media track", isRequired=true, name="flavor", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="abstract", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="accessRights", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="available", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="contributor", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="coverage", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="created", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="creator", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="date", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="description", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="extent", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="format", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="identifier", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="isPartOf", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="isReferencedBy", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="isReplacedBy", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="language", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="license", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="publisher", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="relation", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="replaces", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="rights", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="rightsHolder", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="source", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="spatial", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="subject", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="temporal", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="title", type=RestParameter.Type.STRING), @RestParameter(description="Episode metadata value", isRequired=false, name="type", type=RestParameter.Type.STRING), @RestParameter(description="URL of episode DublinCore Catalog", isRequired=false, name="episodeDCCatalogUri", type=RestParameter.Type.STRING), @RestParameter(description="Episode DublinCore Catalog", isRequired=false, name="episodeDCCatalog", type=RestParameter.Type.STRING), @RestParameter(description="URL of series DublinCore Catalog", isRequired=false, name="seriesDCCatalogUri", type=RestParameter.Type.STRING), @RestParameter(description="Series DublinCore Catalog", isRequired=false, name="seriesDCCatalog", type=RestParameter.Type.STRING), @RestParameter(description="Access control list in XACML or JSON form", isRequired=false, name="acl", type=RestParameter.Type.STRING), @RestParameter(description="Tag of the next media file", isRequired=false, name="tag", type=RestParameter.Type.STRING), @RestParameter(description="URL of a media track file", isRequired=false, name="mediaUri", type=RestParameter.Type.STRING)}, bodyParameter=@RestParameter(description="The media track file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="Ingest successful. Returns workflow instance as XML", responseCode=200), @RestResponse(description="Ingest failed due to invalid requests.", responseCode=400), @RestResponse(description="Ingest failed. A workflow is currently active on the media package", responseCode=409), @RestResponse(description="Ingest failed. Something went wrong internally. Please have a look at the log files", responseCode=500)}, returnDescription="")
    public Response addMediaPackage(@Context HttpServletRequest request, @PathParam(value="wdID") String wdID) {
        logger.trace("add mediapackage as multipart-form-data with workflow definition id: {}", (Object)wdID);
        boolean flavorAlreadyUsed = false;
        MediaPackageElementFlavor flavor = null;
        ArrayList<String> tags = new ArrayList<String>();
        try {
            MediaPackage mp = this.ingestService.createMediaPackage();
            DublinCoreCatalog dcc = null;
            HashMap<String, String> workflowProperties = new HashMap<String, String>();
            int seriesDCCatalogNumber = 0;
            int episodeDCCatalogNumber = 0;
            boolean hasMedia = false;
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                block56: {
                    FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
                    while (iter.hasNext()) {
                        FileItemStream item = iter.next();
                        if (item.isFormField()) {
                            URI dcUrl;
                            String fieldName = item.getFieldName();
                            String value = Streams.asString((InputStream)item.openStream(), (String)"UTF-8");
                            logger.trace("form field {}: {}", (Object)fieldName, (Object)value);
                            if ("".equals(value)) continue;
                            if ("flavor".equals(fieldName)) {
                                try {
                                    flavor = MediaPackageElementFlavor.parseFlavor((String)value);
                                    flavorAlreadyUsed = false;
                                    continue;
                                }
                                catch (IllegalArgumentException e) {
                                    return this.badRequest(String.format("Could not parse flavor '%s'", value), e);
                                }
                            }
                            if ("tag".equals(fieldName)) {
                                tags.add(value);
                                continue;
                            }
                            if (dcterms.contains(fieldName)) {
                                if ("identifier".equals(fieldName)) {
                                    mp.setIdentifier((Id)new IdImpl(value));
                                }
                                if (dcc == null) {
                                    dcc = this.dublinCoreService.newInstance();
                                }
                                dcc.add(new EName("http://purl.org/dc/terms/", fieldName), value);
                                continue;
                            }
                            if ("episodeDCCatalogUri".equals(fieldName)) {
                                try {
                                    dcUrl = new URI(value);
                                    this.ingestService.addCatalog(dcUrl, MediaPackageElements.EPISODE, null, mp);
                                    this.updateMediaPackageID(mp, dcUrl);
                                    ++episodeDCCatalogNumber;
                                    continue;
                                }
                                catch (URISyntaxException e) {
                                    return this.badRequest(String.format("Invalid URI %s for episodeDCCatalogUri", value), e);
                                }
                                catch (Exception e) {
                                    return this.badRequest("Could not parse XML Dublin Core catalog", e);
                                }
                            }
                            if ("episodeDCCatalog".equals(fieldName)) {
                                try {
                                    ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
                                    try {
                                        String fileName = "episode-" + episodeDCCatalogNumber + ".xml";
                                        this.ingestService.addCatalog((InputStream)is, fileName, MediaPackageElements.EPISODE, mp);
                                        ++episodeDCCatalogNumber;
                                        ((InputStream)is).reset();
                                        this.updateMediaPackageID(mp, is);
                                        continue;
                                    }
                                    finally {
                                        ((InputStream)is).close();
                                        continue;
                                    }
                                }
                                catch (Exception e) {
                                    return this.badRequest("Could not parse XML Dublin Core catalog", e);
                                }
                            }
                            if ("seriesDCCatalogUri".equals(fieldName)) {
                                try {
                                    dcUrl = new URI(value);
                                    this.ingestService.addCatalog(dcUrl, MediaPackageElements.SERIES, null, mp);
                                    continue;
                                }
                                catch (URISyntaxException e) {
                                    return this.badRequest(String.format("Invalid URI %s for episodeDCCatalogUri", value), e);
                                }
                                catch (Exception e) {
                                    return this.badRequest("Could not parse XML Dublin Core catalog", e);
                                }
                            }
                            if ("seriesDCCatalog".equals(fieldName)) {
                                String fileName = "series-" + seriesDCCatalogNumber + ".xml";
                                ++seriesDCCatalogNumber;
                                try {
                                    ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
                                    try {
                                        this.ingestService.addCatalog((InputStream)is, fileName, MediaPackageElements.SERIES, mp);
                                        continue;
                                    }
                                    finally {
                                        ((InputStream)is).close();
                                        continue;
                                    }
                                }
                                catch (Exception e) {
                                    return this.badRequest("Could not parse XML Dublin Core catalog", e);
                                }
                            }
                            if ("acl".equals(fieldName)) {
                                ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
                                try {
                                    AccessControlList acl = AccessControlParser.parseAcl((InputStream)inputStream);
                                    inputStream = new ByteArrayInputStream(XACMLUtils.getXacml((MediaPackage)mp, (AccessControlList)acl).getBytes(StandardCharsets.UTF_8));
                                }
                                catch (AccessControlParsingException e) {
                                    logger.debug("Unable to parse ACL, guessing that this is already XACML");
                                    ((InputStream)inputStream).reset();
                                }
                                this.ingestService.addAttachment((InputStream)inputStream, "episode-security.xml", MediaPackageElements.XACML_POLICY_EPISODE, mp);
                                continue;
                            }
                            if ("mediaUri".equals(fieldName)) {
                                URI mediaUrl;
                                if (flavor == null) {
                                    return this.badRequest("A flavor has to be specified in the request prior to the media file", null);
                                }
                                try {
                                    mediaUrl = new URI(value);
                                }
                                catch (URISyntaxException e) {
                                    return this.badRequest(String.format("Invalid URI %s for media", value), e);
                                }
                                this.warnIfFlavorAlreadyUsed(flavorAlreadyUsed);
                                this.ingestService.addTrack(mediaUrl, flavor, tags.toArray(new String[0]), mp);
                                flavorAlreadyUsed = true;
                                tags.clear();
                                hasMedia = true;
                                continue;
                            }
                            workflowProperties.put(fieldName, value);
                            continue;
                        }
                        if (flavor == null) {
                            return this.badRequest("A flavor has to be specified in the request prior to the content BODY", null);
                        }
                        this.warnIfFlavorAlreadyUsed(flavorAlreadyUsed);
                        this.ingestService.addTrack(item.openStream(), item.getName(), flavor, tags.toArray(new String[0]), mp);
                        flavorAlreadyUsed = true;
                        tags.clear();
                        hasMedia = true;
                    }
                    if (!hasMedia) {
                        return this.badRequest("Rejected ingest without actual media.", null);
                    }
                    if (dcc != null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        try {
                            dcc.toXml((OutputStream)out, true);
                            try (ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());){
                                this.ingestService.addCatalog((InputStream)in, "dublincore.xml", MediaPackageElements.EPISODE, mp);
                                break block56;
                            }
                        }
                        catch (Exception e) {
                            return this.badRequest("Could not create XML from ingested metadata", e);
                        }
                    }
                    if (episodeDCCatalogNumber == 0) {
                        return this.badRequest("Rejected ingest without episode metadata. At least provide a title.", null);
                    }
                }
                WorkflowInstance workflow = wdID == null ? this.ingestService.ingest(mp) : this.ingestService.ingest(mp, wdID, workflowProperties);
                return Response.ok((Object)new JaxbWorkflowInstance(workflow)).build();
            }
            return Response.serverError().status(Response.Status.BAD_REQUEST).build();
        }
        catch (IllegalArgumentException e) {
            return this.badRequest(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            logger.warn("Unable to add mediapackage", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Deprecated
    private void warnIfFlavorAlreadyUsed(boolean used) {
        if (used) {
            logger.warn("\n********************************************\n* Warning: Re-use of flavors during ingest *\n*          is deprecated and will be       *\n*          removed soon! Declare a flavor  *\n*          for each media file or create   *\n*          an issue if you need this.      *\n********************************************");
        }
    }

    private void updateMediaPackageID(MediaPackage mp, InputStream is) throws IOException {
        EName en;
        DublinCoreCatalog dc = DublinCores.read((InputStream)is);
        String id = dc.getFirst(en = new EName("http://purl.org/dc/terms/", "identifier"));
        if (id != null) {
            mp.setIdentifier((Id)new IdImpl(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMediaPackageID(MediaPackage mp, URI uri) throws IOException {
        InputStream in = null;
        HttpResponse response = null;
        try {
            if (uri.toString().startsWith("http")) {
                HttpGet get = new HttpGet(uri);
                response = this.httpClient.execute((HttpUriRequest)get);
                int httpStatusCode = response.getStatusLine().getStatusCode();
                if (httpStatusCode != 200) {
                    throw new IOException(String.valueOf(uri) + " returns http " + httpStatusCode);
                }
                in = response.getEntity().getContent();
            } else {
                in = uri.toURL().openStream();
            }
            this.updateMediaPackageID(mp, in);
            in.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            this.httpClient.close(response);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        this.httpClient.close(response);
    }

    @POST
    @Path(value="addZippedMediaPackage/{workflowDefinitionId}")
    @Produces(value={"text/xml"})
    @RestQuery(name="addZippedMediaPackage", description="Create media package from a compressed file containing a manifest.xml document and all media tracks, metadata catalogs and attachments", pathParameters={@RestParameter(description="Workflow definition id", isRequired=true, name="workflowDefinitionId", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The workflow instance ID to associate with this zipped mediapackage", isRequired=false, name="workflowInstanceId", type=RestParameter.Type.STRING)}, bodyParameter=@RestParameter(description="The compressed (application/zip) media package file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="", responseCode=200), @RestResponse(description="", responseCode=400), @RestResponse(description="", responseCode=404), @RestResponse(description="", responseCode=503)}, returnDescription="")
    public Response addZippedMediaPackage(@Context HttpServletRequest request, @PathParam(value="workflowDefinitionId") String wdID, @QueryParam(value="id") String wiID) {
        logger.trace("add zipped media package with workflow definition id: {} and workflow instance id: {}", (Object)wdID, (Object)wiID);
        if (!this.isIngestLimitEnabled() || this.getIngestLimit() > 0) {
            return this.ingestZippedMediaPackage(request, wdID, wiID);
        }
        logger.warn("Delaying ingest because we have exceeded the maximum number of ingests this server is setup to do concurrently.");
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    @POST
    @Path(value="addZippedMediaPackage")
    @Produces(value={"text/xml"})
    @RestQuery(name="addZippedMediaPackage", description="Create media package from a compressed file containing a manifest.xml document and all media tracks, metadata catalogs and attachments", restParameters={@RestParameter(description="The workflow definition ID to run on this mediapackage. This parameter has to be set in the request prior to the zipped mediapackage (This parameter is deprecated. Please use /addZippedMediaPackage/{workflowDefinitionId} instead)", isRequired=false, name="workflowDefinitionId", type=RestParameter.Type.STRING), @RestParameter(description="The workflow instance ID to associate with this zipped mediapackage. This parameter has to be set in the request prior to the zipped mediapackage (This parameter is deprecated. Please use /addZippedMediaPackage/{workflowDefinitionId} with a path parameter instead)", isRequired=false, name="workflowInstanceId", type=RestParameter.Type.STRING)}, bodyParameter=@RestParameter(description="The compressed (application/zip) media package file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="", responseCode=200), @RestResponse(description="", responseCode=400), @RestResponse(description="", responseCode=404), @RestResponse(description="", responseCode=503)}, returnDescription="")
    public Response addZippedMediaPackage(@Context HttpServletRequest request) {
        logger.trace("add zipped media package");
        if (!this.isIngestLimitEnabled() || this.getIngestLimit() > 0) {
            return this.ingestZippedMediaPackage(request, null, null);
        }
        logger.warn("Delaying ingest because we have exceeded the maximum number of ingests this server is setup to do concurrently.");
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    /*
     * Exception decompiling
     */
    private Response ingestZippedMediaPackage(HttpServletRequest request, String wdID, String wiID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="ingest/{wdID}")
    @RestQuery(name="ingest", description="<p>Ingest the completed media package into the system and start a specified workflow.</p><p>In addition to the documented form parameters, workflow parameters are accepted as well.</p>", pathParameters={@RestParameter(description="Workflow definition id", isRequired=true, name="wdID", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Returns the workflow instance", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400)}, returnDescription="")
    public Response ingest(@Context HttpServletRequest request, @PathParam(value="wdID") String wdID) {
        logger.trace("ingest media package with workflow definition id: {}", (Object)wdID);
        if (StringUtils.isBlank((CharSequence)wdID)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return this.ingest(wdID, request);
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="ingest")
    @RestQuery(name="ingest", description="<p>Ingest the completed media package into the system</p><p>In addition to the documented form parameters, workflow parameters are accepted as well.</p>", restParameters={@RestParameter(description="The media package", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT), @RestParameter(description="Workflow definition id", isRequired=false, name="workflowDefinitionId", type=RestParameter.Type.STRING), @RestParameter(description="The workflow instance ID to associate this ingest with scheduled events.", isRequired=false, name="workflowInstanceId", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the workflow instance", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400)}, returnDescription="")
    public Response ingest(@Context HttpServletRequest request) {
        return this.ingest(null, request);
    }

    private Map<String, String> getWorkflowConfig(MultivaluedMap<String, String> formData) {
        HashMap<String, String> wfConfig = new HashMap<String, String>();
        for (String key : formData.keySet()) {
            if ("mediaPackage".equals(key)) continue;
            wfConfig.put(key, (String)formData.getFirst((Object)key));
        }
        return wfConfig;
    }

    private Response ingest(String wdID, HttpServletRequest request) {
        MediaPackage mp;
        MultivaluedHashMap formData = new MultivaluedHashMap();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    if (!item.isFormField()) continue;
                    String value = Streams.asString((InputStream)item.openStream(), (String)"UTF-8");
                    formData.putSingle((Object)item.getFieldName(), (Object)value);
                }
            }
            catch (IOException | FileUploadException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        } else {
            request.getParameterMap().forEach((arg_0, arg_1) -> IngestRestService.lambda$ingest$0((MultivaluedMap)formData, arg_0, arg_1));
        }
        final Map<String, String> wfConfig = this.getWorkflowConfig((MultivaluedMap<String, String>)formData);
        if (StringUtils.isNotBlank((CharSequence)wdID)) {
            wfConfig.put(WORKFLOW_DEFINITION_ID_PARAM, wdID);
        }
        try {
            mp = MP_FACTORY.newMediaPackageBuilder().loadFromXml((String)formData.getFirst((Object)"mediaPackage"));
            if (MediaPackageSupport.sanityCheck((MediaPackage)mp).isSome()) {
                logger.warn("Rejected ingest with invalid mediapackage {}", (Object)mp);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        catch (Exception e) {
            logger.warn("Rejected ingest without mediapackage");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        final String workflowInstance = wfConfig.get(WORKFLOW_INSTANCE_ID_PARAM);
        final String workflowDefinition = wfConfig.get(WORKFLOW_DEFINITION_ID_PARAM);
        Date ingestDate = (Date)this.startCache.getIfPresent((Object)mp.getIdentifier().toString());
        wfConfig.put("ingest_start_date", DATE_FORMAT.format(ingestDate != null ? ingestDate : new Date()));
        Function0.X<WorkflowInstance> ingest = new Function0.X<WorkflowInstance>(){

            public WorkflowInstance xapply() throws Exception {
                Long workflowInstanceId = null;
                if (StringUtils.isNotBlank((CharSequence)workflowInstance)) {
                    try {
                        workflowInstanceId = Long.parseLong(workflowInstance);
                    }
                    catch (NumberFormatException e) {
                        wfConfig.put("org.opencastproject.ingest.legacy.mediapackage.id", workflowInstance);
                    }
                }
                if (workflowInstanceId != null) {
                    return IngestRestService.this.ingestService.ingest(mp, StringUtils.trimToNull((String)workflowDefinition), wfConfig, workflowInstanceId);
                }
                return IngestRestService.this.ingestService.ingest(mp, StringUtils.trimToNull((String)workflowDefinition), wfConfig);
            }
        };
        try {
            WorkflowInstance workflow = (WorkflowInstance)ingest.apply();
            this.startCache.asMap().remove(mp.getIdentifier().toString());
            return Response.ok((Object)XmlWorkflowParser.toXml((WorkflowInstance)workflow)).build();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NotFoundException) {
                return this.badRequest("Could not retrieve all media package elements", e);
            }
            logger.warn("Unable to ingest mediapackage", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="schedule")
    @RestQuery(name="schedule", description="Schedule an event based on the given media package", restParameters={@RestParameter(description="The media package", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Event scheduled", responseCode=201), @RestResponse(description="Media package not valid", responseCode=400)}, returnDescription="")
    public Response schedule(MultivaluedMap<String, String> formData) {
        logger.trace("pass schedule with default workflow definition id {}", (Object)this.defaultWorkflowDefinitionId);
        return this.schedule(this.defaultWorkflowDefinitionId, formData);
    }

    @POST
    @Path(value="schedule/{wdID}")
    @RestQuery(name="schedule", description="Schedule an event based on the given media package", pathParameters={@RestParameter(description="Workflow definition id", isRequired=true, name="wdID", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The media package", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Event scheduled", responseCode=201), @RestResponse(description="Media package not valid", responseCode=400)}, returnDescription="")
    public Response schedule(@PathParam(value="wdID") String wdID, MultivaluedMap<String, String> formData) {
        if (StringUtils.isBlank((CharSequence)wdID)) {
            logger.trace("workflow definition id is not specified");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Map<String, String> wfConfig = this.getWorkflowConfig(formData);
        if (StringUtils.isNotBlank((CharSequence)wdID)) {
            wfConfig.put("org.opencastproject.workflow.definition", wdID);
        }
        logger.debug("Schedule with workflow definition '{}'", (Object)wfConfig.get(WORKFLOW_DEFINITION_ID_PARAM));
        String mediaPackageXml = (String)formData.getFirst((Object)"mediaPackage");
        if (StringUtils.isBlank((CharSequence)mediaPackageXml)) {
            logger.debug("Rejected schedule without media package");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        MediaPackage mp = null;
        try {
            mp = MP_FACTORY.newMediaPackageBuilder().loadFromXml(mediaPackageXml);
            if (MediaPackageSupport.sanityCheck((MediaPackage)mp).isSome()) {
                throw new MediaPackageException("Insane media package");
            }
        }
        catch (MediaPackageException e) {
            logger.debug("Rejected ingest with invalid media package {}", (Object)mp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        MediaPackageElement[] mediaPackageElements = mp.getElementsByFlavor(MediaPackageElements.EPISODE);
        if (mediaPackageElements.length != 1) {
            logger.debug("There can be only one (and exactly one) episode dublin core catalog: https://youtu.be/_J3VeogFUOs");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.ingestService.schedule(mp, wdID, wfConfig);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IngestException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (SchedulerConflictException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (SchedulerException | UnauthorizedException | NotFoundException e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="addDCCatalog")
    @RestQuery(name="addDCCatalog", description="Add a dublincore episode catalog to a given media package using an url", restParameters={@RestParameter(description="The media package as XML", isRequired=true, name="mediaPackage", type=RestParameter.Type.TEXT), @RestParameter(description="DublinCore catalog as XML", isRequired=true, name="dublinCore", type=RestParameter.Type.TEXT), @RestParameter(defaultValue="dublincore/episode", description="DublinCore Flavor", isRequired=false, name="flavor", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns augmented media package", responseCode=200), @RestResponse(description="Media package not valid", responseCode=400), @RestResponse(description="", responseCode=500)}, returnDescription="")
    public Response addDCCatalog(@FormParam(value="mediaPackage") String mp, @FormParam(value="dublinCore") String dc, @FormParam(value="flavor") String flavor) {
        MediaPackage mediaPackage;
        logger.trace("add DC catalog: {} with flavor: {} to media package: {}", new Object[]{dc, flavor, mp});
        MediaPackageElementFlavor dcFlavor = MediaPackageElements.EPISODE;
        if (flavor != null) {
            try {
                dcFlavor = MediaPackageElementFlavor.parseFlavor((String)flavor);
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        try {
            mediaPackage = MediaPackageBuilderFactory.newInstance().newMediaPackageBuilder().loadFromXml(mp);
        }
        catch (MediaPackageException e) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).build();
        }
        if (MediaPackageSupport.sanityCheck((MediaPackage)mediaPackage).isSome()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            DublinCoreXmlFormat.read((String)dc);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        try (InputStream in = IOUtils.toInputStream((String)dc, (String)"UTF-8");){
            mediaPackage = this.ingestService.addCatalog(in, "dublincore.xml", dcFlavor, mediaPackage);
        }
        catch (MediaPackageException e) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (IOException e) {
            logger.error("Could not write catalog to disk", (Throwable)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            logger.error("Unable to add catalog", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok((Object)mediaPackage).build();
    }

    private Response badRequest(String message, Exception e) {
        logger.debug(message, e == null && logger.isDebugEnabled() ? new IngestException(message) : e);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    public JobProducer getService() {
        return this.ingestService;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    void setIngestService(IngestService ingestService) {
        this.ingestService = ingestService;
    }

    @Reference
    void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    void setDublinCoreService(DublinCoreCatalogService dcService) {
        this.dublinCoreService = dcService;
    }

    @Reference
    public void setHttpClient(TrustedHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private static /* synthetic */ void lambda$ingest$0(MultivaluedMap formData, String key, String[] value) {
        formData.put((Object)key, Arrays.asList(value));
    }
}

