/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.util;

import java.io.File;

public class Paths {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String normalize(String path) {
        return Paths.normalize(path, File.separatorChar);
    }

    public static String normalize(String path, char separatorChar) {
        String result;
        int bufferLen;
        int prefixLen = Paths.prefixLength(path, separatorChar);
        int pathLen = path.length();
        StringBuffer buffer = new StringBuffer(pathLen);
        Paths.normalize(path.substring(prefixLen, pathLen), separatorChar, 0, pathLen - prefixLen, buffer);
        buffer.insert(0, path.substring(0, prefixLen));
        if (buffer.length() == prefixLen && (prefixLen <= 0 || buffer.charAt(prefixLen - 1) != separatorChar)) {
            buffer.append('.');
        }
        if (pathLen > 0 && path.charAt(pathLen - 1) == separatorChar && buffer.charAt(buffer.length() - 1) != separatorChar) {
            buffer.append(separatorChar);
        }
        if ((bufferLen = buffer.length()) == path.length()) {
            if (!$assertionsDisabled && !path.equals(buffer.toString())) {
                throw new AssertionError();
            }
            result = path;
        } else {
            result = buffer.toString();
            if (path.startsWith(result)) {
                result = path.substring(0, bufferLen);
            }
        }
        if (!$assertionsDisabled && result.equals(path) && result != path) {
            throw new AssertionError();
        }
        return result;
    }

    private static int normalize(String path, char separatorChar, int collapse, int end, StringBuffer buffer) {
        int bufferLen;
        int notCollapsed;
        if (!$assertionsDisabled && collapse < 0) {
            throw new AssertionError();
        }
        if (0 >= end) {
            return collapse;
        }
        int next = path.lastIndexOf(separatorChar, end - 1);
        String base = path.substring(next + 1, end);
        if (0 >= base.length() || ".".equals(base)) {
            return Paths.normalize(path, separatorChar, collapse, next, buffer);
        }
        if ("..".equals(base)) {
            notCollapsed = Paths.normalize(path, separatorChar, collapse + 1, next, buffer) - 1;
            if (0 > notCollapsed) {
                return 0;
            }
        } else {
            if (0 < collapse) {
                return Paths.normalize(path, separatorChar, collapse - 1, next, buffer);
            }
            if (!$assertionsDisabled && 0 != collapse) {
                throw new AssertionError();
            }
            notCollapsed = Paths.normalize(path, separatorChar, 0, next, buffer);
            if (!$assertionsDisabled && 0 != notCollapsed) {
                throw new AssertionError();
            }
        }
        if ((bufferLen = buffer.length()) > 0) {
            buffer.append(separatorChar);
        }
        buffer.append(base);
        return notCollapsed;
    }

    public static String cutTrailingSeparators(String path, char separatorChar) {
        int i = path.length();
        if (i <= 0 || path.charAt(--i) != separatorChar) {
            return path;
        }
        while (i > 0 && path.charAt(--i) == separatorChar) {
        }
        return path.substring(0, ++i);
    }

    public static final String cutTrailingSeparator(String path, char separatorChar) {
        int pathEnd = path.length() - 1;
        if (pathEnd > 0 && path.charAt(pathEnd) == separatorChar) {
            return path.substring(0, pathEnd);
        }
        return path;
    }

    public static String[] split(String path) {
        return Paths.split(path, File.separatorChar);
    }

    public static String[] split(String path, char separatorChar) {
        return Paths.split(path, separatorChar, new String[2]);
    }

    public static String[] split(String path, char separatorChar, String[] result) {
        int prefixLen = Paths.prefixLength(path, separatorChar);
        int baseBegin = -1;
        int baseEnd = path.length() - 1;
        if (prefixLen <= baseEnd) {
            baseEnd = Paths.lastIndexNot(path, separatorChar, baseEnd);
            baseBegin = path.lastIndexOf(separatorChar, baseEnd);
        }
        ++baseEnd;
        if (baseBegin >= prefixLen) {
            int parentEnd = Paths.lastIndexNot(path, separatorChar, baseBegin) + 1;
            result[0] = path.substring(0, parentEnd > prefixLen ? parentEnd : prefixLen);
            result[1] = path.substring(baseBegin + 1, baseEnd);
        } else {
            result[0] = 0 < prefixLen && prefixLen < baseEnd ? path.substring(0, prefixLen) : null;
            result[1] = path.substring(prefixLen, baseEnd);
        }
        return result;
    }

    private static int lastIndexNot(String path, char separatorChar, int last) {
        while (path.charAt(last) == separatorChar && --last >= 0) {
        }
        return last;
    }

    private static int prefixLength(String path, char separatorChar) {
        char drive;
        int pathLen = path.length();
        int len = 0;
        if (pathLen > 0 && path.charAt(0) == separatorChar) {
            ++len;
        } else if (pathLen > 1 && path.charAt(1) == ':' && ('A' <= (drive = path.charAt(0)) && drive <= 'Z' || 'a' <= drive && drive <= 'z')) {
            len = 2;
        }
        if (pathLen > len && path.charAt(len) == separatorChar) {
            ++len;
        }
        return len;
    }

    protected Paths() {
    }

    static {
        $assertionsDisabled = !Paths.class.desiredAssertionStatus();
    }
}

