/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.util;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    private final byte[] buf = new byte[8];
    protected volatile long written;

    public LEDataOutputStream(OutputStream out) {
        super(out);
    }

    private void incCount(int inc) {
        long temp = this.written + (long)inc;
        this.written = temp >= 0L ? temp : Long.MAX_VALUE;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    public final void writeBoolean(boolean b) throws IOException {
        this.out.write(b ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    public final void writeChar(int c) throws IOException {
        this.writeShort(c);
    }

    public final void writeShort(int s) throws IOException {
        this.buf[0] = (byte)s;
        this.buf[1] = (byte)(s >>= 8);
        this.out.write(this.buf, 0, 2);
        this.incCount(2);
    }

    public final void writeInt(int i) throws IOException {
        this.buf[0] = (byte)i;
        this.buf[1] = (byte)(i >>= 8);
        this.buf[2] = (byte)(i >>= 8);
        this.buf[3] = (byte)(i >>= 8);
        this.out.write(this.buf, 0, 4);
        this.incCount(4);
    }

    public final void writeLong(long l) throws IOException {
        this.buf[0] = (byte)l;
        this.buf[1] = (byte)(l >>= 8);
        this.buf[2] = (byte)(l >>= 8);
        this.buf[3] = (byte)(l >>= 8);
        this.buf[4] = (byte)(l >>= 8);
        this.buf[5] = (byte)(l >>= 8);
        this.buf[6] = (byte)(l >>= 8);
        this.buf[7] = (byte)(l >>= 8);
        this.out.write(this.buf, 0, 8);
        this.incCount(8);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
    }

    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeShort(s.charAt(i));
        }
    }

    public void writeUTF(String str) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final long size() {
        return this.written;
    }
}

