/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingest.impl;

import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectInstance;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.opencastproject.authorization.xacml.XACMLParsingException;
import org.opencastproject.authorization.xacml.XACMLUtils;
import org.opencastproject.ingest.api.IngestException;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.ingest.impl.ZipEntryInputStream;
import org.opencastproject.ingest.impl.jmx.IngestStatistics;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.identifier.Id;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreCatalogService;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.smil.api.util.SmilUtil;
import org.opencastproject.userdirectory.UserIdRoleProvider;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.JobUtil;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.ProgressInputStream;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.util.XmlUtil;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Misc;
import org.opencastproject.util.jmx.JmxUtil;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workingfilerepository.api.WorkingFileRepository;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Component(immediate=true, service={IngestService.class, ManagedService.class}, property={"service.description=Ingest Service", "service.pid=org.opencastproject.ingest.impl.IngestServiceImpl"})
public class IngestServiceImpl
extends AbstractJobProducer
implements IngestService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(IngestServiceImpl.class);
    private static final String PARTIAL_SMIL_NAME = "source_partial.smil";
    protected static final String WORKFLOW_DEFINITION_DEFAULT = "org.opencastproject.workflow.default.definition";
    protected static final String WORKFLOW_CONFIGURATION_PREFIX = "org.opencastproject.workflow.config.";
    public static final String LEGACY_MEDIAPACKAGE_ID_KEY = "org.opencastproject.ingest.legacy.mediapackage.id";
    public static final String JOB_TYPE = "org.opencastproject.ingest";
    public static final String INGEST_ZIP = "zip";
    public static final String INGEST_TRACK = "track";
    public static final String INGEST_TRACK_FROM_URI = "uri-track";
    public static final String INGEST_ATTACHMENT = "attachment";
    public static final String INGEST_ATTACHMENT_FROM_URI = "uri-attachment";
    public static final String INGEST_CATALOG = "catalog";
    public static final String INGEST_CATALOG_FROM_URI = "uri-catalog";
    public static final float DEFAULT_INGEST_FILE_JOB_LOAD = 0.2f;
    public static final float DEFAULT_INGEST_ZIP_JOB_LOAD = 0.2f;
    public static final String FILE_JOB_LOAD_KEY = "job.load.ingest.file";
    public static final String ZIP_JOB_LOAD_KEY = "job.load.ingest.zip";
    public static final String DOWNLOAD_SOURCE = "org.opencastproject.download.source";
    public static final String DOWNLOAD_USER = "org.opencastproject.download.user";
    public static final String DOWNLOAD_PASSWORD = "org.opencastproject.download.password";
    public static final String DOWNLOAD_AUTH_METHOD = "org.opencastproject.download.auth.method";
    public static final String DOWNLOAD_AUTH_FORCE_BASIC = "org.opencastproject.download.auth.force_basic";
    public static final boolean DEFAULT_ALLOW_SERIES_MODIFICATIONS = false;
    public static final boolean DEFAULT_ALLOW_ONLY_NEW_FLAVORS = true;
    public static final boolean DEFAULT_SKIP = false;
    public static final boolean DEFAULT_DOWNLOAD_AUTH_FORCE_BASIC = false;
    public static final int FILENAME_LENGTH_MAX = 75;
    @Deprecated
    public static final String MODIFY_OPENCAST_SERIES_KEY = "org.opencastproject.series.overwrite";
    public static final String ADD_ONLY_NEW_FLAVORS_KEY = "add.only.new.catalogs.attachments.for.existing.events";
    public static final String SKIP_CATALOGS_KEY = "skip.catalogs.for.existing.events";
    public static final String SKIP_ATTACHMENTS_KEY = "skip.attachments.for.existing.events";
    private static final String SERIES_APPENDIX = "add.series.to.event.appendix";
    private float ingestFileJobLoad = 0.2f;
    private float ingestZipJobLoad = 0.2f;
    private static String downloadUser = "org.opencastproject.download.user";
    private static String downloadPassword = "org.opencastproject.download.password";
    private static String downloadAuthMethod = "org.opencastproject.download.auth.method";
    private static boolean downloadAuthForceBasic = false;
    private static String downloadSource = "org.opencastproject.download.source";
    private IngestStatistics ingestStatistics = new IngestStatistics();
    private ObjectInstance registerMXBean;
    private WorkflowService workflowService;
    private WorkingFileRepository workingFileRepository;
    private TrustedHttpClient httpClient;
    private SeriesService seriesService;
    private DublinCoreCatalogService dublinCoreService;
    private ServiceRegistry serviceRegistry;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    private SchedulerService schedulerService = null;
    private MediaInspectionService mediaInspectionService = null;
    protected String defaultWorkflowDefinionId;
    private Cache<String, Long> partialTrackStartTimes = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();
    protected boolean isAddOnlyNew = true;
    protected boolean isAllowModifySeries = false;
    private boolean skipCatalogs = false;
    private boolean skipAttachments = false;
    private String createSeriesAppendix = null;
    protected boolean testMode = false;

    public IngestServiceImpl() {
        super(JOB_TYPE);
    }

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Ingest Service started.");
        this.defaultWorkflowDefinionId = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(WORKFLOW_DEFINITION_DEFAULT));
        if (this.defaultWorkflowDefinionId == null) {
            this.defaultWorkflowDefinionId = "schedule-and-upload";
        }
        this.registerMXBean = JmxUtil.registerMXBean((Object)this.ingestStatistics, (String)"IngestStatistics");
    }

    @Deactivate
    public void deactivate() {
        JmxUtil.unregisterMXBean((ObjectInstance)this.registerMXBean);
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            logger.info("No configuration available, using defaults");
            return;
        }
        downloadAuthMethod = StringUtils.trimToEmpty((String)((String)properties.get(DOWNLOAD_AUTH_METHOD)));
        if (!"Digest".equals(downloadAuthMethod) && !"Basic".equals(downloadAuthMethod)) {
            logger.warn("Download authentication method is neither Digest nor Basic; setting to Digest");
            downloadAuthMethod = "Digest";
        }
        downloadAuthForceBasic = BooleanUtils.toBoolean((String)Objects.toString(properties.get(DOWNLOAD_AUTH_FORCE_BASIC), BooleanUtils.toStringTrueFalse((boolean)false)));
        downloadPassword = StringUtils.trimToEmpty((String)((String)properties.get(DOWNLOAD_PASSWORD)));
        downloadUser = StringUtils.trimToEmpty((String)((String)properties.get(DOWNLOAD_USER)));
        downloadSource = StringUtils.trimToEmpty((String)((String)properties.get(DOWNLOAD_SOURCE)));
        if (!StringUtils.isBlank((CharSequence)downloadSource) && (StringUtils.isBlank((CharSequence)downloadUser) || StringUtils.isBlank((CharSequence)downloadPassword))) {
            logger.warn("Configured ingest download source has no configured user or password; deactivating authenticateddownload");
            downloadSource = "";
        }
        this.skipAttachments = BooleanUtils.toBoolean((String)Objects.toString(properties.get(SKIP_ATTACHMENTS_KEY), BooleanUtils.toStringTrueFalse((boolean)false)));
        this.skipCatalogs = BooleanUtils.toBoolean((String)Objects.toString(properties.get(SKIP_CATALOGS_KEY), BooleanUtils.toStringTrueFalse((boolean)false)));
        logger.debug("Skip attachments sent by agents for scheduled events: {}", (Object)this.skipAttachments);
        logger.debug("Skip metadata catalogs sent by agents for scheduled events: {}", (Object)this.skipCatalogs);
        this.ingestFileJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)FILE_JOB_LOAD_KEY, (Float)Float.valueOf(0.2f), (ServiceRegistry)this.serviceRegistry);
        this.ingestZipJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)ZIP_JOB_LOAD_KEY, (Float)Float.valueOf(0.2f), (ServiceRegistry)this.serviceRegistry);
        this.isAllowModifySeries = BooleanUtils.toBoolean((String)Objects.toString(properties.get(MODIFY_OPENCAST_SERIES_KEY), BooleanUtils.toStringTrueFalse((boolean)false)));
        this.isAddOnlyNew = BooleanUtils.toBoolean((String)Objects.toString(properties.get(ADD_ONLY_NEW_FLAVORS_KEY), BooleanUtils.toStringTrueFalse((boolean)true)));
        logger.info("Only allow new flavored catalogs and attachments on ingest:'{}'", (Object)this.isAddOnlyNew);
        logger.info("Allowing series modification:'{}'", (Object)this.isAllowModifySeries);
        this.createSeriesAppendix = StringUtils.trimToNull((String)((String)properties.get(SERIES_APPENDIX)));
    }

    @Reference
    public void setHttpClient(TrustedHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setMediaInspectionService(MediaInspectionService mediaInspectionService) {
        this.mediaInspectionService = mediaInspectionService;
    }

    public WorkflowInstance addZippedMediaPackage(InputStream zipStream) throws IngestException, IOException, MediaPackageException {
        try {
            return this.addZippedMediaPackage(zipStream, null, null);
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("A not found exception was thrown without a lookup");
        }
    }

    public WorkflowInstance addZippedMediaPackage(InputStream zipStream, String wd, Map<String, String> workflowConfig) throws MediaPackageException, IOException, IngestException, NotFoundException {
        try {
            return this.addZippedMediaPackage(zipStream, wd, workflowConfig, null);
        }
        catch (UnauthorizedException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkflowInstance addZippedMediaPackage(InputStream zipStream, String workflowDefinitionId, Map<String, String> workflowConfig, Long workflowInstanceId) throws MediaPackageException, IOException, IngestException, NotFoundException, UnauthorizedException {
        WorkflowInstance workflowInstance;
        Job job = null;
        if (StringUtils.isNotBlank((CharSequence)workflowDefinitionId)) {
            try {
                this.workflowService.getWorkflowDefinitionById(workflowDefinitionId);
            }
            catch (WorkflowDatabaseException e) {
                throw new IngestException((Throwable)e);
            }
            catch (NotFoundException nfe) {
                logger.warn("Workflow definition {} not found, using default workflow {} instead", (Object)workflowDefinitionId, (Object)this.defaultWorkflowDefinionId);
                workflowDefinitionId = this.defaultWorkflowDefinionId;
            }
        }
        if (workflowInstanceId != null) {
            logger.warn("Deprecated method! Ingesting zipped mediapackage with workflow {}", (Object)workflowInstanceId);
        } else {
            logger.info("Ingesting zipped mediapackage");
        }
        ZipArchiveInputStream zis = null;
        HashSet<CallSite> collectionFilenames = new HashSet<CallSite>();
        try {
            Object contentUri;
            ZipArchiveEntry entry;
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_ZIP, null, null, false, Float.valueOf(this.ingestZipJobLoad));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String wfrCollectionId = Long.toString(job.getId());
            zis = new ZipArchiveInputStream(zipStream);
            MediaPackage mp = null;
            HashMap<String, Object> uris = new HashMap<String, Object>();
            int seq = 1;
            String folderName = null;
            boolean hasRootFolder = true;
            while ((entry = zis.getNextZipEntry()) != null) {
                try {
                    if (entry.isDirectory() || entry.getName().contains("__MACOSX")) continue;
                    if (entry.getName().endsWith("manifest.xml") || entry.getName().endsWith("index.xml")) {
                        ZipEntryInputStream is = new ZipEntryInputStream((InputStream)zis, entry.getSize());
                        mp = MediaPackageParser.getFromXml((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                        continue;
                    }
                    logger.info("Storing zip entry {}/{} in working file repository collection '{}'", new Object[]{job.getId(), entry.getName(), wfrCollectionId});
                    String fileName = FilenameUtils.getBaseName((String)entry.getName()) + "_" + seq++ + "." + FilenameUtils.getExtension((String)entry.getName());
                    contentUri = this.workingFileRepository.putInCollection(wfrCollectionId, fileName, (InputStream)new ZipEntryInputStream((InputStream)zis, entry.getSize()));
                    collectionFilenames.add((CallSite)((Object)fileName));
                    String key = entry.getName();
                    uris.put(key, contentUri);
                    this.ingestStatistics.add(entry.getSize());
                    logger.info("Zip entry {}/{} stored at {}", new Object[]{job.getId(), entry.getName(), contentUri});
                    int pos = entry.getName().indexOf(47);
                    if (pos == -1) {
                        hasRootFolder = false;
                        continue;
                    }
                    if (hasRootFolder && folderName != null && !folderName.equals(entry.getName().substring(0, pos))) {
                        hasRootFolder = false;
                        continue;
                    }
                    if (folderName != null) continue;
                    folderName = entry.getName().substring(0, pos);
                }
                catch (IOException e) {
                    logger.warn("Unable to process zip entry {}: {}", (Object)entry.getName(), (Object)e);
                    throw e;
                }
            }
            if (mp == null) {
                throw new MediaPackageException("No manifest found in this zip");
            }
            if (mp.getIdentifier() == null || StringUtils.isBlank((CharSequence)mp.getIdentifier().toString())) {
                mp.setIdentifier(IdImpl.fromUUID());
            }
            String mediaPackageId = mp.getIdentifier().toString();
            logger.info("Ingesting mediapackage {} is named '{}'", (Object)mediaPackageId, (Object)mp.getTitle());
            if (mp.getTracks().length == 0) {
                logger.warn("Mediapackage {} has no media tracks", (Object)mediaPackageId);
            }
            contentUri = mp.elements().iterator();
            while (contentUri.hasNext()) {
                MediaPackageElement element;
                URI uri = (URI)uris.get((String)(hasRootFolder ? folderName + "/" : "") + (element = (MediaPackageElement)contentUri.next()).getURI().toString());
                if (uri == null) {
                    throw new MediaPackageException("Unable to map element name '" + element.getURI() + "' to workspace uri");
                }
                logger.info("Ingested mediapackage element {}/{} located at {}", new Object[]{mediaPackageId, element.getIdentifier(), uri});
                URI uRI = this.workingFileRepository.moveTo(wfrCollectionId, FilenameUtils.getName((String)uri.toString()), mediaPackageId, element.getIdentifier(), FilenameUtils.getName((String)element.getURI().toString()));
                element.setURI(uRI);
            }
            logger.info("Initiating processing of ingested mediapackage {}", (Object)mediaPackageId);
            WorkflowInstance workflowInstance2 = this.ingest(mp, workflowDefinitionId, workflowConfig, workflowInstanceId);
            logger.info("Ingest of mediapackage {} done", (Object)mediaPackageId);
            job.setStatus(Job.Status.FINISHED);
            workflowInstance = workflowInstance2;
        }
        catch (ServiceRegistryException e) {
            try {
                throw new IngestException((Throwable)e);
                catch (MediaPackageException e2) {
                    job.setStatus(Job.Status.FAILED, Job.FailureReason.DATA);
                    throw e2;
                }
                catch (Exception e3) {
                    if (e3 instanceof IngestException) {
                        throw (IngestException)((Object)e3);
                    }
                    throw new IngestException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zis);
                this.finallyUpdateJob(job);
                Iterator iterator = collectionFilenames.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    String string = (String)iterator.next();
                    this.workingFileRepository.deleteFromCollection(Long.toString(job.getId()), string, true);
                }
            }
        }
        IOUtils.closeQuietly((InputStream)zis);
        this.finallyUpdateJob(job);
        Iterator iterator = collectionFilenames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.workingFileRepository.deleteFromCollection(Long.toString(job.getId()), string, true);
        }
        return workflowInstance;
    }

    public MediaPackage createMediaPackage() throws MediaPackageException, ConfigurationException {
        MediaPackage mediaPackage;
        try {
            mediaPackage = MediaPackageBuilderFactory.newInstance().newMediaPackageBuilder().createNew();
        }
        catch (MediaPackageException e) {
            logger.error("INGEST:Failed to create media package " + e.getLocalizedMessage());
            throw e;
        }
        mediaPackage.setDate(new Date());
        logger.info("Created mediapackage {}", (Object)mediaPackage);
        return mediaPackage;
    }

    public MediaPackage createMediaPackage(String mediaPackageId) throws MediaPackageException, ConfigurationException {
        MediaPackage mediaPackage;
        try {
            mediaPackage = MediaPackageBuilderFactory.newInstance().newMediaPackageBuilder().createNew((Id)new IdImpl(mediaPackageId));
        }
        catch (MediaPackageException e) {
            logger.error("INGEST:Failed to create media package " + e.getLocalizedMessage());
            throw e;
        }
        mediaPackage.setDate(new Date());
        logger.info("Created mediapackage {}", (Object)mediaPackage);
        return mediaPackage;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaPackage addTrack(URI uri, MediaPackageElementFlavor flavor, String[] tags, MediaPackage mediaPackage) throws IOException, IngestException {
        MediaPackage mediaPackage2;
        Job job = null;
        try {
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_TRACK_FROM_URI, Arrays.asList(uri.toString(), flavor == null ? null : flavor.toString(), MediaPackageParser.getAsXml((MediaPackage)mediaPackage)), null, false, Float.valueOf(this.ingestFileJobLoad));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String elementId = UUID.randomUUID().toString();
            logger.info("Start adding track {} from URL {} on mediapackage {}", new Object[]{elementId, uri, mediaPackage});
            URI newUrl = this.addContentToRepo(mediaPackage, elementId, uri);
            MediaPackage mp = this.addContentToMediaPackage(mediaPackage, elementId, newUrl, MediaPackageElement.Type.Track, flavor);
            if (tags != null && tags.length > 0) {
                Track trackElement = mp.getTrack(elementId);
                for (String tag : tags) {
                    logger.info("Adding tag: " + tag + " to Element: " + elementId);
                    trackElement.addTag(tag);
                }
            }
            job.setStatus(Job.Status.FINISHED);
            logger.info("Successful added track {} on mediapackage {} at URL {}", new Object[]{elementId, mediaPackage, newUrl});
            mediaPackage2 = mp;
        }
        catch (IOException e) {
            try {
                throw e;
                catch (ServiceRegistryException e2) {
                    throw new IngestException((Throwable)e2);
                }
                catch (NotFoundException e3) {
                    throw new IngestException("Unable to update ingest job", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return mediaPackage2;
    }

    public MediaPackage addTrack(InputStream in, String fileName, MediaPackageElementFlavor flavor, MediaPackage mediaPackage) throws IOException, IngestException {
        String[] tags = null;
        return this.addTrack(in, fileName, flavor, tags, mediaPackage);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaPackage addTrack(InputStream in, String fileName, MediaPackageElementFlavor flavor, String[] tags, MediaPackage mediaPackage) throws IOException, IngestException {
        MediaPackage mediaPackage2;
        Job job = null;
        try {
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_TRACK, null, null, false, Float.valueOf(this.ingestFileJobLoad));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String elementId = UUID.randomUUID().toString();
            logger.info("Start adding track {} from input stream on mediapackage {}", (Object)elementId, (Object)mediaPackage);
            if (((String)fileName).length() > 75) {
                String extension = "." + FilenameUtils.getExtension((String)fileName);
                int length = Math.max(0, 75 - extension.length());
                fileName = ((String)fileName).substring(0, length) + extension;
            }
            URI newUrl = this.addContentToRepo(mediaPackage, elementId, (String)fileName, in);
            MediaPackage mp = this.addContentToMediaPackage(mediaPackage, elementId, newUrl, MediaPackageElement.Type.Track, flavor);
            if (tags != null && tags.length > 0) {
                Track trackElement = mp.getTrack(elementId);
                for (String tag : tags) {
                    logger.debug("Adding tag `{}` to element {}", (Object)tag, (Object)elementId);
                    trackElement.addTag(tag);
                }
            }
            job.setStatus(Job.Status.FINISHED);
            logger.info("Successful added track {} on mediapackage {} at URL {}", new Object[]{elementId, mediaPackage, newUrl});
            mediaPackage2 = mp;
        }
        catch (IOException e) {
            try {
                throw e;
                catch (ServiceRegistryException e2) {
                    throw new IngestException((Throwable)e2);
                }
                catch (NotFoundException e3) {
                    throw new IngestException("Unable to update ingest job", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return mediaPackage2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaPackage addPartialTrack(URI uri, MediaPackageElementFlavor flavor, long startTime, MediaPackage mediaPackage) throws IOException, IngestException {
        MediaPackage mediaPackage2;
        Job job = null;
        try {
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_TRACK_FROM_URI, Arrays.asList(uri.toString(), flavor == null ? null : flavor.toString(), MediaPackageParser.getAsXml((MediaPackage)mediaPackage)), null, false);
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String elementId = UUID.randomUUID().toString();
            logger.info("Start adding partial track {} from URL {} on mediapackage {}", new Object[]{elementId, uri, mediaPackage});
            URI newUrl = this.addContentToRepo(mediaPackage, elementId, uri);
            MediaPackage mp = this.addContentToMediaPackage(mediaPackage, elementId, newUrl, MediaPackageElement.Type.Track, flavor);
            job.setStatus(Job.Status.FINISHED);
            this.partialTrackStartTimes.put((Object)elementId, (Object)startTime);
            logger.debug("Added start time {} for track {}", (Object)startTime, (Object)elementId);
            logger.info("Successful added partial track {} on mediapackage {} at URL {}", new Object[]{elementId, mediaPackage, newUrl});
            mediaPackage2 = mp;
        }
        catch (ServiceRegistryException e) {
            try {
                throw new IngestException((Throwable)e);
                catch (NotFoundException e2) {
                    throw new IngestException("Unable to update ingest job", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return mediaPackage2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaPackage addPartialTrack(InputStream in, String fileName, MediaPackageElementFlavor flavor, long startTime, MediaPackage mediaPackage) throws IOException, IngestException {
        MediaPackage mediaPackage2;
        Job job = null;
        try {
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_TRACK, null, null, false);
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String elementId = UUID.randomUUID().toString();
            logger.info("Start adding partial track {} from input stream on mediapackage {}", (Object)elementId, (Object)mediaPackage);
            URI newUrl = this.addContentToRepo(mediaPackage, elementId, fileName, in);
            MediaPackage mp = this.addContentToMediaPackage(mediaPackage, elementId, newUrl, MediaPackageElement.Type.Track, flavor);
            job.setStatus(Job.Status.FINISHED);
            this.partialTrackStartTimes.put((Object)elementId, (Object)startTime);
            logger.debug("Added start time {} for track {}", (Object)startTime, (Object)elementId);
            logger.info("Successful added partial track {} on mediapackage {} at URL {}", new Object[]{elementId, mediaPackage, newUrl});
            mediaPackage2 = mp;
        }
        catch (ServiceRegistryException e) {
            try {
                throw new IngestException((Throwable)e);
                catch (NotFoundException e2) {
                    throw new IngestException("Unable to update ingest job", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return mediaPackage2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaPackage addCatalog(URI uri, MediaPackageElementFlavor flavor, String[] tags, MediaPackage mediaPackage) throws IOException, IngestException {
        MediaPackage mediaPackage2;
        Job job = null;
        try {
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_CATALOG_FROM_URI, Arrays.asList(uri.toString(), flavor.toString(), MediaPackageParser.getAsXml((MediaPackage)mediaPackage)), null, false, Float.valueOf(this.ingestFileJobLoad));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String elementId = UUID.randomUUID().toString();
            logger.info("Start adding catalog {} from URL {} on mediapackage {}", new Object[]{elementId, uri, mediaPackage});
            URI newUrl = this.addContentToRepo(mediaPackage, elementId, uri);
            MediaPackage mp = this.addContentToMediaPackage(mediaPackage, elementId, newUrl, MediaPackageElement.Type.Catalog, flavor);
            if (tags != null && tags.length > 0) {
                Catalog catalogElement = mp.getCatalog(elementId);
                for (String tag : tags) {
                    logger.info("Adding tag: " + tag + " to Element: " + elementId);
                    catalogElement.addTag(tag);
                }
            }
            job.setStatus(Job.Status.FINISHED);
            logger.info("Successful added catalog {} on mediapackage {} at URL {}", new Object[]{elementId, mediaPackage, newUrl});
            mediaPackage2 = mp;
        }
        catch (ServiceRegistryException e) {
            try {
                throw new IngestException((Throwable)e);
                catch (NotFoundException e2) {
                    throw new IngestException("Unable to update ingest job", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return mediaPackage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateSeries(MediaPackage mediaPackage) throws IOException, IngestException {
        Catalog[] seriesCatalogs = mediaPackage.getCatalogs(MediaPackageElements.SERIES);
        if (seriesCatalogs.length == 0) {
            return false;
        }
        if (seriesCatalogs.length > 1) {
            logger.warn("Mediapackage {} has more than one series dublincore catalogs. Using catalog {} with ID {}.", new Object[]{mediaPackage.getIdentifier(), seriesCatalogs[0].getURI(), seriesCatalogs[0].getIdentifier()});
        }
        HttpResponse response = null;
        InputStream in = null;
        boolean isUpdated = false;
        boolean isNew = false;
        String seriesId = null;
        try {
            block33: {
                HttpGet getDc = new HttpGet(seriesCatalogs[0].getURI());
                response = this.httpClient.execute((HttpUriRequest)getDc);
                in = response.getEntity().getContent();
                DublinCoreCatalog dc = this.dublinCoreService.load(in);
                seriesId = dc.getFirst(DublinCore.PROPERTY_IDENTIFIER);
                if (seriesId == null) {
                    logger.warn("Series dublin core document contains no identifier, rejecting ingested series catalog for mediapackage {}.", (Object)mediaPackage.getIdentifier());
                } else {
                    try {
                        try {
                            this.seriesService.getSeries(seriesId);
                            if (this.isAllowModifySeries) {
                                this.seriesService.updateSeries(dc);
                                isUpdated = true;
                                logger.debug("Ingest is overwriting the existing series {} with the ingested series", (Object)seriesId);
                                break block33;
                            }
                            logger.debug("Series {} already exists. Ignoring series catalog from ingest.", (Object)seriesId);
                        }
                        catch (NotFoundException e) {
                            logger.info("Creating new series {} with default ACL.", (Object)seriesId);
                            this.seriesService.updateSeries(dc);
                            isUpdated = true;
                            isNew = true;
                        }
                    }
                    catch (Exception e) {
                        throw new IngestException((Throwable)e);
                    }
                }
            }
            in.close();
        }
        catch (IOException e) {
            try {
                logger.error("Error updating series from DublinCoreCatalog.}", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                this.httpClient.close(response);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            this.httpClient.close(response);
        }
        IOUtils.closeQuietly((InputStream)in);
        this.httpClient.close(response);
        if (!isUpdated) {
            return isUpdated;
        }
        for (MediaPackageElement seriesElement : mediaPackage.getElementsByFlavor(MediaPackageElementFlavor.parseFlavor((String)"*/series"))) {
            byte[] data;
            if (MediaPackageElement.Type.Catalog != seriesElement.getElementType() || MediaPackageElements.SERIES.equals((Object)seriesElement.getFlavor())) continue;
            String catalogType = seriesElement.getFlavor().getType();
            logger.info("Apply series {} metadata catalog from mediapackage {} to newly created series {}.", new Object[]{catalogType, mediaPackage.getIdentifier(), seriesId});
            try {
                HttpGet getExtendedMetadata = new HttpGet(seriesElement.getURI());
                response = this.httpClient.execute((HttpUriRequest)getExtendedMetadata);
                in = response.getEntity().getContent();
                data = IOUtils.readFully((InputStream)in, (int)((int)response.getEntity().getContentLength()));
            }
            catch (Exception e) {
                throw new IngestException("Unable to read series " + catalogType + " metadata catalog for series " + seriesId + ".", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                this.httpClient.close(response);
            }
            try {
                this.seriesService.updateSeriesElement(seriesId, catalogType, data);
            }
            catch (SeriesException e) {
                throw new IngestException("Unable to update series " + catalogType + " catalog on newly created series " + seriesId + ".", (Throwable)e);
            }
        }
        if (isNew) {
            logger.info("Apply series ACL from mediapackage {} to newly created series {}.", (Object)mediaPackage.getIdentifier(), (Object)seriesId);
            Attachment[] seriesXacmls = mediaPackage.getAttachments(MediaPackageElements.XACML_POLICY_SERIES);
            if (seriesXacmls.length > 0) {
                if (seriesXacmls.length > 1) {
                    logger.warn("Mediapackage {} has more than one series xacml attachments. Using {}.", (Object)mediaPackage.getIdentifier(), (Object)seriesXacmls[0].getURI());
                }
                AccessControlList seriesAcl = null;
                try {
                    HttpGet getXacml = new HttpGet(seriesXacmls[0].getURI());
                    response = this.httpClient.execute((HttpUriRequest)getXacml);
                    in = response.getEntity().getContent();
                    seriesAcl = XACMLUtils.parseXacml((InputStream)in);
                }
                catch (XACMLParsingException ex) {
                    throw new IngestException("Unable to parse series xacml from mediapackage " + mediaPackage.getIdentifier() + ".", (Throwable)ex);
                }
                catch (IOException e) {
                    logger.error("Error updating series {} ACL from mediapackage {}.", new Object[]{seriesId, mediaPackage.getIdentifier(), e.getMessage()});
                    throw e;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                    this.httpClient.close(response);
                }
                try {
                    this.seriesService.updateAccessControl(seriesId, seriesAcl);
                }
                catch (Exception e) {
                    throw new IngestException("Unable to update series ACL on newly created series " + seriesId + ".", (Throwable)e);
                }
            }
        }
        return isUpdated;
    }

    public MediaPackage addCatalog(InputStream in, String fileName, MediaPackageElementFlavor flavor, MediaPackage mediaPackage) throws IOException, IngestException {
        return this.addCatalog(in, fileName, flavor, null, mediaPackage);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaPackage addCatalog(InputStream in, String fileName, MediaPackageElementFlavor flavor, String[] tags, MediaPackage mediaPackage) throws IOException, IngestException, IllegalArgumentException {
        MediaPackage mediaPackage2;
        Job job = null;
        try {
            boolean isJSON;
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_CATALOG, null, null, false, Float.valueOf(this.ingestFileJobLoad));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String elementId = UUID.randomUUID().toString();
            String mediaPackageId = mediaPackage.getIdentifier().toString();
            logger.info("Start adding catalog {} from input stream on mediapackage {}", (Object)elementId, (Object)mediaPackageId);
            URI newUrl = this.addContentToRepo(mediaPackage, elementId, fileName, in);
            try (InputStream inputStream = this.workingFileRepository.get(mediaPackageId, elementId);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                int firstChar = reader.read();
                isJSON = firstChar == 91 || firstChar == 123;
            }
            if (isJSON) {
                logger.warn("Input catalog seems to be JSON. This is a mistake and will fail in future Opencast versions.You will likely want to ingest this as a media package attachment instead.");
            } else {
                try {
                    XmlSafeParser.parse((InputStream)this.workingFileRepository.get(mediaPackageId, elementId));
                }
                catch (SAXException e) {
                    this.workingFileRepository.delete(mediaPackageId, elementId);
                    throw new IllegalArgumentException("Catalog XML is invalid", e);
                }
            }
            MediaPackage mp = this.addContentToMediaPackage(mediaPackage, elementId, newUrl, MediaPackageElement.Type.Catalog, flavor);
            if (tags != null && tags.length > 0) {
                Catalog trackElement = mp.getCatalog(elementId);
                for (String tag : tags) {
                    logger.info("Adding tag {} to element {}", (Object)tag, (Object)elementId);
                    trackElement.addTag(tag);
                }
            }
            job.setStatus(Job.Status.FINISHED);
            logger.info("Successful added catalog {} on mediapackage {} at URL {}", new Object[]{elementId, mediaPackage, newUrl});
            mediaPackage2 = mp;
        }
        catch (ServiceRegistryException e) {
            try {
                throw new IngestException((Throwable)e);
                catch (NotFoundException e2) {
                    throw new IngestException("Unable to update ingest job", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return mediaPackage2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaPackage addAttachment(URI uri, MediaPackageElementFlavor flavor, String[] tags, MediaPackage mediaPackage) throws IOException, IngestException {
        MediaPackage mediaPackage2;
        Job job = null;
        try {
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_ATTACHMENT_FROM_URI, Arrays.asList(uri.toString(), flavor.toString(), MediaPackageParser.getAsXml((MediaPackage)mediaPackage)), null, false, Float.valueOf(this.ingestFileJobLoad));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String elementId = UUID.randomUUID().toString();
            logger.info("Start adding attachment {} from URL {} on mediapackage {}", new Object[]{elementId, uri, mediaPackage});
            URI newUrl = this.addContentToRepo(mediaPackage, elementId, uri);
            MediaPackage mp = this.addContentToMediaPackage(mediaPackage, elementId, newUrl, MediaPackageElement.Type.Attachment, flavor);
            if (tags != null && tags.length > 0) {
                Attachment attachmentElement = mp.getAttachment(elementId);
                for (String tag : tags) {
                    logger.debug("Adding tag: " + tag + " to Element: " + elementId);
                    attachmentElement.addTag(tag);
                }
            }
            job.setStatus(Job.Status.FINISHED);
            logger.info("Successful added attachment {} on mediapackage {} at URL {}", new Object[]{elementId, mediaPackage, newUrl});
            mediaPackage2 = mp;
        }
        catch (ServiceRegistryException e) {
            try {
                throw new IngestException((Throwable)e);
                catch (NotFoundException e2) {
                    throw new IngestException("Unable to update ingest job", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return mediaPackage2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaPackage addAttachment(InputStream in, String fileName, MediaPackageElementFlavor flavor, String[] tags, MediaPackage mediaPackage) throws IOException, IngestException {
        MediaPackage mediaPackage2;
        Job job = null;
        try {
            job = this.serviceRegistry.createJob(JOB_TYPE, INGEST_ATTACHMENT, null, null, false, Float.valueOf(this.ingestFileJobLoad));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            String elementId = UUID.randomUUID().toString();
            logger.info("Start adding attachment {} from input stream on mediapackage {}", (Object)elementId, (Object)mediaPackage);
            URI newUrl = this.addContentToRepo(mediaPackage, elementId, fileName, in);
            MediaPackage mp = this.addContentToMediaPackage(mediaPackage, elementId, newUrl, MediaPackageElement.Type.Attachment, flavor);
            if (tags != null && tags.length > 0) {
                Attachment trackElement = mp.getAttachment(elementId);
                for (String tag : tags) {
                    logger.info("Adding tag: " + tag + " to Element: " + elementId);
                    trackElement.addTag(tag);
                }
            }
            job.setStatus(Job.Status.FINISHED);
            logger.info("Successful added attachment {} on mediapackage {} at URL {}", new Object[]{elementId, mediaPackage, newUrl});
            mediaPackage2 = mp;
        }
        catch (ServiceRegistryException e) {
            try {
                throw new IngestException((Throwable)e);
                catch (NotFoundException e2) {
                    throw new IngestException("Unable to update ingest job", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return mediaPackage2;
    }

    public MediaPackage addAttachment(InputStream in, String fileName, MediaPackageElementFlavor flavor, MediaPackage mediaPackage) throws IOException, IngestException {
        String[] tags = null;
        return this.addAttachment(in, fileName, flavor, tags, mediaPackage);
    }

    public WorkflowInstance ingest(MediaPackage mp) throws IngestException {
        try {
            return this.ingest(mp, null, null, null);
        }
        catch (NotFoundException e) {
            throw new IngestException((Throwable)e);
        }
        catch (UnauthorizedException e) {
            throw new IllegalStateException(e);
        }
    }

    public WorkflowInstance ingest(MediaPackage mp, String wd, Map<String, String> properties) throws IngestException, NotFoundException {
        try {
            return this.ingest(mp, wd, properties, null);
        }
        catch (UnauthorizedException e) {
            throw new IllegalStateException(e);
        }
    }

    public WorkflowInstance ingest(MediaPackage mp, String workflowDefinitionId, Map<String, String> properties, Long workflowInstanceId) throws IngestException, NotFoundException, UnauthorizedException {
        mp = this.checkForLegacyMediaPackageId(mp, properties);
        try {
            mp = this.createSmil(mp);
        }
        catch (IOException e) {
            throw new IngestException("Unable to add SMIL Catalog", (Throwable)e);
        }
        try {
            this.updateSeries(mp);
        }
        catch (IOException e) {
            throw new IngestException("Unable to create or update series from mediapackage " + mp.getIdentifier() + ".", (Throwable)e);
        }
        if (workflowInstanceId != null) {
            logger.warn("Resuming workflow {} with ingested mediapackage {} is deprecated, skip resuming and start new workflow", (Object)workflowInstanceId, (Object)mp);
        }
        if (workflowDefinitionId == null) {
            logger.info("Starting a new workflow with ingested mediapackage {} based on the default workflow definition '{}'", (Object)mp, (Object)this.defaultWorkflowDefinionId);
        } else {
            logger.info("Starting a new workflow with ingested mediapackage {} based on workflow definition '{}'", (Object)mp, (Object)workflowDefinitionId);
        }
        try {
            WorkflowDefinition workflowDef = this.getWorkflowDefinition(workflowDefinitionId, mp);
            properties = this.mergeWorkflowConfiguration(properties, mp.getIdentifier().toString());
            properties = this.removePrefixFromProperties(properties);
            mp = this.mergeScheduledMediaPackage(mp);
            if (mp.getSeries() == null) {
                mp = this.checkForCASeries(mp, this.createSeriesAppendix);
            }
            this.ingestStatistics.successful();
            if (workflowDef != null) {
                logger.info("Starting new workflow with ingested mediapackage '{}' using the specified template '{}'", (Object)mp.getIdentifier().toString(), (Object)workflowDefinitionId);
            } else {
                logger.info("Starting new workflow with ingested mediapackage '{}' using the default template '{}'", (Object)mp.getIdentifier().toString(), (Object)this.defaultWorkflowDefinionId);
            }
            return this.workflowService.start(workflowDef, mp, properties);
        }
        catch (WorkflowException e) {
            this.ingestStatistics.failed();
            throw new IngestException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(MediaPackage mediaPackage, String workflowDefinitionID, Map<String, String> properties) throws IllegalStateException, IngestException, NotFoundException, UnauthorizedException, SchedulerException {
        DublinCoreCatalog dublinCoreCatalog;
        MediaPackageElement[] mediaPackageElements = mediaPackage.getElementsByFlavor(MediaPackageElements.EPISODE);
        if (mediaPackageElements.length != 1) {
            logger.debug("There can be only one (and exactly one) episode dublin core catalog: https://youtu.be/_J3VeogFUOs");
            throw new IngestException("There can be only one (and exactly one) episode dublin core catalog");
        }
        try {
            InputStream inputStream = this.workingFileRepository.get(mediaPackage.getIdentifier().toString(), mediaPackageElements[0].getIdentifier());
            dublinCoreCatalog = this.dublinCoreService.load(inputStream);
        }
        catch (IOException e) {
            throw new IngestException((Throwable)e);
        }
        EName temporal = new EName("http://purl.org/dc/terms/", "temporal");
        List periods = dublinCoreCatalog.get(temporal);
        if (periods.size() != 1) {
            logger.debug("There can be only one (and exactly one) period");
            throw new IngestException("There can be only one (and exactly one) period");
        }
        DCMIPeriod period = EncodingSchemeUtils.decodeMandatoryPeriod((DublinCoreValue)((DublinCoreValue)periods.get(0)));
        if (!period.hasStart() || !period.hasEnd()) {
            logger.debug("A scheduled recording needs to have a start and end.");
            throw new IngestException("A scheduled recording needs to have a start and end.");
        }
        EName createdEName = new EName("http://purl.org/dc/terms/", "created");
        List created = dublinCoreCatalog.get(createdEName);
        if (created.size() == 0) {
            logger.debug("Created not set");
        } else if (created.size() == 1) {
            Date date = EncodingSchemeUtils.decodeMandatoryDate((DublinCoreValue)((DublinCoreValue)created.get(0)));
            if (date.getTime() != period.getStart().getTime()) {
                logger.debug("start and created date differ ({} vs {})", (Object)date.getTime(), (Object)period.getStart().getTime());
                throw new IngestException("Temporal start and created date differ");
            }
        } else {
            logger.debug("There can be only one created date");
            throw new IngestException("There can be only one created date");
        }
        String captureAgent = this.getCaptureAgent(dublinCoreCatalog);
        HashMap<String, String> agentProperties = new HashMap<String, String>();
        Map<String, String> workflowProperties = new HashMap<String, String>();
        for (String key : properties.keySet()) {
            if (key.startsWith(WORKFLOW_CONFIGURATION_PREFIX)) {
                workflowProperties.put(key, properties.get(key));
                continue;
            }
            agentProperties.put(key, properties.get(key));
        }
        workflowProperties = this.removePrefixFromProperties(workflowProperties);
        try {
            this.schedulerService.addEvent(period.getStart(), period.getEnd(), captureAgent, new HashSet(), mediaPackage, workflowProperties, agentProperties, Opt.none());
        }
        finally {
            for (MediaPackageElement mediaPackageElement : mediaPackage.getElements()) {
                try {
                    this.workingFileRepository.delete(mediaPackage.getIdentifier().toString(), mediaPackageElement.getIdentifier());
                }
                catch (IOException e) {
                    logger.warn("Failed to delete media package element", (Throwable)e);
                }
            }
        }
    }

    private String getCaptureAgent(DublinCoreCatalog dublinCoreCatalog) throws IngestException {
        EName spatial = new EName("http://purl.org/dc/terms/", "spatial");
        List captureAgents = dublinCoreCatalog.get(spatial);
        if (captureAgents.size() != 1) {
            logger.debug("Exactly one capture agent needs to be set");
            throw new IngestException("Exactly one capture agent needs to be set");
        }
        return ((DublinCoreValue)captureAgents.get(0)).getValue();
    }

    /*
     * Exception decompiling
     */
    private MediaPackage checkForLegacyMediaPackageId(MediaPackage mp, Map<String, String> properties) throws IngestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String> mergeWorkflowConfiguration(Map<String, String> properties, String mediaPackageId) {
        if (StringUtils.isBlank((CharSequence)mediaPackageId) || this.schedulerService == null) {
            return properties;
        }
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        try {
            Map recordingProperties = this.schedulerService.getCaptureAgentConfiguration(mediaPackageId);
            logger.debug("Restoring workflow properties from scheduler event {}", (Object)mediaPackageId);
            mergedProperties.putAll(recordingProperties);
        }
        catch (SchedulerException e) {
            logger.warn("Unable to get workflow properties from scheduler event {}", (Object)mediaPackageId, (Object)e);
        }
        catch (NotFoundException e) {
            logger.info("No capture event found for id {}", (Object)mediaPackageId);
        }
        catch (UnauthorizedException e) {
            throw new IllegalStateException(e);
        }
        if (properties != null) {
            logger.debug("Merge workflow properties with the one from the scheduler event {}", (Object)mediaPackageId);
            mergedProperties.putAll(properties);
        }
        return mergedProperties;
    }

    private MediaPackage mergeScheduledMediaPackage(MediaPackage mp) throws IngestException {
        if (this.schedulerService == null) {
            logger.warn("No scheduler service available to merge mediapackage!");
            return mp;
        }
        try {
            MediaPackage scheduledMp = this.schedulerService.getMediaPackage(mp.getIdentifier().toString());
            logger.info("Found matching scheduled event for id '{}', merging mediapackage...", (Object)mp.getIdentifier().toString());
            this.mergeMediaPackageElements(mp, scheduledMp);
            this.mergeMediaPackageMetadata(mp, scheduledMp);
            return mp;
        }
        catch (NotFoundException e) {
            logger.debug("No scheduler mediapackage found with id {}, skip merging", (Object)mp.getIdentifier());
            return mp;
        }
        catch (Exception e) {
            throw new IngestException(String.format("Unable to get event media package from scheduler event %s", mp.getIdentifier()), (Throwable)e);
        }
    }

    private void mergeMediaPackageElements(MediaPackage mp, MediaPackage scheduledMp) {
        if (this.skipCatalogs) {
            for (Catalog catalog : mp.getCatalogs()) {
                if (catalog.getFlavor().equals((Object)MediaPackageElements.SMIL)) continue;
                mp.remove((MediaPackageElement)catalog);
            }
        }
        if (this.skipAttachments) {
            for (Catalog catalog : mp.getAttachments()) {
                mp.remove((MediaPackageElement)catalog);
            }
        }
        for (Catalog catalog : scheduledMp.getElements()) {
            if (MediaPackageElement.Type.Publication.equals((Object)catalog.getElementType())) {
                logger.debug("Ignoring {}, not adding to ingested mediapackage {}", (Object)MediaPackageElement.Type.Publication, (Object)mp);
                continue;
            }
            if (mp.getElementsByFlavor(catalog.getFlavor()).length > 0) {
                if (!this.isAddOnlyNew || MediaPackageElement.Type.Track.equals((Object)catalog.getElementType())) {
                    logger.info("Omitting Opencast (Asset Managed) element '{}', replacing with ingested element of same flavor '{}'", (Object)catalog, (Object)catalog.getFlavor());
                    continue;
                }
                for (MediaPackageElement el : mp.getElementsByFlavor(catalog.getFlavor())) {
                    logger.info("Omitting ingested element '{}' {}, keeping existing (Asset Managed) element of same flavor '{}'", new Object[]{el, el.getURI(), catalog.getFlavor()});
                    mp.remove(el);
                }
            }
            logger.info("Adding element {} from scheduled (Asset Managed) event '{}' into ingested mediapackage", (Object)catalog, (Object)mp);
            mp.add((MediaPackageElement)catalog);
        }
    }

    private void mergeMediaPackageMetadata(MediaPackage mp, MediaPackage scheduledMp) {
        block22: {
            block21: {
                boolean noOverwrite;
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                boolean bl = noOverwrite = this.isAddOnlyNew && !this.skipCatalogs || this.skipCatalogs;
                                if (mp.getDate() == null || noOverwrite) {
                                    mp.setDate(scheduledMp.getDate());
                                }
                                if (StringUtils.isBlank((CharSequence)mp.getLicense()) || noOverwrite) {
                                    mp.setLicense(scheduledMp.getLicense());
                                }
                                if (StringUtils.isBlank((CharSequence)mp.getSeries()) || noOverwrite) {
                                    mp.setSeries(scheduledMp.getSeries());
                                }
                                if (StringUtils.isBlank((CharSequence)mp.getSeriesTitle()) || noOverwrite) {
                                    mp.setSeriesTitle(scheduledMp.getSeriesTitle());
                                }
                                if (StringUtils.isBlank((CharSequence)mp.getTitle()) || noOverwrite) {
                                    mp.setTitle(scheduledMp.getTitle());
                                }
                                if (mp.getSubjects().length <= 0) break block17;
                                if (!noOverwrite) break block18;
                            }
                            Arrays.stream(mp.getSubjects()).forEach(arg_0 -> ((MediaPackage)mp).removeSubject(arg_0));
                            for (String subject : scheduledMp.getSubjects()) {
                                mp.addSubject(subject);
                            }
                        }
                        if (noOverwrite) break block19;
                        if (mp.getContributors().length != 0) break block20;
                    }
                    Arrays.stream(mp.getContributors()).forEach(arg_0 -> ((MediaPackage)mp).removeContributor(arg_0));
                    for (String contributor : scheduledMp.getContributors()) {
                        mp.addContributor(contributor);
                    }
                }
                if (noOverwrite) break block21;
                if (mp.getCreators().length != 0) break block22;
            }
            Arrays.stream(mp.getCreators()).forEach(arg_0 -> ((MediaPackage)mp).removeCreator(arg_0));
            for (String creator : scheduledMp.getCreators()) {
                mp.addCreator(creator);
            }
        }
    }

    private Map<String, String> removePrefixFromProperties(Map<String, String> properties) {
        HashMap<String, String> fixedProperties = new HashMap<String, String>();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (entry.getKey().startsWith(WORKFLOW_CONFIGURATION_PREFIX)) {
                    logger.debug("Removing prefix from key '" + entry.getKey() + " with value '" + entry.getValue() + "'");
                    fixedProperties.put(entry.getKey().replace(WORKFLOW_CONFIGURATION_PREFIX, ""), entry.getValue());
                    continue;
                }
                fixedProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return fixedProperties;
    }

    private WorkflowDefinition getWorkflowDefinition(String workflowDefinitionID, MediaPackage mediapackage) throws NotFoundException, WorkflowDatabaseException, IngestException {
        if (StringUtils.isBlank((CharSequence)workflowDefinitionID)) {
            String mediaPackageId = mediapackage.getIdentifier().toString();
            if (this.schedulerService != null) {
                logger.info("Determining workflow template for ingested mediapckage {} from capture event {}", (Object)mediapackage, (Object)mediaPackageId);
                try {
                    Map recordingProperties = this.schedulerService.getCaptureAgentConfiguration(mediaPackageId);
                    workflowDefinitionID = (String)recordingProperties.get("org.opencastproject.workflow.definition");
                    if (StringUtils.isBlank((CharSequence)workflowDefinitionID)) {
                        workflowDefinitionID = this.defaultWorkflowDefinionId;
                        logger.debug("No workflow set. Falling back to default.");
                    }
                    if (StringUtils.isBlank((CharSequence)workflowDefinitionID)) {
                        throw new IngestException("No value found for key 'org.opencastproject.workflow.definition' from capture event configuration of scheduler event '" + mediaPackageId + "'");
                    }
                    logger.info("Ingested event {} will be processed using workflow '{}'", (Object)mediapackage, (Object)workflowDefinitionID);
                }
                catch (NotFoundException e) {
                    logger.warn("Specified capture event {} was not found", (Object)mediaPackageId);
                }
                catch (UnauthorizedException e) {
                    throw new IllegalStateException(e);
                }
                catch (SchedulerException e) {
                    logger.warn("Unable to get the workflow definition id from scheduler event {}", (Object)mediaPackageId, (Object)e);
                    throw new IngestException((Throwable)e);
                }
            } else {
                logger.warn("Scheduler service not bound, unable to determine the workflow template to use for ingested mediapckage {}", (Object)mediapackage);
            }
        } else {
            logger.info("Ingested mediapackage {} is processed using workflow template '{}', specified during ingest", (Object)mediapackage, (Object)workflowDefinitionID);
        }
        if (StringUtils.isBlank((CharSequence)workflowDefinitionID) && this.defaultWorkflowDefinionId != null) {
            logger.info("Using default workflow definition '{}' to process ingested mediapackage {}", (Object)this.defaultWorkflowDefinionId, (Object)mediapackage);
            workflowDefinitionID = this.defaultWorkflowDefinionId;
        }
        if (StringUtils.isNotBlank((CharSequence)workflowDefinitionID) && StringUtils.isNotBlank((CharSequence)this.defaultWorkflowDefinionId)) {
            try {
                this.workflowService.getWorkflowDefinitionById(workflowDefinitionID);
            }
            catch (WorkflowDatabaseException e) {
                throw new IngestException((Throwable)e);
            }
            catch (NotFoundException nfe) {
                logger.warn("Workflow definition {} not found, using default workflow {} instead", (Object)workflowDefinitionID, (Object)this.defaultWorkflowDefinionId);
                workflowDefinitionID = this.defaultWorkflowDefinionId;
            }
        }
        if (StringUtils.isBlank((CharSequence)workflowDefinitionID)) {
            this.ingestStatistics.failed();
            throw new IllegalStateException("Can not ingest a workflow without a workflow definition or an existing instance. No default definition is specified");
        }
        return this.workflowService.getWorkflowDefinitionById(workflowDefinitionID);
    }

    public void discardMediaPackage(MediaPackage mp) throws IOException {
        String mediaPackageId = mp.getIdentifier().toString();
        for (MediaPackageElement element : mp.getElements()) {
            if (this.workingFileRepository.delete(mediaPackageId, element.getIdentifier())) continue;
            logger.warn("Unable to find (and hence, delete), this mediapackage element");
        }
        logger.info("Successfully discarded media package {}", (Object)mp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI addContentToRepo(MediaPackage mp, String elementId, URI uri) throws IOException {
        URI uRI;
        CloseableHttpClient externalHttpClient;
        HttpResponse response;
        block18: {
            InputStream in = null;
            response = null;
            externalHttpClient = null;
            try {
                if (uri.toString().startsWith("http")) {
                    HttpGet get = new HttpGet(uri);
                    Set clusterUrls = this.securityService.getOrganization().getServers().keySet();
                    if (!StringUtils.isBlank((CharSequence)downloadSource) && uri.toString().matches(downloadSource)) {
                        externalHttpClient = this.getAuthedHttpClient();
                        get.setHeader("X-Requested-Auth", downloadAuthMethod);
                        if ("Basic".equals(downloadAuthMethod) && downloadAuthForceBasic) {
                            String auth = downloadUser + ":" + downloadPassword;
                            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.ISO_8859_1));
                            String authHeader = "Basic " + new String(encodedAuth);
                            get.setHeader("Authorization", authHeader);
                        }
                        response = externalHttpClient.execute((HttpUriRequest)get);
                    } else if (clusterUrls.contains(uri.getScheme() + "://" + uri.getHost())) {
                        response = this.httpClient.execute((HttpUriRequest)get);
                    } else {
                        externalHttpClient = this.getNoAuthHttpClient();
                        response = externalHttpClient.execute((HttpUriRequest)get);
                    }
                    if (null == response) {
                        throw new IOException("Null response object from the http client, refer to code for explanation");
                    }
                    int httpStatusCode = response.getStatusLine().getStatusCode();
                    if (httpStatusCode != 200) {
                        throw new IOException(uri + " returns http " + httpStatusCode);
                    }
                    in = response.getEntity().getContent();
                } else if (!uri.toString().startsWith("file") || this.testMode) {
                    in = uri.toURL().openStream();
                } else {
                    throw new IOException("Refusing to fetch files from the local filesystem");
                }
                String fileName = FilenameUtils.getName((String)uri.getPath());
                if (StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)fileName))) {
                    fileName = this.getContentDispositionFileName(response);
                }
                if (StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)fileName))) {
                    throw new IOException("No filename extension found: " + fileName);
                }
                uRI = this.addContentToRepo(mp, elementId, fileName, in);
                if (in == null) break block18;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    in.close();
                }
                if (externalHttpClient != null) {
                    externalHttpClient.close();
                }
                this.httpClient.close(response);
                throw throwable;
            }
            in.close();
        }
        if (externalHttpClient != null) {
            externalHttpClient.close();
        }
        this.httpClient.close(response);
        return uRI;
    }

    private String getContentDispositionFileName(HttpResponse response) {
        if (response == null) {
            return null;
        }
        Header header = response.getFirstHeader("Content-Disposition");
        ContentDisposition contentDisposition = new ContentDisposition(header.getValue());
        return contentDisposition.getParameter("filename");
    }

    private URI addContentToRepo(MediaPackage mp, String elementId, String filename, InputStream file) throws IOException {
        ProgressInputStream progressInputStream = new ProgressInputStream(file);
        progressInputStream.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                long totalNumBytesRead = (Long)evt.getNewValue();
                long oldTotalNumBytesRead = (Long)evt.getOldValue();
                IngestServiceImpl.this.ingestStatistics.add(totalNumBytesRead - oldTotalNumBytesRead);
            }
        });
        return this.workingFileRepository.put(mp.getIdentifier().toString(), elementId, filename, (InputStream)progressInputStream);
    }

    private MediaPackage addContentToMediaPackage(MediaPackage mp, String elementId, URI uri, MediaPackageElement.Type type, MediaPackageElementFlavor flavor) {
        logger.info("Adding element of type {} to mediapackage {}", (Object)type, (Object)mp);
        MediaPackageElement mpe = mp.add(uri, type, flavor);
        mpe.setIdentifier(elementId);
        return mp;
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Reference
    public void setWorkingFileRepository(WorkingFileRepository workingFileRepository) {
        this.workingFileRepository = workingFileRepository;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setDublinCoreService(DublinCoreCatalogService dublinCoreService) {
        this.dublinCoreService = dublinCoreService;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected String process(Job job) throws Exception {
        throw new IllegalStateException("Ingest jobs are not expected to be dispatched");
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, unbind="unsetSchedulerService")
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void unsetSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = null;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    protected CloseableHttpClient getNoAuthHttpClient() {
        return HttpClientBuilder.create().build();
    }

    protected CloseableHttpClient getAuthedHttpClient() {
        HttpClientBuilder cb = HttpClientBuilder.create();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        String schema = "Digest";
        if ("Basic".equals(downloadAuthMethod)) {
            schema = "Basic";
        }
        provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, schema), (Credentials)new UsernamePasswordCredentials(downloadUser, downloadPassword));
        return cb.setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    private MediaPackage createSmil(MediaPackage mediaPackage) throws IOException, IngestException {
        Long startTime;
        Stream partialTracks = Stream.empty();
        for (Track track : mediaPackage.getTracks()) {
            startTime = (Long)this.partialTrackStartTimes.getIfPresent((Object)track.getIdentifier());
            if (startTime == null) continue;
            partialTracks = partialTracks.append((Iterable)Opt.nul((Object)track));
        }
        if (partialTracks.isEmpty()) {
            return mediaPackage;
        }
        List tracks = partialTracks.map(IngestServiceImpl.newEnrichJob(this.mediaInspectionService).toFn()).map(IngestServiceImpl.payloadAsTrack(this.getServiceRegistry()).toFn()).each(MediaPackageSupport.updateElement((MediaPackage)mediaPackage).toFn().toFx()).toList();
        Document smilDocument = SmilUtil.createSmil();
        for (Track track : tracks) {
            startTime = (Long)this.partialTrackStartTimes.getIfPresent((Object)track.getIdentifier());
            if (startTime == null) {
                logger.error("No start time found for track {}", (Object)track);
                throw new IngestException("No start time found for track " + track.getIdentifier());
            }
            smilDocument = this.addSmilTrack(smilDocument, track, startTime);
            this.partialTrackStartTimes.invalidate((Object)track.getIdentifier());
        }
        return this.addSmilCatalog(smilDocument, mediaPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaPackage addSmilCatalog(Document smilDocument, MediaPackage mediaPackage) throws IOException, IngestException {
        Option<Document> optSmilDocument = this.loadSmilDocument(this.workingFileRepository, mediaPackage);
        if (optSmilDocument.isSome()) {
            throw new IngestException("SMIL already exists!");
        }
        InputStream in = null;
        try {
            in = XmlUtil.serializeDocument((Document)smilDocument);
            String elementId = UUID.randomUUID().toString();
            URI uri = this.workingFileRepository.put(mediaPackage.getIdentifier().toString(), elementId, PARTIAL_SMIL_NAME, in);
            MediaPackageElement mpe = mediaPackage.add(uri, MediaPackageElement.Type.Catalog, MediaPackageElements.SMIL);
            mpe.setIdentifier(elementId);
            mpe.setChecksum(null);
            mpe.setMimeType(MimeTypes.SMIL);
            MediaPackage mediaPackage2 = mediaPackage;
            return mediaPackage2;
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    private Option<Document> loadSmilDocument(final WorkingFileRepository workingFileRepository, MediaPackage mp) {
        return Monadics.mlist((Object[])mp.getElements()).filter(MediaPackageSupport.Filters.isSmilCatalog).headOpt().map((Function)new Function<MediaPackageElement, Document>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Document apply(MediaPackageElement mpe) {
                Document document;
                InputStream in = null;
                try {
                    in = workingFileRepository.get(mpe.getMediaPackage().getIdentifier().toString(), mpe.getIdentifier());
                    document = SmilUtil.loadSmilDocument((InputStream)in, (MediaPackageElement)mpe);
                }
                catch (Exception e) {
                    Document document2;
                    try {
                        logger.warn("Unable to load smil document from catalog '{}'", (Object)mpe, (Object)e);
                        document2 = (Document)Misc.chuck((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    return document2;
                }
                IOUtils.closeQuietly((InputStream)in);
                return document;
            }
        });
    }

    private Document addSmilTrack(Document smilDocument, Track track, long startTime) throws IngestException {
        if (MediaPackageElements.PRESENTER_SOURCE.getType().equals(track.getFlavor().getType())) {
            return SmilUtil.addTrack((Document)smilDocument, (SmilUtil.TrackType)SmilUtil.TrackType.PRESENTER, (boolean)track.hasVideo(), (long)startTime, (long)track.getDuration(), (URI)track.getURI(), (String)track.getIdentifier());
        }
        if (MediaPackageElements.PRESENTATION_SOURCE.getType().equals(track.getFlavor().getType())) {
            return SmilUtil.addTrack((Document)smilDocument, (SmilUtil.TrackType)SmilUtil.TrackType.PRESENTATION, (boolean)track.hasVideo(), (long)startTime, (long)track.getDuration(), (URI)track.getURI(), (String)track.getIdentifier());
        }
        logger.warn("Invalid partial flavor type {} of track {}", (Object)track.getFlavor(), (Object)track);
        throw new IngestException("Invalid partial flavor type " + track.getFlavor().getType() + " of track " + track.getURI().toString());
    }

    public static Function<MediaPackageElement, Job> newEnrichJob(final MediaInspectionService svc) {
        return new Function.X<MediaPackageElement, Job>(){

            public Job xapply(MediaPackageElement e) throws Exception {
                return svc.enrich(e, true);
            }
        };
    }

    public static Function<Job, Track> payloadAsTrack(final ServiceRegistry reg) {
        return new Function.X<Job, Track>(){

            public Track xapply(Job job) throws MediaPackageException {
                JobUtil.waitForJob((ServiceRegistry)reg, (Option)Option.none((Object)0L), (Job)job);
                return (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
            }
        };
    }

    private MediaPackage checkForCASeries(MediaPackage mp, String seriesAppendName) {
        if (mp == null || seriesAppendName == null) {
            logger.debug("No series name provided");
            return mp;
        }
        User user = this.securityService.getUser();
        if (!user.hasRole("ROLE_ADMIN") && !user.hasRole("ROLE_CAPTURE_AGENT")) {
            logger.info("User '{}' is missing capture agent roles, won't apply CASeries", (Object)user.getUsername());
            return mp;
        }
        String captureAgentId = null;
        Catalog[] catalog = mp.getCatalogs(MediaPackageElementFlavor.flavor((String)"dublincore", (String)"episode"));
        if (catalog.length == 1) {
            try (InputStream catalogInputStream = this.workingFileRepository.get(mp.getIdentifier().toString(), catalog[0].getIdentifier());){
                DublinCoreCatalog dc = this.dublinCoreService.load(catalogInputStream);
                captureAgentId = this.getCaptureAgent(dc);
            }
            catch (Exception e) {
                logger.info("Unable to determine capture agent name");
            }
        }
        if (captureAgentId == null) {
            logger.info("No Capture Agent ID defined for MediaPackage {}, won't apply CASeries", (Object)mp.getIdentifier());
            return mp;
        }
        logger.info("Applying CASeries to MediaPackage {} for capture agent '{}'", (Object)mp.getIdentifier(), captureAgentId);
        String seriesId = captureAgentId.replaceAll("[^\\w-_.:;()]+", "_");
        String seriesName = captureAgentId + seriesAppendName;
        try {
            this.seriesService.getSeries(seriesId);
        }
        catch (NotFoundException nfe) {
            try {
                ArrayList<String> roleNames = new ArrayList<String>();
                String roleName = SecurityUtil.getCaptureAgentRole((String)captureAgentId);
                roleNames.add(roleName);
                logger.debug("Capture agent role name: {}", (Object)roleName);
                String username = user.getUsername();
                roleNames.add(UserIdRoleProvider.getUserIdRole((String)username));
                logger.info("Creating new series for capture agent '{}' and user '{}'", (Object)captureAgentId, (Object)username);
                this.createSeries(seriesId, seriesName, roleNames);
            }
            catch (Exception e) {
                logger.error("Unable to create series {} for event {}", new Object[]{seriesName, mp, e});
                return mp;
            }
        }
        catch (UnauthorizedException | SeriesException e) {
            logger.error("Exception while searching for series {}", (Object)seriesName, (Object)e);
            return mp;
        }
        mp.setSeries(seriesId);
        mp.setSeriesTitle(seriesName);
        return mp;
    }

    private DublinCoreCatalog createSeries(String seriesId, String seriesName, List<String> roleNames) throws SeriesException, UnauthorizedException, NotFoundException {
        DublinCoreCatalog dc = DublinCores.mkOpencastSeries().getCatalog();
        dc.set(DublinCore.PROPERTY_IDENTIFIER, seriesId);
        dc.set(DublinCore.PROPERTY_TITLE, seriesName);
        dc.set(DublinCore.PROPERTY_CREATED, EncodingSchemeUtils.encodeDate((Date)new Date(), (Precision)Precision.Second));
        DublinCoreCatalog createdSeries = this.seriesService.updateSeries(dc);
        ArrayList<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
        for (String roleName : roleNames) {
            AccessControlEntry aceRead = new AccessControlEntry(roleName, Permissions.Action.READ.toString(), true);
            AccessControlEntry aceWrite = new AccessControlEntry(roleName, Permissions.Action.WRITE.toString(), true);
            aces.add(aceRead);
            aces.add(aceWrite);
        }
        AccessControlList acl = new AccessControlList(aces);
        this.seriesService.updateAccessControl(seriesId, acl);
        logger.info("Created capture agent series with name {} and id {}", (Object)seriesName, (Object)seriesId);
        return dc;
    }
}

