/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveEntryStreamClosedException;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.util.SynchronizedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InputArchiveMetaData {
    private static final String CLASS_NAME = "de.schlichtherle.io.InputArchiveMetaData";
    private static final Logger logger;
    private final Archive archive;
    private final InputArchive inArchive;
    private final Map streams;
    private volatile boolean stopped;
    static final /* synthetic */ boolean $assertionsDisabled;

    InputArchiveMetaData(Archive archive, InputArchive inArchive) {
        AbstractMap abstractMap = this.streams = File.isLenient() ? new WeakHashMap() : new HashMap();
        if (!$assertionsDisabled && inArchive == null) {
            throw new AssertionError();
        }
        this.archive = archive;
        this.inArchive = inArchive;
    }

    synchronized InputStream createInputStream(ArchiveEntry entry, ArchiveEntry dstEntry) throws IOException {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && entry == null) {
            throw new AssertionError();
        }
        InputStream in = this.inArchive.getInputStream(entry, dstEntry);
        return in != null ? new EntryInputStream(in) : null;
    }

    synchronized int waitAllInputStreamsByOtherThreads(long timeout) {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        long start = System.currentTimeMillis();
        int threadStreams = this.threadStreams();
        try {
            while (this.streams.size() > threadStreams) {
                long toWait;
                if (timeout > 0L) {
                    toWait = timeout - (System.currentTimeMillis() - start);
                    if (toWait <= 0L) {
                        break;
                    }
                } else {
                    toWait = 0L;
                }
                if (File.isLenient()) {
                    System.gc();
                    System.runFinalization();
                }
                this.wait(toWait);
            }
        }
        catch (InterruptedException ignored) {
            logger.warning("interrupted");
        }
        return this.streams.size();
    }

    private int threadStreams() {
        Thread thisThread = Thread.currentThread();
        int n = 0;
        Iterator i = this.streams.values().iterator();
        while (i.hasNext()) {
            Thread thread = (Thread)i.next();
            if (thisThread != thread) continue;
            ++n;
        }
        return n;
    }

    synchronized ArchiveException closeAllInputStreams(ArchiveException exceptionChain) {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        this.stopped = true;
        Iterator i = this.streams.keySet().iterator();
        while (i.hasNext()) {
            EntryInputStream in = (EntryInputStream)i.next();
            try {
                in.doClose();
            }
            catch (IOException failure) {
                exceptionChain = new ArchiveWarningException(exceptionChain, failure);
            }
        }
        this.streams.clear();
        return exceptionChain;
    }

    static {
        $assertionsDisabled = !InputArchiveMetaData.class.desiredAssertionStatus();
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    }

    private final class EntryInputStream
    extends SynchronizedInputStream {
        private boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        private EntryInputStream(InputStream in) {
            super(in, InputArchiveMetaData.this);
            if (!$assertionsDisabled && in == null) {
                throw new AssertionError();
            }
            InputArchiveMetaData.this.streams.put(this, Thread.currentThread());
            InputArchiveMetaData.this.notify();
        }

        private final void ensureNotStopped() throws IOException {
            if (InputArchiveMetaData.this.stopped) {
                throw new ArchiveEntryStreamClosedException();
            }
        }

        public int read() throws IOException {
            this.ensureNotStopped();
            return super.read();
        }

        public int read(byte[] b) throws IOException {
            this.ensureNotStopped();
            return super.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureNotStopped();
            return super.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            this.ensureNotStopped();
            return super.skip(n);
        }

        public int available() throws IOException {
            this.ensureNotStopped();
            return super.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() throws IOException {
            if (!$assertionsDisabled && InputArchiveMetaData.this != this.lock) {
                throw new AssertionError();
            }
            InputArchiveMetaData inputArchiveMetaData = InputArchiveMetaData.this;
            synchronized (inputArchiveMetaData) {
                if (this.closed) {
                    return;
                }
                try {
                    this.doClose();
                }
                finally {
                    InputArchiveMetaData.this.streams.remove(this);
                    InputArchiveMetaData.this.notify();
                }
            }
        }

        protected void doClose() throws IOException {
            if (!$assertionsDisabled && this.closed) {
                throw new AssertionError();
            }
            this.closed = true;
            super.doClose();
        }

        public void mark(int readlimit) {
            if (!InputArchiveMetaData.this.stopped) {
                super.mark(readlimit);
            }
        }

        public void reset() throws IOException {
            this.ensureNotStopped();
            super.reset();
        }

        public boolean markSupported() {
            return !InputArchiveMetaData.this.stopped && super.markSupported();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.closed) {
                    return;
                }
                logger.finer("finalize.open");
                try {
                    this.doClose();
                }
                catch (IOException failure) {
                    logger.log(Level.FINE, "finalize.exception", failure);
                }
            }
            finally {
                super.finalize();
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$InputArchiveMetaData == null ? (class$de$schlichtherle$io$InputArchiveMetaData = InputArchiveMetaData.class$(InputArchiveMetaData.CLASS_NAME)) : class$de$schlichtherle$io$InputArchiveMetaData).desiredAssertionStatus();
        }
    }
}

