/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.incident;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.Incident;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.serviceregistry.api.NopService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.EnumSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.data.functions.Strings;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Incident Creator Operation Handler", "workflow.operation=incident"})
public class IncidentCreatorWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger log = LoggerFactory.getLogger(IncidentCreatorWorkflowOperationHandler.class);
    private static final String OPT_CODE = "code";
    private static final String OPT_SEVERITY = "severity";
    private static final String OPT_DETAILS = "details";
    private static final String OPT_PARAMS = "params";
    private NopService nopService;

    public WorkflowOperationResult start(WorkflowInstance wi, JobContext ctx) throws WorkflowOperationException {
        WorkflowOperationInstance woi = wi.getCurrentOperation();
        int code = (Integer)Option.option((Object)woi.getConfiguration(OPT_CODE)).bind(Strings.toInt).getOrElse((Object)1);
        Incident.Severity severity = (Incident.Severity)Option.option((Object)woi.getConfiguration(OPT_SEVERITY)).bind(EnumSupport.parseEnum((Enum)Incident.Severity.FAILURE)).getOrElse((Object)Incident.Severity.INFO);
        List details = Arrays.stream(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)woi.getConfiguration(OPT_DETAILS), (String)";"))).map(opt -> opt.split("=")).filter(t -> ((String[])t).length == 2).map(x -> Tuple.tuple((Object)x[0], (Object)x[1])).collect(Collectors.toList());
        Map<String, String> params = Arrays.stream(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)woi.getConfiguration(OPT_PARAMS), (String)";"))).map(opt -> opt.split("=")).filter(t -> ((String[])t).length == 2).collect(Collectors.toMap(x -> x[0], x -> x[1]));
        log.info("Create nop job");
        Job job = this.nopService.nop();
        log.info("Log a dummy incident with code {}", (Object)code);
        this.serviceRegistry.incident().record(job, severity, code, params, details);
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException("Job did not complete successfully");
        }
        return this.createResult(WorkflowOperationResult.Action.CONTINUE);
    }

    @Reference
    public void setNopService(NopService nopService) {
        this.nopService = nopService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

