/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.hello;

import java.util.Objects;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Hello-World Workflow Operation Handler", "workflow.operation=hello-world"}, immediate=true, service={WorkflowOperationHandler.class})
public class HelloWorldWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(HelloWorldWorkflowOperationHandler.class);

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String message = Objects.toString(operation.getConfiguration("message"), "Hello World!");
        logger.info("Message: {}", (Object)message);
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        logger.info("The media package contains {} tracks", (Object)mediaPackage.getTracks().length);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }
}

