/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.helloworld.impl.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.helloworld.api.HelloWorldService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/helloworld")
@RestService(name="HelloWorldServiceEndpoint", title="Hello World Service Endpoint", abstractText="This is a tutorial service.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(property={"service.description=Hello World REST Endpoint", "opencast.service.type=org.opencastproject.helloworld", "opencast.service.path=/helloworld", "opencast.service.jobproducer=false"}, immediate=true, service={HelloWorldRestEndpoint.class})
@JaxrsResource
public class HelloWorldRestEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(HelloWorldRestEndpoint.class);
    protected String docs;
    protected HelloWorldService helloWorldService;

    @GET
    @Path(value="helloworld")
    @Produces(value={"text/plain"})
    @RestQuery(name="helloworld", description="example service call", responses={@RestResponse(responseCode=200, description="Hello World"), @RestResponse(responseCode=500, description="The underlying service could not output something.")}, returnDescription="The text that the service returns.")
    public Response helloWorld() throws Exception {
        logger.info("REST call for Hello World");
        return Response.ok().entity((Object)this.helloWorldService.helloWorld()).build();
    }

    @GET
    @Path(value="helloname")
    @Produces(value={"text/plain"})
    @RestQuery(name="helloname", description="example service call with parameter", restParameters={@RestParameter(name="name", description="name to output", isRequired=false, type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=200, description="Hello or Hello Name"), @RestResponse(responseCode=500, description="The underlying service could not output something.")}, returnDescription="The text that the service returns.")
    public Response helloName(@FormParam(value="name") String name) throws Exception {
        logger.info("REST call for Hello Name");
        return Response.ok().entity((Object)this.helloWorldService.helloName(name)).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="docs")
    public String getDocs() {
        return this.docs;
    }

    @Reference
    public void setHelloWorldService(HelloWorldService service) {
        this.helloWorldService = service;
    }
}

