/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.util;

import java.lang.reflect.InvocationTargetException;
import org.opencastproject.graphql.type.output.GqlMetadataFieldInterface;
import org.opencastproject.graphql.type.output.field.GqlBooleanMetadataField;
import org.opencastproject.graphql.type.output.field.GqlDateTimeMetadataField;
import org.opencastproject.graphql.type.output.field.GqlDurationMetadataField;
import org.opencastproject.graphql.type.output.field.GqlListMetadataField;
import org.opencastproject.graphql.type.output.field.GqlLongMetadataField;
import org.opencastproject.graphql.type.output.field.GqlStringMetadataField;
import org.opencastproject.metadata.dublincore.MetadataField;

public final class MetadataFieldToGraphQLFieldMapper {
    private MetadataFieldToGraphQLFieldMapper() {
    }

    public static GqlMetadataFieldInterface mapType(MetadataField field) {
        GqlMetadataFieldInterface gqlField;
        Class<? extends GqlMetadataFieldInterface> clazz = MetadataFieldToGraphQLFieldMapper.mapToClass(field.getType());
        try {
            gqlField = clazz.getConstructor(MetadataField.class).newInstance(field);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return gqlField;
    }

    public static Class<? extends GqlMetadataFieldInterface> mapToClass(MetadataField.Type type) {
        return switch (type) {
            case MetadataField.Type.DATE, MetadataField.Type.START_DATE -> GqlDateTimeMetadataField.class;
            case MetadataField.Type.LONG -> GqlLongMetadataField.class;
            case MetadataField.Type.TEXT, MetadataField.Type.ORDERED_TEXT, MetadataField.Type.TEXT_LONG -> GqlStringMetadataField.class;
            case MetadataField.Type.BOOLEAN -> GqlBooleanMetadataField.class;
            case MetadataField.Type.DURATION, MetadataField.Type.START_TIME -> GqlDurationMetadataField.class;
            case MetadataField.Type.MIXED_TEXT, MetadataField.Type.ITERABLE_TEXT -> GqlListMetadataField.class;
            default -> GqlStringMetadataField.class;
        };
    }
}

