/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.util;

import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import org.opencastproject.graphql.scalar.OpencastScalars;
import org.opencastproject.metadata.dublincore.MetadataField;

public final class MetadataFieldToGraphQLConverter {
    private MetadataFieldToGraphQLConverter() {
    }

    public static GraphQLType convertType(MetadataField field) {
        GraphQLScalarType graphQLType = switch (field.getType()) {
            case MetadataField.Type.DATE -> ExtendedScalars.DateTime;
            case MetadataField.Type.LONG -> ExtendedScalars.GraphQLLong;
            case MetadataField.Type.TEXT -> Scalars.GraphQLString;
            case MetadataField.Type.BOOLEAN -> Scalars.GraphQLBoolean;
            case MetadataField.Type.DURATION -> OpencastScalars.Duration;
            case MetadataField.Type.TEXT_LONG -> Scalars.GraphQLString;
            case MetadataField.Type.MIXED_TEXT -> GraphQLList.list((GraphQLType)Scalars.GraphQLString);
            case MetadataField.Type.START_DATE -> ExtendedScalars.DateTime;
            case MetadataField.Type.START_TIME -> ExtendedScalars.Time;
            case MetadataField.Type.ORDERED_TEXT -> Scalars.GraphQLString;
            case MetadataField.Type.ITERABLE_TEXT -> GraphQLList.list((GraphQLType)Scalars.GraphQLString);
            default -> Scalars.GraphQLString;
        };
        return field.isRequired() ? GraphQLNonNull.nonNull((GraphQLType)graphQLType) : graphQLType;
    }
}

