/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationScanner {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationScanner.class);

    private AnnotationScanner() {
    }

    public static Collection<Class<?>> findAnnotatedClasses(Class<?> context, Class<? extends Annotation> annotation) {
        return FrameworkUtil.getBundle((ClassLoader)context.getClassLoader()).map(b -> AnnotationScanner.entryPaths(b, context.getPackageName().replace('.', '/'))).orElse(Stream.empty()).map(clazz -> AnnotationScanner.loadClass(clazz, context.getClassLoader())).filter(Objects::nonNull).filter(c -> c.isAnnotationPresent(annotation)).collect(Collectors.toSet());
    }

    private static Stream<String> entryPaths(Bundle bundle, String path) {
        Enumeration entries = bundle.getEntryPaths(path);
        if (entries == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(entries.asIterator(), 1281), false).flatMap(name -> name.endsWith(".class") && !name.contains("$") ? Stream.of(name.replace('/', '.').replace(".class", "")) : AnnotationScanner.entryPaths(bundle, name));
    }

    private static Class<?> loadClass(String name, ClassLoader classLoader) {
        try {
            return Class.forName(name, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            logger.debug("Class not found: {}", (Object)name);
            return null;
        }
    }
}

