/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.user;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.schema.DataFetchingEnvironment;
import org.opencastproject.graphql.datafetcher.user.CurrentUserDataFetcher;
import org.opencastproject.graphql.datafetcher.user.UserOffsetDataFetcher;
import org.opencastproject.graphql.directive.RolesAllowed;
import org.opencastproject.graphql.type.output.Query;
import org.opencastproject.graphql.user.GqlCurrentUser;
import org.opencastproject.graphql.user.GqlUserList;

@GraphQLTypeExtension(value=Query.class)
public final class UserQueryExtension {
    private UserQueryExtension() {
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="The current user")
    public static GqlCurrentUser currentUser(DataFetchingEnvironment environment) {
        return (GqlCurrentUser)new CurrentUserDataFetcher().get(environment);
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Search for users")
    @RolesAllowed(value={"ROLE_USER"})
    public static GqlUserList searchUser(@GraphQLName(value="limit") Integer limit, @GraphQLName(value="offset") Integer offset, @GraphQLName(value="query") String query, DataFetchingEnvironment environment) {
        return (GqlUserList)new UserOffsetDataFetcher().withFilter(query).get(environment);
    }
}

