/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.user;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.List;
import java.util.stream.Collectors;
import org.opencastproject.graphql.type.output.OffsetPageInfo;
import org.opencastproject.graphql.user.GqlUser;
import org.opencastproject.security.api.User;

@GraphQLName(value="UserList")
@GraphQLNonNull
@GraphQLDescription(value="A list of users")
public class GqlUserList {
    public static final String TYPE_NAME = "UserList";
    private final List<User> searchResult;
    private final Long totalCount;
    private final Long offset;
    private final Long limit;

    public GqlUserList(List<User> searchResult) {
        this(searchResult, null, 0L, 1000L);
    }

    public GqlUserList(List<User> searchResult, Long totalCount, Long offset, Long limit) {
        this.searchResult = searchResult;
        this.totalCount = totalCount;
        this.offset = offset;
        this.limit = limit;
    }

    @GraphQLField
    @GraphQLNonNull
    public Long totalCount() {
        return this.totalCount;
    }

    @GraphQLField
    @GraphQLNonNull
    public OffsetPageInfo pageInfo() {
        long pageCount = this.totalCount == null ? (long)this.searchResult.size() : (this.totalCount + this.limit - 1L) / this.limit;
        return new OffsetPageInfo(pageCount, this.limit, this.offset);
    }

    @GraphQLField
    @GraphQLNonNull
    public List<GqlUser> nodes() {
        return this.searchResult.stream().map(GqlUser::new).collect(Collectors.toList());
    }
}

