/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.user;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.List;
import java.util.stream.Collectors;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.User;
import org.opencastproject.userdirectory.UserIdRoleProvider;

@GraphQLName(value="CurrentUser")
@GraphQLDescription(value="Represents the current user.")
public class GqlCurrentUser {
    public static final String TYPE_NAME = "CurrentUser";
    private final User user;

    public GqlCurrentUser(User user) {
        this.user = user;
    }

    @GraphQLField
    public String username() {
        return this.user.getUsername();
    }

    @GraphQLField
    public String name() {
        return this.user.getName();
    }

    @GraphQLField
    public String email() {
        return this.user.getEmail();
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="A list of roles assigned to the user.")
    public List<String> roles() {
        return this.user.getRoles().stream().map(Role::getName).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="The role of the user.")
    public String userRole() {
        return UserIdRoleProvider.getUserIdRole((String)this.user.getUsername());
    }

    public User getUser() {
        return this.user;
    }
}

