/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.type.output;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import org.opencastproject.elasticsearch.api.SearchResult;

public class OffsetPageInfo {
    private final Long pageCount;
    private final Long limit;
    private final Long offset;

    public OffsetPageInfo(Long pageCount, Long limit, Long offset) {
        this.pageCount = pageCount;
        this.limit = limit;
        this.offset = offset;
    }

    public static OffsetPageInfo from(SearchResult<?> searchResult) {
        return new OffsetPageInfo((searchResult.getHitCount() + searchResult.getLimit() - 1L) / searchResult.getLimit(), searchResult.getLimit(), searchResult.getOffset());
    }

    @GraphQLField
    @GraphQLNonNull
    public Long pageCount() {
        return this.pageCount;
    }

    @GraphQLField
    @GraphQLNonNull
    public Long limit() {
        return this.limit;
    }

    @GraphQLField
    @GraphQLNonNull
    public Long offset() {
        return this.offset;
    }
}

