/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.type.output;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import org.opencastproject.graphql.type.output.GqlMediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.TrackSupport;
import org.opencastproject.mediapackage.VideoStream;

@GraphQLName(value="Track")
public class GqlTrack
implements GqlMediaPackageElement {
    public static final String TYPE_NAME = "Track";
    private final Track track;
    private VideoStream[] videoStreams;

    public GqlTrack(Track track) {
        this.track = track;
    }

    @GraphQLField
    public boolean isLive() {
        return this.track.isLive();
    }

    @GraphQLField
    public String logicalName() {
        return this.track.getLogicalName();
    }

    @GraphQLField
    public Integer width() {
        VideoStream videoStream = this.getVideoStream();
        if (videoStream == null) {
            return null;
        }
        return videoStream.getFrameWidth();
    }

    @GraphQLField
    public Integer height() {
        VideoStream videoStream = this.getVideoStream();
        if (videoStream == null) {
            return null;
        }
        return videoStream.getFrameHeight();
    }

    @GraphQLField
    public double frameRate() {
        VideoStream videoStream = this.getVideoStream();
        if (videoStream == null) {
            return 0.0;
        }
        return videoStream.getFrameRate().floatValue();
    }

    @Override
    public MediaPackageElement getElement() {
        return this.track;
    }

    private VideoStream getVideoStream() {
        if (this.videoStreams == null) {
            this.videoStreams = (VideoStream[])TrackSupport.byType((Stream[])this.track.getStreams(), VideoStream.class);
        }
        if (this.videoStreams.length == 0) {
            return null;
        }
        return this.videoStreams[0];
    }
}

