/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.type.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opencastproject.graphql.type.output.GqlMediaPackageElement;
import org.opencastproject.graphql.type.output.GqlTrack;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.Publication;

@GraphQLName(value="Publication")
public class GqlPublication
implements GqlMediaPackageElement {
    public static final String TYPE_NAME = "Publication";
    private final Publication publication;

    public GqlPublication(Publication publication) {
        this.publication = publication;
    }

    @Override
    @GraphQLField
    public String uri() {
        return this.publication.getURI().toString();
    }

    @GraphQLField
    public String channel() {
        return this.publication.getChannel();
    }

    @GraphQLField
    @GraphQLDescription(value="Return tracks filterable by tags")
    public List<GqlTrack> tracks(@GraphQLName(value="tags") List<String> tags) {
        return Arrays.stream(this.publication.getTracks()).filter(e -> {
            if (tags == null) return true;
            if (!Arrays.stream(e.getTags()).anyMatch(tags::contains)) return false;
            return true;
        }).map(GqlTrack::new).collect(Collectors.toList());
    }

    @Override
    public MediaPackageElement getElement() {
        return this.publication;
    }
}

