/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.type.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opencastproject.graphql.type.output.GqlAccessControlGenericItem;
import org.opencastproject.graphql.type.output.GqlAccessControlGroupItem;
import org.opencastproject.graphql.type.output.GqlAccessControlItem;
import org.opencastproject.graphql.type.output.GqlAccessControlUserItem;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.userdirectory.UserIdRoleProvider;

@GraphQLName(value="AccessControlList")
@GraphQLDescription(value="Access control list")
public class GqlAccessControlList {
    public static final String TYPE_NAME = "AccessControlList";
    private final AccessControlList accessControlList;
    private final List<GqlAccessControlItem> items;

    public GqlAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
        this.items = this.getItems();
    }

    @GraphQLField
    public GqlAccessControlUserItem[] users() {
        return (GqlAccessControlUserItem[])this.items.stream().filter(i -> i instanceof GqlAccessControlUserItem).toArray(GqlAccessControlUserItem[]::new);
    }

    @GraphQLField
    public GqlAccessControlItem[] entries() {
        return this.items.toArray(new GqlAccessControlItem[0]);
    }

    private List<GqlAccessControlItem> getItems() {
        String groupPrefix = "ROLE_GROUP_";
        String userPrefix = UserIdRoleProvider.getUserIdRole((String)"");
        Map entries = this.accessControlList.getEntries().stream().collect(Collectors.groupingBy(AccessControlEntry::getRole, Collectors.toSet()));
        return entries.entrySet().stream().map(e -> {
            String role = (String)e.getKey();
            Set ace = (Set)e.getValue();
            if (role.startsWith(groupPrefix)) {
                return new GqlAccessControlGroupItem(ace);
            }
            if (role.startsWith(userPrefix)) {
                return new GqlAccessControlUserItem(ace);
            }
            return new GqlAccessControlGenericItem(ace);
        }).collect(Collectors.toList());
    }
}

