/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.type.output;

import java.util.Set;
import org.opencastproject.security.api.AccessControlEntry;

public abstract class AbstractAccessControlItem {
    private final Set<AccessControlEntry> accessControlEntries;
    private final String uniqueRole;

    public AbstractAccessControlItem(AccessControlEntry accessControlEntry) {
        this(Set.of(accessControlEntry));
    }

    public AbstractAccessControlItem(Set<AccessControlEntry> accessControlEntries) {
        String uniqueRole = accessControlEntries.iterator().next().getRole();
        for (AccessControlEntry ace : accessControlEntries) {
            if (uniqueRole.equals(ace.getRole())) continue;
            throw new IllegalArgumentException("All access control entries must have the same role");
        }
        this.uniqueRole = uniqueRole;
        this.accessControlEntries = accessControlEntries;
    }

    public String getUniqueRole() {
        return this.uniqueRole;
    }

    public Set<AccessControlEntry> getAccessControlEntries() {
        return this.accessControlEntries;
    }
}

