/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.servlet;

import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaPrinter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencastproject.graphql.schema.SchemaService;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;

@Component(service={HttpServlet.class, Servlet.class}, scope=ServiceScope.PROTOTYPE)
@HttpWhiteboardServletName(value="/graphql/schema.json")
@HttpWhiteboardServletPattern(value={"/graphql/schema.json"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class SchemaServlet
extends HttpServlet
implements Servlet {
    private static final String CONTENT_TYPE = "text/plain";
    private final SchemaService schemaService;
    private final SchemaPrinter schemaPrinter;
    private final SecurityService securityService;

    @Activate
    public SchemaServlet(@Reference SchemaService schemaService, @Reference SecurityService securityService) {
        this.schemaService = schemaService;
        this.securityService = securityService;
        SchemaPrinter.Options options = SchemaPrinter.Options.defaultOptions();
        options = options.descriptionsAsHashComments(false);
        options = options.includeDirectives(true);
        options = options.includeIntrospectionTypes(true);
        options = options.includeScalarTypes(true);
        options = options.includeSchemaDefinition(true);
        options = options.useAstDefinitions(false);
        this.schemaPrinter = new SchemaPrinter(options);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType(CONTENT_TYPE);
        if (this.securityService.getOrganization() == null) {
            resp.sendError(400, "Unable to determine organization");
            return;
        }
        try (PrintWriter out = resp.getWriter();){
            GraphQLSchema schema = this.schemaService.buildSchema(this.securityService.getOrganization());
            out.print(this.schemaPrinter.print(schema));
            out.flush();
        }
    }
}

