/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.opencastproject.graphql.execution.ExecutionService;
import org.opencastproject.graphql.util.GraphQLObjectMapper;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;

@Component(service={HttpServlet.class, Servlet.class}, scope=ServiceScope.PROTOTYPE)
@HttpWhiteboardServletName(value="/graphql")
@HttpWhiteboardServletPattern(value={"/graphql/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class GraphQLServlet
extends HttpServlet
implements Servlet {
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String EXTENSIONS = "extensions";
    private static final String APPLICATION_GRAPHQL = "application/graphql-response+json";
    static final String GRAPHQL_ENDPOINT = "/graphql";
    private final ExecutionService executionService;
    private final ObjectMapper objectMapper;

    @Activate
    public GraphQLServlet(@Reference ExecutionService executionService) {
        this.executionService = executionService;
        this.objectMapper = GraphQLObjectMapper.newInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String query = req.getParameter(QUERY);
        String operationName = req.getParameter(OPERATION_NAME);
        String variablesParameter = req.getParameter(VARIABLES);
        String extensionsParameter = req.getParameter(EXTENSIONS);
        Map<String, Object> variables = this.deserializeMap(variablesParameter);
        Map<String, Object> extensions = this.deserializeMap(extensionsParameter);
        this.validateQuery(query);
        ExecutionResult result = this.executionService.execute(query, operationName, variables, extensions);
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType(APPLICATION_GRAPHQL);
        try (PrintWriter out = resp.getWriter();){
            this.objectMapper.writeValue((Writer)out, (Object)result);
        }
    }

    private Map<String, Object> deserializeMap(String parameter) {
        Map<String, Object> variables = new HashMap<String, Object>();
        if (parameter != null && !parameter.isBlank()) {
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(this){};
            try {
                variables = (Map)this.objectMapper.readValue(parameter, (TypeReference)typeRef);
            }
            catch (JsonProcessingException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
        }
        return variables;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(this){};
        Map body = (Map)this.objectMapper.readValue((InputStream)req.getInputStream(), (TypeReference)typeRef);
        String query = GraphQLServlet.getAsString(QUERY, body);
        String operationName = GraphQLServlet.getAsString(OPERATION_NAME, body);
        Map<String, Object> variables = GraphQLServlet.getAsMap(VARIABLES, body);
        Map<String, Object> extensions = GraphQLServlet.getAsMap(EXTENSIONS, body);
        this.validateQuery(query);
        ExecutionResult result = this.executionService.execute(query, operationName, variables, extensions);
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.setContentType(APPLICATION_GRAPHQL);
        try (PrintWriter out = resp.getWriter();){
            this.objectMapper.writeValue((Writer)out, (Object)result.toSpecification());
        }
    }

    private static String getAsString(String key, Map<String, Object> map) {
        Object value = map.get(key);
        if (value != null && !(value instanceof String)) {
            throw new WebApplicationException("Invalid value for '" + key + "'", Response.Status.BAD_REQUEST);
        }
        return (String)value;
    }

    private static Map<String, Object> getAsMap(String key, Map<String, Object> map) {
        Object value = map.get(key);
        if (value != null && !(value instanceof Map)) {
            throw new WebApplicationException("Invalid value for '" + key + "'", Response.Status.BAD_REQUEST);
        }
        return (Map)value;
    }

    private void validateQuery(String query) {
        if (query == null || query.isBlank()) {
            throw new WebApplicationException("Invalid value for 'query'", Response.Status.BAD_REQUEST);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.corsHeaders(req, resp);
        resp.flushBuffer();
    }

    private void corsHeaders(HttpServletRequest req, HttpServletResponse resp) {
        resp.setHeader("Access-Control-Allow-Origin", this.originHeaderFromRequest(req));
        resp.setHeader("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
        resp.setHeader("Access-Control-Allow-Headers", "Accept, Content-Type, Origin");
    }

    private String originHeaderFromRequest(HttpServletRequest req) {
        return req != null && req.getHeader("Origin") != null ? req.getHeader("Origin") : "*";
    }
}

