/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.series;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.schema.DataFetchingEnvironment;
import org.opencastproject.graphql.datafetcher.series.SeriesDataFetcher;
import org.opencastproject.graphql.datafetcher.series.SeriesOffsetDataFetcher;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.series.GqlSeriesList;
import org.opencastproject.graphql.type.input.SeriesOrderByInput;
import org.opencastproject.graphql.type.output.Query;

@GraphQLTypeExtension(value=Query.class)
public final class SeriesQueryExtension {
    private SeriesQueryExtension() {
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Returns series list")
    public static GqlSeriesList allSeries(@GraphQLName(value="limit") Integer limit, @GraphQLName(value="offset") Integer offset, @GraphQLName(value="query") String query, @GraphQLName(value="orderBy") SeriesOrderByInput orderBy, DataFetchingEnvironment environment) {
        return (GqlSeriesList)new SeriesOffsetDataFetcher().get(environment);
    }

    @GraphQLField
    @GraphQLDescription(value="Returns a series by id")
    public static GqlSeries seriesById(@GraphQLName(value="id") @GraphQLNonNull String id, DataFetchingEnvironment environment) {
        return (GqlSeries)new SeriesDataFetcher(id).get(environment);
    }
}

