/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.series;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.schema.DataFetchingEnvironment;
import org.opencastproject.graphql.command.CreateSeriesCommand;
import org.opencastproject.graphql.command.UpdateSeriesAclCommand;
import org.opencastproject.graphql.command.UpdateSeriesCommand;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.type.input.AccessControlListInput;
import org.opencastproject.graphql.type.input.GqlCommonSeriesMetadataInput;
import org.opencastproject.graphql.type.input.Mutation;

@GraphQLTypeExtension(value=Mutation.class)
public final class SeriesMutationExtension {
    private SeriesMutationExtension() {
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Create series with metadata and acl")
    public static GqlSeries createSeries(@GraphQLName(value="metadata") @GraphQLNonNull GqlCommonSeriesMetadataInput seriesMetadataInput, @GraphQLName(value="acl") @GraphQLNonNull AccessControlListInput aclInput, DataFetchingEnvironment environment) {
        return (GqlSeries)CreateSeriesCommand.create(seriesMetadataInput, aclInput).environment(environment).build().execute();
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Update series metadata and optional the acl")
    public static GqlSeries updateSeries(@GraphQLName(value="id") @GraphQLNonNull String id, @GraphQLName(value="metadata") @GraphQLNonNull GqlCommonSeriesMetadataInput seriesMetadataInput, @GraphQLName(value="acl") AccessControlListInput aclInput, DataFetchingEnvironment environment) {
        return (GqlSeries)UpdateSeriesCommand.create(id, seriesMetadataInput).environment(environment).build().execute();
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Update series acl")
    public static GqlSeries updateSeriesAcl(@GraphQLName(value="id") @GraphQLNonNull String id, @GraphQLName(value="acl") @GraphQLNonNull AccessControlListInput aclInput, DataFetchingEnvironment environment) {
        return (GqlSeries)UpdateSeriesAclCommand.create(id).environment(environment).build().execute();
    }
}

