/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.series;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.graphql.series.GqlSeries;
import org.opencastproject.graphql.type.output.OffsetPageInfo;

@GraphQLName(value="SeriesList")
@GraphQLNonNull
@GraphQLDescription(value="A list of series")
public class GqlSeriesList {
    public static final String TYPE_NAME = "SeriesList";
    private final SearchResult<Series> searchResult;

    public GqlSeriesList(SearchResult<Series> searchResult) {
        this.searchResult = searchResult;
    }

    @GraphQLField
    @GraphQLNonNull
    public Long totalCount() {
        return this.searchResult.getHitCount();
    }

    @GraphQLField
    @GraphQLNonNull
    public OffsetPageInfo pageInfo() {
        return OffsetPageInfo.from(this.searchResult);
    }

    @GraphQLField
    @GraphQLNonNull
    public List<GqlSeries> nodes() {
        return Arrays.stream(this.searchResult.getItems()).map(SearchResultItem::getSource).map(GqlSeries::new).collect(Collectors.toList());
    }
}

