/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.series;

import graphql.annotations.annotationTypes.GraphQLDataFetcher;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.graphql.datafetcher.event.EventOffsetDataFetcher;
import org.opencastproject.graphql.datafetcher.series.CommonSeriesMetadataV2DataFetcher;
import org.opencastproject.graphql.event.GqlEventList;
import org.opencastproject.graphql.type.input.EventOrderByInput;
import org.opencastproject.graphql.type.output.GqlCommonSeriesMetadataV2;

@GraphQLName(value="Series")
@GraphQLDescription(value="A series of episodes.")
public class GqlSeries {
    public static final String TYPE_NAME = "Series";
    private final Series series;

    public GqlSeries(Series series) {
        this.series = series;
    }

    @GraphQLField
    public @GraphQLID @GraphQLNonNull String id() {
        return this.series.getIdentifier();
    }

    @GraphQLField
    @GraphQLNonNull
    public String title() {
        return this.series.getTitle();
    }

    @GraphQLField
    public String description() {
        return this.series.getDescription();
    }

    @GraphQLField
    public List<String> organizers() {
        return this.series.getOrganizers();
    }

    @GraphQLField
    public List<String> contributors() {
        return this.series.getContributors();
    }

    @GraphQLField
    public String creator() {
        return this.series.getCreator();
    }

    @GraphQLField
    public String license() {
        return this.series.getLicense();
    }

    @GraphQLField
    public String created() {
        return this.series.getCreatedDateTime().toInstant().toString();
    }

    @GraphQLField
    public List<String> publishers() {
        return this.series.getPublishers();
    }

    @GraphQLField
    public String rightsHolder() {
        return this.series.getRightsHolder();
    }

    public Series getSeries() {
        return this.series;
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="A list of events under the owner.")
    public GqlEventList events(@GraphQLName(value="limit") Integer limit, @GraphQLName(value="offset") Integer offset, @GraphQLName(value="query") String query, @GraphQLName(value="orderBy") EventOrderByInput orderBy, DataFetchingEnvironment environment) {
        return (GqlEventList)new EventOffsetDataFetcher().withSeriesId(this.series.getIdentifier()).get(environment);
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Common metadata of the series.")
    @GraphQLDataFetcher(value=CommonSeriesMetadataV2DataFetcher.class)
    public GqlCommonSeriesMetadataV2 commonMetadataV2(DataFetchingEnvironment environment) {
        return null;
    }
}

