/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.schema.builder;

import graphql.annotations.processor.GraphQLAnnotations;
import java.util.ArrayList;
import java.util.List;
import org.opencastproject.graphql.provider.GraphQLDynamicTypeProvider;
import org.opencastproject.security.api.Organization;

public class DynamicTypeBuilder {
    private final Organization organization;
    private GraphQLAnnotations annotations;
    private List<GraphQLDynamicTypeProvider> dynamicTypeProviders = new ArrayList<GraphQLDynamicTypeProvider>();

    public DynamicTypeBuilder(Organization organization) {
        this.organization = organization;
    }

    public DynamicTypeBuilder withAnnotations(GraphQLAnnotations annotations) {
        this.annotations = annotations;
        return this;
    }

    public DynamicTypeBuilder withDynamicTypeProviders(List<GraphQLDynamicTypeProvider> dynamicTypeProviders) {
        this.dynamicTypeProviders = dynamicTypeProviders;
        return this;
    }

    public void build() {
        if (this.dynamicTypeProviders != null && !this.dynamicTypeProviders.isEmpty()) {
            for (GraphQLDynamicTypeProvider typeProvider : this.dynamicTypeProviders) {
                if (typeProvider != null && typeProvider.getDynamicOutputTypes(this.organization, this.annotations) != null) {
                    typeProvider.getDynamicOutputTypes(this.organization, this.annotations).forEach((typeName, type) -> this.annotations.getContainer().getTypeRegistry().put(typeName, type));
                }
                if (typeProvider == null || typeProvider.getDynamicInputTypes(this.organization, this.annotations) == null) continue;
                typeProvider.getDynamicInputTypes(this.organization, this.annotations).forEach((typeName, type) -> this.annotations.getContainer().getTypeRegistry().put(typeName, type));
            }
        }
    }
}

