/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.schema;

import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opencastproject.graphql.provider.GraphQLAdditionalTypeProvider;
import org.opencastproject.graphql.provider.GraphQLCodeRegistryProvider;
import org.opencastproject.graphql.provider.GraphQLDynamicTypeProvider;
import org.opencastproject.graphql.provider.GraphQLExtensionProvider;
import org.opencastproject.graphql.provider.GraphQLFieldVisibilityProvider;
import org.opencastproject.graphql.provider.GraphQLMutationProvider;
import org.opencastproject.graphql.provider.GraphQLQueryProvider;
import org.opencastproject.graphql.provider.GraphQLTypeFunctionProvider;
import org.opencastproject.graphql.schema.SchemaBuilder;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryListener;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SchemaService.class, OrganizationDirectoryListener.class})
@ServiceDescription(value="GraphQL Schema Service")
public class SchemaService
implements OrganizationDirectoryListener {
    private static final Logger logger = LoggerFactory.getLogger(SchemaService.class);
    private final OrganizationDirectoryService organizationDirectoryService;
    private final Map<String, GraphQLSchema> schemas = new ConcurrentHashMap<String, GraphQLSchema>(8, 0.9f, 1);
    private final List<GraphQLQueryProvider> queryProviders = new CopyOnWriteArrayList<GraphQLQueryProvider>();
    private final List<GraphQLMutationProvider> mutationProviders = new CopyOnWriteArrayList<GraphQLMutationProvider>();
    private final List<GraphQLExtensionProvider> extensionsProviders = new CopyOnWriteArrayList<GraphQLExtensionProvider>();
    private final List<GraphQLAdditionalTypeProvider> additionalTypesProviders = new CopyOnWriteArrayList<GraphQLAdditionalTypeProvider>();
    private final List<GraphQLFieldVisibilityProvider> fieldVisibilityProviders = new CopyOnWriteArrayList<GraphQLFieldVisibilityProvider>();
    private final List<GraphQLDynamicTypeProvider> dynamicTypeProviders = new CopyOnWriteArrayList<GraphQLDynamicTypeProvider>();
    private final List<GraphQLTypeFunctionProvider> typeFunctionProviders = new CopyOnWriteArrayList<GraphQLTypeFunctionProvider>();
    private final List<GraphQLCodeRegistryProvider> codeRegistryProviders = new CopyOnWriteArrayList<GraphQLCodeRegistryProvider>();
    private final ScheduledExecutorService schemaUpdateExecutor;
    private int schemaUpdateTriggerDelay;
    private final Map<Organization, ScheduledFuture<?>> scheduledFutureMap = new ConcurrentHashMap();

    @Activate
    public SchemaService(@Reference OrganizationDirectoryService organizationDirectoryService, SchemaConfiguration config) {
        this.organizationDirectoryService = organizationDirectoryService;
        this.schemaUpdateExecutor = Executors.newSingleThreadScheduledExecutor(new SchemaUpdateThreadFactory());
        this.updateConfiguration(config);
    }

    @Modified
    public void updateConfiguration(SchemaConfiguration config) {
        if (config.schema_update_trigger_delay() < 0) {
            throw new IllegalArgumentException("Schema update trigger delay must be greater than or equal to 0");
        }
        this.schemaUpdateTriggerDelay = config.schema_update_trigger_delay();
        this.triggerSchemaUpdate();
    }

    @Deactivate
    protected void dispose() {
        this.scheduledFutureMap.forEach((organization, scheduledFuture) -> scheduledFuture.cancel(true));
        this.schemaUpdateExecutor.shutdown();
    }

    public GraphQLSchema get(String organizationId) {
        return this.schemas.get(organizationId);
    }

    public GraphQLSchema buildSchema(Organization organization) {
        logger.info("Building GraphQL schema for organization {}", (Object)organization.getId());
        SchemaBuilder schemaBuilder = new SchemaBuilder(organization).extensionProviders(this.extensionsProviders).dynamicTypeProviders(this.dynamicTypeProviders).queryProviders(this.queryProviders).mutationProviders(this.mutationProviders).codeRegistryProviders(this.codeRegistryProviders).additionalTypeProviders(this.additionalTypesProviders).fieldVisibilityProviders(this.fieldVisibilityProviders).typeFunctionProviders(this.typeFunctionProviders);
        return schemaBuilder.build();
    }

    private void triggerSchemaUpdate() {
        try {
            this.organizationDirectoryService.getOrganizations().forEach(this::triggerSchemaUpdate);
        }
        catch (RejectedExecutionException e) {
            logger.debug("Scheduler [shutdown: {}, terminated: {}] does not except jobs, skipping schema update trigger.", (Object)this.schemaUpdateExecutor.isShutdown(), (Object)this.schemaUpdateExecutor.isTerminated());
        }
    }

    private void triggerSchemaUpdate(Organization organization) {
        ScheduledFuture<?> future = this.scheduledFutureMap.get(organization);
        if (future != null) {
            future.cancel(true);
        }
        this.scheduledFutureMap.put(organization, this.schemaUpdateExecutor.schedule(() -> this.updateSchema(organization), (long)this.schemaUpdateTriggerDelay, TimeUnit.MILLISECONDS));
    }

    public void updateSchema(Organization organization) {
        try {
            this.schemas.put(organization.getId(), this.buildSchema(organization));
        }
        catch (Throwable t) {
            logger.error("Error building GraphQL schema for organization {}", (Object)organization.getId(), (Object)t);
        }
    }

    public void organizationRegistered(Organization organization) {
        logger.info("Trigger GraphQL schema update for organization {}", (Object)organization.getId());
        this.triggerSchemaUpdate(organization);
    }

    public void organizationUnregistered(Organization organization) {
        logger.info("Removing GraphQL schema for organization {}", (Object)organization.getId());
        this.schemas.remove(organization.getId());
    }

    public void organizationUpdated(Organization organization) {
        logger.trace("Organization {} updated", (Object)organization.getId());
        this.triggerSchemaUpdate(organization);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindQueryProvider(GraphQLQueryProvider provider) {
        this.queryProviders.add(provider);
        this.triggerSchemaUpdate();
    }

    public void unbindQueryProvider(GraphQLQueryProvider provider) {
        this.queryProviders.remove(provider);
        this.triggerSchemaUpdate();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindMutationProvider(GraphQLMutationProvider provider) {
        this.mutationProviders.add(provider);
        this.triggerSchemaUpdate();
    }

    public void unbindMutationProvider(GraphQLMutationProvider provider) {
        this.mutationProviders.remove(provider);
        this.triggerSchemaUpdate();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindExtensionProvider(GraphQLExtensionProvider provider) {
        this.extensionsProviders.add(provider);
        this.triggerSchemaUpdate();
    }

    public void unbindExtensionProvider(GraphQLExtensionProvider provider) {
        this.extensionsProviders.remove(provider);
        this.triggerSchemaUpdate();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindAdditionalTypeProvider(GraphQLAdditionalTypeProvider provider) {
        this.additionalTypesProviders.add(provider);
        this.triggerSchemaUpdate();
    }

    public void unbindAdditionalTypeProvider(GraphQLAdditionalTypeProvider provider) {
        this.additionalTypesProviders.remove(provider);
        this.triggerSchemaUpdate();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindFieldVisibilityProvider(GraphQLFieldVisibilityProvider provider) {
        this.fieldVisibilityProviders.add(provider);
        this.triggerSchemaUpdate();
    }

    public void unbindFieldVisibilityProvider(GraphQLFieldVisibilityProvider provider) {
        this.fieldVisibilityProviders.remove(provider);
        this.triggerSchemaUpdate();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindDynamicTypeProvider(GraphQLDynamicTypeProvider provider) {
        this.dynamicTypeProviders.add(provider);
        this.triggerSchemaUpdate();
    }

    public void unbindDynamicTypeProvider(GraphQLDynamicTypeProvider provider) {
        this.dynamicTypeProviders.remove(provider);
        this.triggerSchemaUpdate();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindTypeFunctionProvider(GraphQLTypeFunctionProvider provider) {
        this.typeFunctionProviders.add(provider);
        this.triggerSchemaUpdate();
    }

    public void unbindTypeFunctionProvider(GraphQLTypeFunctionProvider provider) {
        this.typeFunctionProviders.remove(provider);
        this.triggerSchemaUpdate();
    }

    public static class SchemaUpdateThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "GraphQL-Schema-Update-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }

    @ObjectClassDefinition
    public static @interface SchemaConfiguration {
        public int schema_update_trigger_delay() default 3000;
    }
}

