/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.schema;

import graphql.annotations.AnnotationsSchemaCreator;
import graphql.annotations.processor.GraphQLAnnotations;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Objects;
import org.opencastproject.graphql.directive.RolesAllowed;
import org.opencastproject.graphql.provider.GraphQLAdditionalTypeProvider;
import org.opencastproject.graphql.provider.GraphQLCodeRegistryProvider;
import org.opencastproject.graphql.provider.GraphQLDynamicTypeProvider;
import org.opencastproject.graphql.provider.GraphQLExtensionProvider;
import org.opencastproject.graphql.provider.GraphQLFieldVisibilityProvider;
import org.opencastproject.graphql.provider.GraphQLMutationProvider;
import org.opencastproject.graphql.provider.GraphQLQueryProvider;
import org.opencastproject.graphql.provider.GraphQLTypeFunctionProvider;
import org.opencastproject.graphql.schema.builder.AdditionalTypeBuilder;
import org.opencastproject.graphql.schema.builder.DynamicTypeBuilder;
import org.opencastproject.graphql.schema.builder.ExtensionBuilder;
import org.opencastproject.graphql.schema.builder.TypeFunctionBuilder;
import org.opencastproject.graphql.type.input.Mutation;
import org.opencastproject.graphql.type.output.Query;
import org.opencastproject.security.api.Organization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SchemaBuilder.class);
    private GraphQLAnnotations annotations;
    private final Organization organization;
    private final ExtensionBuilder extensionBuilder;
    private final DynamicTypeBuilder dynamicTypeBuilder;
    private final AdditionalTypeBuilder additionalTypeBuilder;
    private final TypeFunctionBuilder typeFunctionBuilder;

    public SchemaBuilder(Organization organization) {
        Objects.requireNonNull(organization, "organization cannot be null");
        this.organization = organization;
        this.dynamicTypeBuilder = new DynamicTypeBuilder(organization);
        this.extensionBuilder = new ExtensionBuilder();
        this.additionalTypeBuilder = new AdditionalTypeBuilder();
        this.typeFunctionBuilder = new TypeFunctionBuilder();
    }

    public GraphQLSchema build() {
        this.annotations = new GraphQLAnnotations();
        this.annotations.getContainer().setInputPrefix("");
        this.annotations.getContainer().setInputSuffix("");
        GraphQLSchema.Builder builder = GraphQLSchema.newSchema();
        this.typeFunctionBuilder.withAnnotations(this.annotations).build();
        this.extensionBuilder.withAnnotations(this.annotations).build();
        this.dynamicTypeBuilder.withAnnotations(this.annotations).build();
        AnnotationsSchemaCreator.Builder annotationsSchema = AnnotationsSchemaCreator.newAnnotationsSchema();
        this.additionalTypeBuilder.withAnnotationSchema(annotationsSchema).build();
        return annotationsSchema.setGraphQLSchemaBuilder(builder).query(Query.class).mutation(Mutation.class).setAnnotationsProcessor(this.annotations).directive(RolesAllowed.class).build();
    }

    public SchemaBuilder extensionProviders(List<GraphQLExtensionProvider> extensionProviders) {
        this.extensionBuilder.withExtensionProviders(extensionProviders);
        return this;
    }

    public SchemaBuilder dynamicTypeProviders(List<GraphQLDynamicTypeProvider> dynamicTypeProviders) {
        this.dynamicTypeBuilder.withDynamicTypeProviders(dynamicTypeProviders);
        return this;
    }

    public SchemaBuilder queryProviders(List<GraphQLQueryProvider> queryProviders) {
        return this;
    }

    public SchemaBuilder mutationProviders(List<GraphQLMutationProvider> mutationProviders) {
        return this;
    }

    public SchemaBuilder codeRegistryProviders(List<GraphQLCodeRegistryProvider> codeRegistryProviders) {
        return this;
    }

    public SchemaBuilder additionalTypeProviders(List<GraphQLAdditionalTypeProvider> additionalTypesProviders) {
        this.additionalTypeBuilder.withAdditionalTypeProviders(additionalTypesProviders);
        return this;
    }

    public SchemaBuilder fieldVisibilityProviders(List<GraphQLFieldVisibilityProvider> fieldVisibilityProviders) {
        return this;
    }

    public SchemaBuilder typeFunctionProviders(List<GraphQLTypeFunctionProvider> typeFunctionProviders) {
        this.typeFunctionBuilder.withTypeFunctionProviders(typeFunctionProviders);
        return this;
    }
}

