/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.scalar;

import graphql.GraphQLContext;
import graphql.execution.CoercedVariables;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.function.Function;

public final class DurationScalar {
    public static final GraphQLScalarType INSTANCE;

    private DurationScalar() {
    }

    static {
        Coercing<Duration, String> coercing = new Coercing<Duration, String>(){

            public String serialize(Object dataFetcherResult, GraphQLContext graphQLContext, Locale locale) throws CoercingSerializeException {
                Duration duration;
                if (dataFetcherResult instanceof Duration) {
                    duration = (Duration)dataFetcherResult;
                } else if (dataFetcherResult instanceof String) {
                    duration = this.parseDuration((String)dataFetcherResult, CoercingSerializeException::new);
                } else if (dataFetcherResult instanceof Long) {
                    duration = Duration.of((Long)dataFetcherResult, ChronoUnit.MILLIS);
                } else {
                    throw new CoercingSerializeException("Expected something we can convert to 'java.time.Duration' but was '" + dataFetcherResult.getClass().getSimpleName() + "'.");
                }
                return duration.toString();
            }

            public Duration parseValue(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingParseValueException {
                Duration duration;
                if (input instanceof Duration) {
                    duration = (Duration)input;
                } else if (input instanceof String) {
                    duration = this.parseDuration((String)input, CoercingParseValueException::new);
                } else if (input instanceof Long) {
                    duration = Duration.of((Long)input, ChronoUnit.MILLIS);
                } else {
                    throw new CoercingSerializeException("Expected something we can convert to 'java.time.Duration' but was '" + input.getClass().getSimpleName() + "'.");
                }
                return duration;
            }

            public Duration parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext graphQLContext, Locale locale) throws CoercingParseLiteralException {
                if (input instanceof StringValue) {
                    return this.parseDuration(((StringValue)input).getValue(), CoercingParseLiteralException::new);
                }
                throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + input.getClass().getSimpleName() + "'.");
            }

            public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
                String s = this.serialize(input, graphQLContext, locale);
                return StringValue.newStringValue((String)s).build();
            }

            private Duration parseDuration(String input, Function<String, RuntimeException> exceptionMaker) {
                try {
                    if (input.isEmpty()) {
                        return Duration.ZERO;
                    }
                    if (!input.contains("P")) {
                        return Duration.of(Long.parseLong(input), ChronoUnit.MILLIS);
                    }
                    return Duration.parse(input);
                }
                catch (Exception e) {
                    throw exceptionMaker.apply("Invalid RFC-3339 compliant Duration value: " + input);
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Duration").description("A slightly refined version of RFC-3339 compliant DateTime Scalar").specifiedByUrl("https://scalars.opencast.org/duration").coercing((Coercing)coercing).build();
    }
}

