/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.graphql.listprovider;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.schema.DataFetchingEnvironment;
import org.opencastproject.graphql.defaultvalue.DefaultFalse;
import org.opencastproject.graphql.exception.GraphQLNotFoundException;
import org.opencastproject.graphql.exception.GraphQLRuntimeException;
import org.opencastproject.graphql.execution.context.OpencastContext;
import org.opencastproject.graphql.execution.context.OpencastContextManager;
import org.opencastproject.graphql.listprovider.GqlListProvider;
import org.opencastproject.graphql.type.output.Query;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ListProviderNotFoundException;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.list.query.StringListFilter;

@GraphQLTypeExtension(value=Query.class)
public final class ListProviderQueryExtension {
    private ListProviderQueryExtension() {
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Returns list provider")
    public static GqlListProvider listProvider(@GraphQLName(value="name") @GraphQLNonNull String name, @GraphQLName(value="limit") Integer limit, @GraphQLName(value="offset") Integer offset, @GraphQLName(value="filter") String filter, @GraphQLName(value="inverse") @GraphQLDescription(value="Exchange") @GraphQLDefaultValue(value=DefaultFalse.class) Boolean inverse, DataFetchingEnvironment environment) {
        OpencastContext context = OpencastContextManager.enrichContext(environment);
        ListProvidersService listProvider = context.getService(ListProvidersService.class);
        ResourceListQueryImpl resourceListQuery = new ResourceListQueryImpl();
        resourceListQuery.setLimit(limit);
        resourceListQuery.setOffset(offset);
        ListProviderQueryExtension.addRequestFiltersToQuery(filter, resourceListQuery);
        try {
            return new GqlListProvider(listProvider.getList(name, (ResourceListQuery)resourceListQuery, inverse.booleanValue()), listProvider.isTranslatable(name));
        }
        catch (ListProviderNotFoundException e) {
            throw new GraphQLNotFoundException(e.getMessage());
        }
        catch (ListProviderException e) {
            throw new GraphQLRuntimeException(e);
        }
    }

    private static void addRequestFiltersToQuery(String filterString, ResourceListQueryImpl query) {
        if (filterString == null) {
            return;
        }
        for (String filter : filterString.split(",")) {
            String[] splitFilter = filter.split(":", 2);
            if (splitFilter.length != 2) continue;
            query.addFilter((ResourceListFilter)new StringListFilter(splitFilter[0].trim(), splitFilter[1].trim()));
        }
    }
}

